/*
 * Decompiled with CFR 0.152.
 */
package org.cauthon.burlant.world;

import a.e.a.b;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.cauthon.burlant.BurlanT;
import org.cauthon.burlant.d.c;
import org.cauthon.burlant.d.e;
import org.cauthon.burlant.d.s;
import org.cauthon.burlant.i.f;
import org.cauthon.burlant.k.d;
import org.cauthon.burlant.town.i;
import org.cauthon.burlant.town.l;
import org.cauthon.burlant.town.p;
import org.cauthon.burlant.world.a;

public final class WorldProtectionListener
implements Listener {
    private final BurlanT plugin;
    private final p townManager;
    private final f territoryManager;
    private final c configManager;
    private final i plotManager;
    private final a miningManager;
    private final Map<UUID, Player> thrownItems;
    private final Map<UUID, Player> shotArrows;
    private final Map<Location, Player> waterSources;
    private final ConcurrentHashMap<UUID, Map<String, Long>> lastErrorTime;
    private final long ERROR_COOLDOWN;

    /*
     * WARNING - void declaration
     */
    public WorldProtectionListener(BurlanT plugin, p townManager, f territoryManager, c configManager, i plotManager, a miningManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        a.e.b.e.c((Object)plugin, "");
        a.e.b.e.c(townManager, "");
        a.e.b.e.c(territoryManager, "");
        a.e.b.e.c(configManager, "");
        a.e.b.e.c(plotManager, "");
        a.e.b.e.c(miningManager, "");
        this.plugin = var1_1;
        this.townManager = var2_2;
        this.territoryManager = var3_3;
        this.configManager = configManager;
        this.plotManager = plotManager;
        this.miningManager = miningManager;
        this.thrownItems = new LinkedHashMap();
        this.shotArrows = new LinkedHashMap();
        this.waterSources = new LinkedHashMap();
        this.lastErrorTime = new ConcurrentHashMap();
        this.ERROR_COOLDOWN = 2000L;
    }

    /*
     * WARNING - void declaration
     */
    private final void sendErrorWithCooldown(Player player, String category, String message) {
        long l2;
        long l3 = System.currentTimeMillis();
        Map map = this.lastErrorTime.computeIfAbsent(player.getUniqueId(), arg_0 -> WorldProtectionListener.sendErrorWithCooldown$lambda$0(g.a, arg_0));
        a.e.b.e.b(map, "");
        Map map2 = map;
        String string = category + ":" + message;
        Long l4 = (Long)map2.get(string);
        long l5 = l2 = l4 != null ? l4 : 0L;
        if (l3 - l2 > this.ERROR_COOLDOWN) {
            void var3_3;
            void var2_2;
            void var1_1;
            org.cauthon.burlant.j.a.a.d((CommandSender)var1_1, (String)var2_2, (String)var3_3);
            Long l6 = l3;
            map2.put(string, l6);
            if (map2.size() > 10) {
                long l7 = l3 - 300000L;
                map2.entrySet().removeIf(arg_0 -> WorldProtectionListener.sendErrorWithCooldown$lambda$1(new b<Map.Entry<String, Long>, Boolean>(l7){
                    private /* synthetic */ long a;
                    {
                        this.a = l2;
                        super(1);
                    }

                    @Override
                    public final /* synthetic */ Object a(Object object) {
                        Map.Entry entry = (Map.Entry)object;
                        object = this;
                        a.e.b.e.c(entry, "");
                        return ((Number)entry.getValue()).longValue() < object.a;
                    }
                }, arg_0));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasPermission(Player player, Location location, String permission) {
        void var2_2;
        void var3_3;
        void var1_1;
        Set<String> set;
        block32: {
            Object object;
            Object object2;
            Object object3;
            block29: {
                block31: {
                    block30: {
                        object3 = location.getChunk().getX() + "," + location.getChunk().getZ();
                        String string = player.getName();
                        a.e.b.e.b(string, "");
                        object2 = this.townManager.a(string);
                        set = this.plotManager.a((String)object3);
                        if (set == null) break block29;
                        object3 = this.townManager.e(((org.cauthon.burlant.town.g)((Object)set)).getTownId());
                        if (a.e.b.e.a((Object)((org.cauthon.burlant.town.g)((Object)set)).getOwner(), (Object)player.getName())) break block30;
                        Object object4 = object3;
                        if (!a.e.b.e.a((Object)(object4 != null ? ((l)object4).getLeader() : null), (Object)player.getName())) break block31;
                    }
                    return true;
                }
                if ((set = ((org.cauthon.burlant.town.g)((Object)set)).getPermissions().get(permission)) != null) {
                    if (set.contains("player:" + player.getName())) {
                        return true;
                    }
                    if (object2 != null) {
                        if (set.contains("town:" + ((l)object2).getId())) {
                            return true;
                        }
                        object3 = BurlanT.Companion.a().getNationManager().c((l)object2);
                        if (object3 != null && set.contains("nation:" + ((org.cauthon.burlant.f.a)object3).getId())) {
                            return true;
                        }
                    }
                }
                return false;
            }
            org.cauthon.burlant.i.b b2 = this.territoryManager.a((String)object3);
            if (b2 == null) {
                return true;
            }
            object3 = b2;
            l l2 = this.townManager.c(((org.cauthon.burlant.i.b)object3).getId());
            if (l2 == null) {
                return true;
            }
            set = l2;
            object3 = this.townManager.d(((org.cauthon.burlant.i.b)object3).getId());
            l l3 = object2;
            boolean bl = l3 != null ? l3.getId() == ((l)((Object)set)).getId() : false;
            if (bl && object3 == null) {
                return true;
            }
            if (object3 == null) break block32;
            l l4 = object2;
            object2 = l4 != null ? Integer.valueOf(l4.getId()) : null;
            int n2 = ((l)object3).getId();
            if (object2 != null && (Integer)object2 == n2) {
                object = this.configManager.c().v();
            } else {
                Object object5 = object2;
                n2 = ((l)((Object)set)).getId();
                object = object3 = object5 != null && (Integer)object5 == n2 ? this.configManager.c().w() : null;
            }
            if (object == null) break block32;
            if (switch (permission) {
                case "build" -> ((org.cauthon.burlant.d.g)object3).a();
                case "chest" -> ((org.cauthon.burlant.d.g)object3).b();
                case "interact" -> ((org.cauthon.burlant.d.g)object3).c();
                default -> {
                    boolean var5_6;
                    yield var5_6 = false;
                }
            }) {
                return true;
            }
        }
        String string = var1_1.getName();
        a.e.b.e.b(string, "");
        if (((l)((Object)set)).hasTownPermission(string, permission)) {
            return true;
        }
        return a.e.b.e.a((Object)var3_3, (Object)"build") && this.configManager.c().a() && a.i.g.b(var2_2.getBlock().getType().name(), "_FENCE", false, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasPlotPermission(Player player, Location location, String permission) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.hasPermission((Player)var1_1, (Location)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canInteract(Player player, Location location) {
        void var2_2;
        void var1_1;
        return this.hasPermission((Player)var1_1, (Location)var2_2, "interact");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canBreak(Player player, Location location) {
        void var2_2;
        void var1_1;
        return this.hasPermission((Player)var1_1, (Location)var2_2, "build");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canPlace(Player player, Location location) {
        void var2_2;
        void var1_1;
        return this.hasPermission((Player)var1_1, (Location)var2_2, "build");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canUseChests(Player player, Location location) {
        void var2_2;
        void var1_1;
        return this.hasPermission((Player)var1_1, (Location)var2_2, "chest");
    }

    @EventHandler
    public final void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player;
        a.e.b.e.c(event, "");
        Item item = event.getItemDrop();
        a.e.b.e.b(item, "");
        Item item2 = item;
        Player player2 = player.getPlayer();
        a.e.b.e.b(player2, "");
        player = player2;
        Map<UUID, Player> map = this.thrownItems;
        UUID uUID = item2.getUniqueId();
        a.e.b.e.b(uUID, "");
        map.put(uUID, player);
        new BukkitRunnable(this, item2){
            private /* synthetic */ WorldProtectionListener a;
            private /* synthetic */ Item b;
            {
                this.a = worldProtectionListener;
                this.b = item;
            }

            public final void run() {
                this.a.thrownItems.remove(this.b.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, 600L);
    }

    @EventHandler
    public final void onEntityShootBow(EntityShootBowEvent event) {
        a.e.b.e.c(event, "");
        if (event.getEntity() instanceof Player && event.getProjectile() instanceof Arrow) {
            Player player;
            Entity entity = event.getProjectile();
            a.e.b.e.a(entity);
            Arrow arrow = (Arrow)entity;
            LivingEntity livingEntity = player.getEntity();
            a.e.b.e.a(livingEntity);
            player = (Player)livingEntity;
            Map<UUID, Player> map = this.shotArrows;
            UUID uUID = arrow.getUniqueId();
            a.e.b.e.b(uUID, "");
            map.put(uUID, player);
            new BukkitRunnable(this, arrow){
                private /* synthetic */ WorldProtectionListener a;
                private /* synthetic */ Arrow b;
                {
                    this.a = worldProtectionListener;
                    this.b = arrow;
                }

                public final void run() {
                    this.a.shotArrows.remove(this.b.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, 600L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onBlockBreak(BlockBreakEvent event) {
        void var1_1;
        a.e.b.e.c(event, "");
        d d2 = this.plugin.getWarManager().a();
        if (d2 != null) {
            d2.a(event);
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        a.e.b.e.b(player, "");
        Location location = event.getBlock().getLocation();
        a.e.b.e.b(location, "");
        if (!this.canBreak(player, location)) {
            event.setCancelled(true);
            Player player2 = event.getPlayer();
            a.e.b.e.b(player2, "");
            this.sendErrorWithCooldown(player2, "Protection", "You cannot break blocks here.");
            return;
        }
        Block block = event.getBlock();
        a.e.b.e.b(block, "");
        Player player3 = var1_1.getPlayer();
        a.e.b.e.b(player3, "");
        this.miningManager.a(block, player3);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onBlockPlace(BlockPlaceEvent event) {
        a.e.b.e.c(event, "");
        Player player = event.getPlayer();
        a.e.b.e.b(player, "");
        Player player2 = player;
        Location location = event.getBlock().getLocation();
        a.e.b.e.b(location, "");
        Location location2 = location;
        if (!this.canPlace(player2, location2)) {
            long l2;
            event.setCancelled(true);
            long l3 = System.currentTimeMillis();
            Map<String, Long> map = this.lastErrorTime.get(player2.getUniqueId());
            long l4 = map != null && (map = map.get("War")) != null ? (Long)((Object)map) : (l2 = 0L);
            if (l3 - l2 > 100L) {
                this.sendErrorWithCooldown(player2, "Protection", "You cannot place blocks here.");
            }
            return;
        }
        e e2 = this.plugin.getConfigManager().h();
        if (e2.a() && e2.b() && e2.g().contains(event.getBlock().getType().name())) {
            event.getBlock().setMetadata("player_placed", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Boolean.TRUE));
        }
        d d2 = this.plugin.getWarManager().a();
        if (d2 != null) {
            void var1_1;
            d2.a((BlockPlaceEvent)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerInteract(PlayerInteractEvent event) {
        boolean bl;
        a.e.b.e.c(event, "");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        boolean bl2 = event.getAction() == Action.PHYSICAL;
        boolean bl3 = bl = event.getAction() == Action.RIGHT_CLICK_BLOCK;
        if (!bl2 && !bl) {
            return;
        }
        if (bl && !block2.getType().isInteractable()) {
            return;
        }
        if (block2.getType() == Material.CHEST || block2.getType() == Material.TRAPPED_CHEST) {
            Player player = event.getPlayer();
            a.e.b.e.b(player, "");
            Location location = block2.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canUseChests(player, location)) {
                event.setCancelled(true);
                Player player2 = event.getPlayer();
                a.e.b.e.b(player2, "");
                this.sendErrorWithCooldown(player2, "Protection", "You cannot open chests here.");
                return;
            }
        } else {
            Player player = event.getPlayer();
            a.e.b.e.b(player, "");
            Location location = block2.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract(player, location)) {
                event.setCancelled(true);
                if (bl) {
                    void var1_1;
                    Player player3 = var1_1.getPlayer();
                    a.e.b.e.b(player3, "");
                    this.sendErrorWithCooldown(player3, "Protection", "You cannot interact with this.");
                }
            }
        }
    }

    @EventHandler
    public final void onProjectileHit(ProjectileHitEvent event) {
        a.e.b.e.c(event, "");
        Block block = event.getHitBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        Projectile projectile = event.getEntity();
        a.e.b.e.a(projectile);
        Arrow arrow = (Arrow)projectile;
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        ProjectileSource projectileSource = arrow.getShooter();
        a.e.b.e.a(projectileSource);
        arrow = (Player)projectileSource;
        if (a.i.g.b(block2.getType().toString(), "_BUTTON", false, 2) || block2.getType() == Material.TARGET) {
            Location location = block2.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract((Player)arrow, location)) {
                ItemStack[] itemStackArray;
                itemStackArray.getEntity().remove();
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Material.ARROW, 1);
                arrow.getInventory().addItem(itemStackArray);
                this.sendErrorWithCooldown((Player)arrow, "Protection", "You cannot activate buttons in this territory.");
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> WorldProtectionListener.onProjectileHit$lambda$2(block2), 1L);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public final void onBlockPhysics(BlockPhysicsEvent event) {
        void var1_1;
        boolean bl;
        a.e.b.e.c(event, "");
        Block block = event.getBlock();
        a.e.b.e.b(block, "");
        Block block2 = block;
        if (!a.i.g.b(block.getType().toString(), "_PRESSURE_PLATE", false, 2)) return;
        Collection collection = block2.getLocation().getWorld().getNearbyEntities(block2.getBoundingBox());
        a.e.b.e.b(collection, "");
        Object object = collection;
        Object object2 = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (!(e2 instanceof Item)) continue;
            object2.add(e2);
        }
        object = (List)object2;
        if (object.isEmpty()) {
            return;
        }
        if (((Collection)(object = (Iterable)object)).isEmpty()) return;
        object2 = object.iterator();
        do {
            if (!object2.hasNext()) return;
            object = object2.next();
            object = (Item)object;
            if ((object = this.thrownItems.get(object.getUniqueId())) != null) {
                Location location = block2.getLocation();
                a.e.b.e.b(location, "");
                if (!this.canInteract((Player)object, location)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl2 = true;
        boolean bl3 = bl2;
        if (!bl2) return;
        var1_1.setCancelled(true);
    }

    @EventHandler
    public final void onEntityInteract(EntityInteractEvent event) {
        a.e.b.e.c(event, "");
        Block block = event.getBlock();
        a.e.b.e.b(block, "");
        Block block2 = block;
        if (event.getEntity() instanceof Item) {
            if (!a.i.g.b(block2.getType().toString(), "_PRESSURE_PLATE", false, 2)) {
                return;
            }
            Entity entity = event.getEntity();
            a.e.b.e.a(entity);
            Item item = (Item)entity;
            Player player = this.thrownItems.get(item.getUniqueId());
            if (player == null) {
                return;
            }
            Player player2 = player;
            Location location = block2.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract(player2, location)) {
                event.setCancelled(true);
            }
            return;
        }
        if (event.getEntity() instanceof Arrow) {
            if (!a.i.g.b(block2.getType().toString(), "_BUTTON", false, 2) && block2.getType() != Material.TARGET) {
                return;
            }
            Entity entity = event.getEntity();
            a.e.b.e.a(entity);
            Arrow arrow = (Arrow)entity;
            Player player = this.shotArrows.get(arrow.getUniqueId());
            if (player == null) {
                return;
            }
            Player player3 = player;
            Location location = block2.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract(player3, location)) {
                ItemStack[] itemStackArray;
                itemStackArray.setCancelled(true);
                arrow.remove();
                if (player3 instanceof Player) {
                    ItemStack[] itemStackArray2 = new ItemStack[1];
                    itemStackArray = itemStackArray2;
                    itemStackArray2[0] = new ItemStack(Material.ARROW, 1);
                    player3.getInventory().addItem(itemStackArray);
                    this.sendErrorWithCooldown(player3, "Protection", "You cannot activate buttons in this territory.");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        a.e.b.e.c(event, "");
        Player player = event.getPlayer();
        a.e.b.e.b(player, "");
        Location location = event.getRightClicked().getLocation();
        a.e.b.e.b(location, "");
        if (!this.canInteract(player, location)) {
            void var1_1;
            event.setCancelled(true);
            Player player2 = var1_1.getPlayer();
            a.e.b.e.b(player2, "");
            this.sendErrorWithCooldown(player2, "Protection", "You cannot interact with this entity.");
        }
    }

    @EventHandler
    public final void onBucketEmpty(PlayerBucketEmptyEvent event) {
        a.e.b.e.c(event, "");
        Player player = event.getPlayer();
        a.e.b.e.b(player, "");
        Location location = event.getBlock().getLocation();
        a.e.b.e.b(location, "");
        if (!this.canInteract(player, location)) {
            event.setCancelled(true);
            Player player2 = event.getPlayer();
            a.e.b.e.b(player2, "");
            this.sendErrorWithCooldown(player2, "Protection", "You cannot empty buckets here.");
            return;
        }
        if (event.getBucket() == Material.WATER_BUCKET || event.getBucket() == Material.LAVA_BUCKET) {
            Player player3;
            Location location2 = event.getBlock().getLocation();
            a.e.b.e.b(location2, "");
            Location location3 = location2;
            Map<Location, Player> map = this.waterSources;
            Player player4 = player3.getPlayer();
            a.e.b.e.b(player4, "");
            player3 = player4;
            map.put(location3, player3);
            new BukkitRunnable(this, location3){
                private /* synthetic */ WorldProtectionListener a;
                private /* synthetic */ Location b;
                {
                    this.a = worldProtectionListener;
                    this.b = location;
                }

                public final void run() {
                    this.a.waterSources.remove(this.b);
                }
            }.runTaskLater((Plugin)this.plugin, 600L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onBucketFill(PlayerBucketFillEvent event) {
        a.e.b.e.c(event, "");
        Player player = event.getPlayer();
        a.e.b.e.b(player, "");
        Location location = event.getBlock().getLocation();
        a.e.b.e.b(location, "");
        if (!this.canInteract(player, location)) {
            void var1_1;
            event.setCancelled(true);
            Player player2 = var1_1.getPlayer();
            a.e.b.e.b(player2, "");
            this.sendErrorWithCooldown(player2, "Protection", "You cannot fill buckets here.");
        }
    }

    @EventHandler
    public final void onBlockFromTo(BlockFromToEvent event) {
        a.e.b.e.c(event, "");
        Block block = event.getBlock();
        a.e.b.e.b(block, "");
        Block block2 = block;
        Block block3 = event.getToBlock();
        a.e.b.e.b(block3, "");
        Block block4 = block3;
        if ((block2.getType() == Material.WATER || block2.getType() == Material.LAVA) && (block2 = this.waterSources.get(block2.getLocation())) != null) {
            Map<Location, Player> map;
            Location location = block4.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract((Player)block2, location)) {
                map.setCancelled(true);
                return;
            }
            map = this.waterSources;
            Location location2 = block4.getLocation();
            a.e.b.e.b(location2, "");
            map.put(location2, (Player)block2);
            new BukkitRunnable(this, block4){
                private /* synthetic */ WorldProtectionListener a;
                private /* synthetic */ Block b;
                {
                    this.a = worldProtectionListener;
                    this.b = block;
                }

                public final void run() {
                    this.a.waterSources.remove(this.b.getLocation());
                }
            }.runTaskLater((Plugin)this.plugin, 600L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onEntityDamage(EntityDamageByEntityEvent event) {
        a.e.b.e.c(event, "");
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Entity entity = event.getEntity();
            a.e.b.e.a(entity);
            Player player = (Player)entity;
            Entity entity2 = event.getDamager();
            a.e.b.e.a(entity2);
            Player player2 = (Player)entity2;
            Location location = player.getLocation();
            a.e.b.e.b(location, "");
            if (!this.canInteract(player2, location)) {
                void var1_1;
                var1_1.setCancelled(true);
                this.sendErrorWithCooldown(player2, "Protection", "You cannot attack players in this territory.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onEntityExplode(EntityExplodeEvent event) {
        void var1_1;
        a.e.b.e.c(event, "");
        s s2 = this.configManager.c();
        if (!s2.x()) {
            return;
        }
        var1_1.blockList().removeIf(arg_0 -> WorldProtectionListener.onEntityExplode$lambda$4(new b<Block, Boolean>(this, s2){
            private /* synthetic */ WorldProtectionListener a;
            private /* synthetic */ s b;
            {
                this.a = worldProtectionListener;
                this.b = s2;
                super(1);
            }

            @Override
            public final /* synthetic */ Object a(Object object) {
                boolean bl;
                Object object2 = (Block)object;
                object = this;
                object2 = object2.getLocation().getChunk().getX() + "," + object2.getLocation().getChunk().getZ();
                org.cauthon.burlant.i.b b2 = object.a.territoryManager.a((String)object2);
                if (b2 == null) {
                    return Boolean.FALSE;
                }
                object2 = b2;
                l l2 = object.a.townManager.c(((org.cauthon.burlant.i.b)object2).getId());
                if (l2 == null) {
                    return Boolean.FALSE;
                }
                object2 = l2;
                if (object.b.y() && (bl = !((Collection)((l)object2).getEnemies()).isEmpty())) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map sendErrorWithCooldown$lambda$0(b $tmp0, Object p0) {
        void var1_1;
        b b2;
        a.e.b.e.c($tmp0, "");
        return (Map)b2.a(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean sendErrorWithCooldown$lambda$1(b $tmp0, Object p0) {
        void var1_1;
        b b2;
        a.e.b.e.c($tmp0, "");
        return (Boolean)b2.a(var1_1);
    }

    private static final void onProjectileHit$lambda$2(Block $block) {
        a.e.b.e.c($block, "");
        BlockData blockData = $block.getBlockData();
        a.e.b.e.b(blockData, "");
        BlockData blockData2 = blockData;
        if (blockData instanceof Switch && ((Switch)blockData2).isPowered()) {
            ((Switch)blockData2).setPowered(false);
            $block.setBlockData(blockData2);
            return;
        }
        if (blockData2 instanceof Powerable && ((Powerable)blockData2).isPowered()) {
            Block block;
            ((Powerable)blockData2).setPowered(false);
            block.setBlockData(blockData2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean onEntityExplode$lambda$4(b $tmp0, Object p0) {
        void var1_1;
        b b2;
        a.e.b.e.c($tmp0, "");
        return (Boolean)b2.a(var1_1);
    }
}

