/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json) {
        String string;
        return JsonParser.parseReader(new StringReader(string));
    }

    public static JsonElement parseReader(Reader reader) {
        try {
            Closeable closeable;
            closeable = new JsonReader((Reader)closeable);
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)closeable);
            if (!jsonElement.isJsonNull() && ((JsonReader)closeable).peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return jsonElement;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement parseReader(JsonReader reader) {
        boolean bl = reader.isLenient();
        reader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(reader);
            reader.setLenient(bl);
            return jsonElement;
        }
        catch (StackOverflowError stackOverflowError) {
            try {
                throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", stackOverflowError);
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", outOfMemoryError);
                }
            }
            catch (Throwable throwable) {
                JsonReader jsonReader;
                jsonReader.setLenient(bl);
                throw throwable;
            }
        }
    }

    @Deprecated
    public final JsonElement parse(String json) {
        return JsonParser.parseString(json);
    }

    @Deprecated
    public final JsonElement parse(Reader json) {
        return JsonParser.parseReader(json);
    }

    @Deprecated
    public final JsonElement parse(JsonReader json) {
        return JsonParser.parseReader(json);
    }
}

