/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.bind.a;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            ArrayTypeAdapter arrayTypeAdapter;
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            type = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> typeAdapter = gson.getAdapter(TypeToken.get(type));
            arrayTypeAdapter = new ArrayTypeAdapter((Gson)((Object)arrayTypeAdapter), typeAdapter, $Gson$Types.getRawType(type));
            return arrayTypeAdapter;
        }
    };
    private final Class<E> a;
    private final TypeAdapter<E> b;

    /*
     * WARNING - void declaration
     */
    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.b = new a<E>((Gson)var1_1, var2_2, componentType);
        this.a = var3_3;
    }

    @Override
    public final Object read(JsonReader in) {
        Object[] objectArray;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E e2 = this.b.read(in);
            arrayList.add(e2);
        }
        objectArray.endArray();
        int n2 = arrayList.size();
        if (this.a.isPrimitive()) {
            objectArray = Array.newInstance(this.a, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Array.set(objectArray, i2, arrayList.get(i2));
            }
            return objectArray;
        }
        objectArray = (Object[])Array.newInstance(this.a, n2);
        return arrayList.toArray(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Object array) {
        void var1_1;
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int n2 = Array.getLength(array);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = Array.get(array, i2);
            this.b.write(out, object);
        }
        var1_1.endArray();
    }
}

