/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.audience;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;

@FunctionalInterface
public interface ForwardingAudience
extends Audience {
    @ApiStatus.OverrideOnly
    public Iterable<? extends Audience> audiences();

    @Override
    default public Pointers pointers() {
        return Pointers.empty();
    }

    @Override
    default public Audience filterAudience(Predicate<? super Audience> filter) {
        ArrayList<Audience> arrayList = null;
        for (Audience audience : this.audiences()) {
            Audience audience2;
            if (!filter.test(audience) || (audience2 = audience.filterAudience(filter)) == Audience.empty()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Audience>();
            }
            arrayList.add(audience2);
        }
        if (arrayList != null) {
            return Audience.audience(arrayList);
        }
        return Audience.empty();
    }

    @Override
    default public void forEachAudience(Consumer<? super Audience> action) {
        for (Audience audience : this.audiences()) {
            audience.forEachAudience(action);
        }
    }

    @Override
    default public void sendMessage(Component message) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(message);
        }
    }

    @Override
    default public void sendMessage(Component message, ChatType.Bound boundChatType) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(message, boundChatType);
        }
    }

    @Override
    default public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(signedMessage, boundChatType);
        }
    }

    @Override
    default public void deleteMessage(SignedMessage.Signature signature) {
        for (Audience audience : this.audiences()) {
            audience.deleteMessage(signature);
        }
    }

    @Override
    @Deprecated
    default public void sendMessage(Identified source, Component message, MessageType type) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(source, message, type);
        }
    }

    @Override
    @Deprecated
    default public void sendMessage(Identity source, Component message, MessageType type) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(source, message, type);
        }
    }

    @Override
    default public void sendActionBar(Component message) {
        for (Audience audience : this.audiences()) {
            audience.sendActionBar(message);
        }
    }

    @Override
    default public void sendPlayerListHeader(Component header) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListHeader(header);
        }
    }

    @Override
    default public void sendPlayerListFooter(Component footer) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListFooter(footer);
        }
    }

    @Override
    default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        for (Audience audience : this.audiences()) {
            audience.sendPlayerListHeaderAndFooter(header, footer);
        }
    }

    @Override
    default public <T> void sendTitlePart(TitlePart<T> part, T value) {
        for (Audience audience : this.audiences()) {
            audience.sendTitlePart(part, value);
        }
    }

    @Override
    default public void clearTitle() {
        for (Audience audience : this.audiences()) {
            audience.clearTitle();
        }
    }

    @Override
    default public void resetTitle() {
        for (Audience audience : this.audiences()) {
            audience.resetTitle();
        }
    }

    @Override
    default public void showBossBar(BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.showBossBar(bar);
        }
    }

    @Override
    default public void hideBossBar(BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.hideBossBar(bar);
        }
    }

    @Override
    default public void playSound(Sound sound) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound);
        }
    }

    @Override
    default public void playSound(Sound sound, double x2, double y2, double z2) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound, x2, y2, z2);
        }
    }

    @Override
    default public void playSound(Sound sound, Sound.Emitter emitter) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound, emitter);
        }
    }

    @Override
    default public void stopSound(SoundStop stop) {
        for (Audience audience : this.audiences()) {
            audience.stopSound(stop);
        }
    }

    @Override
    default public void openBook(Book book) {
        for (Audience audience : this.audiences()) {
            audience.openBook(book);
        }
    }

    public static interface Single
    extends ForwardingAudience {
        @ApiStatus.OverrideOnly
        public Audience audience();

        @Override
        @Deprecated
        default public Iterable<? extends Audience> audiences() {
            return Collections.singleton(this.audience());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public <T> Optional<T> get(Pointer<T> pointer) {
            void var1_1;
            return this.audience().get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public <T> T getOrDefault(Pointer<T> pointer, T defaultValue) {
            void var2_2;
            void var1_1;
            return this.audience().getOrDefault(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public <T> @UnknownNullability T getOrDefaultFrom(Pointer<T> pointer, Supplier<? extends T> defaultValue) {
            void var2_2;
            void var1_1;
            return this.audience().getOrDefaultFrom(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public Audience filterAudience(Predicate<? super Audience> filter) {
            void var1_1;
            Audience audience = this.audience();
            if (var1_1.test(audience)) {
                return this;
            }
            return Audience.empty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void forEachAudience(Consumer<? super Audience> action) {
            void var1_1;
            this.audience().forEachAudience((Consumer<? super Audience>)var1_1);
        }

        @Override
        default public Pointers pointers() {
            return this.audience().pointers();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendMessage(Component message) {
            void var1_1;
            this.audience().sendMessage((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendMessage(Component message, ChatType.Bound boundChatType) {
            void var2_2;
            void var1_1;
            this.audience().sendMessage((Component)var1_1, (ChatType.Bound)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
            void var2_2;
            void var1_1;
            this.audience().sendMessage((SignedMessage)var1_1, (ChatType.Bound)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void deleteMessage(SignedMessage.Signature signature) {
            void var1_1;
            this.audience().deleteMessage((SignedMessage.Signature)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        default public void sendMessage(Identified source, Component message, MessageType type) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.audience().sendMessage((Identified)var1_1, (Component)var2_2, (MessageType)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        default public void sendMessage(Identity source, Component message, MessageType type) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.audience().sendMessage((Identity)var1_1, (Component)var2_2, (MessageType)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendActionBar(Component message) {
            void var1_1;
            this.audience().sendActionBar((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendPlayerListHeader(Component header) {
            void var1_1;
            this.audience().sendPlayerListHeader((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendPlayerListFooter(Component footer) {
            void var1_1;
            this.audience().sendPlayerListFooter((Component)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
            void var2_2;
            void var1_1;
            this.audience().sendPlayerListHeaderAndFooter((Component)var1_1, (Component)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public <T> void sendTitlePart(TitlePart<T> part, T value) {
            void var2_2;
            void var1_1;
            this.audience().sendTitlePart(var1_1, var2_2);
        }

        @Override
        default public void clearTitle() {
            this.audience().clearTitle();
        }

        @Override
        default public void resetTitle() {
            this.audience().resetTitle();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void showBossBar(BossBar bar) {
            void var1_1;
            this.audience().showBossBar((BossBar)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void hideBossBar(BossBar bar) {
            void var1_1;
            this.audience().hideBossBar((BossBar)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void playSound(Sound sound) {
            void var1_1;
            this.audience().playSound((Sound)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void playSound(Sound sound, double x2, double y2, double z2) {
            void var2_2;
            void var1_1;
            this.audience().playSound((Sound)var1_1, (double)var2_2, y2, z2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void playSound(Sound sound, Sound.Emitter emitter) {
            void var2_2;
            void var1_1;
            this.audience().playSound((Sound)var1_1, (Sound.Emitter)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void stopSound(SoundStop stop) {
            void var1_1;
            this.audience().stopSound((SoundStop)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public void openBook(Book book) {
            void var1_1;
            this.audience().openBook((Book)var1_1);
        }
    }
}

