/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.sound;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.a.b;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.sound.a;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface Sound
extends b {
    public static Builder sound() {
        return new a.a();
    }

    public static Builder sound(Sound existing) {
        Sound sound;
        return new a.a(sound);
    }

    public static Sound sound(Consumer<Builder> configurer) {
        Consumer<Builder> consumer;
        return (Sound)AbstractBuilder.configureAndBuild(Sound.sound(), consumer);
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Key name, Source source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        Key key;
        return (Sound)Sound.sound().type(key).source((Source)var1_1).volume((float)var2_2).pitch((float)var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Type type, Source source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        Type type2;
        Objects.requireNonNull(type, "type");
        return Sound.sound(type2.key(), (Source)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Supplier<? extends Type> type, Source source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        Supplier<? extends Type> supplier;
        return (Sound)Sound.sound().type(supplier).source((Source)var1_1).volume((float)var2_2).pitch((float)var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Key name, Source.Provider source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Sound.sound(name, var1_1.soundSource(), (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Type type, Source.Provider source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Sound.sound(type, var1_1.soundSource(), (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Sound sound(Supplier<? extends Type> type, Source.Provider source, float volume, float pitch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Sound.sound(type, var1_1.soundSource(), (float)var2_2, (float)var3_3);
    }

    public Key name();

    public Source source();

    public float volume();

    public float pitch();

    public OptionalLong seed();

    public SoundStop asStop();

    public static interface Builder
    extends AbstractBuilder<Sound> {
        public Builder type(Key var1);

        public Builder type(Type var1);

        public Builder type(Supplier<? extends Type> var1);

        public Builder source(Source var1);

        public Builder source(Source.Provider var1);

        public Builder volume(@Range(from=0L, to=0x7FFFFFFFL) float var1);

        public Builder pitch(@Range(from=-1L, to=1L) float var1);

        public Builder seed(long var1);

        public Builder seed(OptionalLong var1);
    }

    public static interface Emitter {
        public static Emitter self() {
            return a.a;
        }
    }

    public static interface Type
    extends Keyed {
        @Override
        public Key key();
    }

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice");

        public static final Index<String, Source> NAMES;
        private final String a;

        /*
         * WARNING - void declaration
         */
        private Source(String name) {
            void var3_3;
            this.a = var3_3;
        }

        static {
            NAMES = Index.create(Source.class, source -> source.a);
        }

        public static interface Provider {
            public Source soundSource();
        }
    }
}

