/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.kyori.a.b;
import net.kyori.a.c;
import net.kyori.adventure.internal.Internals;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

public final class HoverEvent<V>
implements b,
HoverEventSource<V>,
StyleBuilderApplicable {
    private final Action<V> a;
    private final V b;

    public static HoverEvent<Component> showText(ComponentLike text) {
        return HoverEvent.showText(text.asComponent());
    }

    public static HoverEvent<Component> showText(Component text) {
        Component component;
        return new HoverEvent<Component>(Action.SHOW_TEXT, component);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowItem> showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
        void var1_1;
        return HoverEvent.showItem(item, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowItem> showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
        void var1_1;
        return HoverEvent.showItem(item, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowItem> showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
        void var2_2;
        void var1_1;
        return HoverEvent.showItem(ShowItem.of(item, (int)var1_1, (BinaryTagHolder)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowItem> showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
        void var2_2;
        void var1_1;
        return HoverEvent.showItem(ShowItem.of(item, (int)var1_1, (BinaryTagHolder)var2_2));
    }

    public static HoverEvent<ShowItem> showItem(ShowItem item) {
        ShowItem showItem;
        return new HoverEvent<ShowItem>(Action.SHOW_ITEM, showItem);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowEntity> showEntity(Key type, UUID id) {
        void var1_1;
        return HoverEvent.showEntity(type, (UUID)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowEntity> showEntity(Keyed type, UUID id) {
        void var1_1;
        return HoverEvent.showEntity(type, (UUID)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowEntity> showEntity(Key type, UUID id, Component name) {
        void var2_2;
        void var1_1;
        return HoverEvent.showEntity(ShowEntity.of(type, (UUID)var1_1, (Component)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static HoverEvent<ShowEntity> showEntity(Keyed type, UUID id, Component name) {
        void var2_2;
        void var1_1;
        return HoverEvent.showEntity(ShowEntity.of(type, (UUID)var1_1, (Component)var2_2));
    }

    public static HoverEvent<ShowEntity> showEntity(ShowEntity entity) {
        ShowEntity showEntity;
        return new HoverEvent<ShowEntity>(Action.SHOW_ENTITY, showEntity);
    }

    @Deprecated
    public static HoverEvent<String> showAchievement(String value) {
        String string;
        return new HoverEvent<String>(Action.SHOW_ACHIEVEMENT, string);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> HoverEvent<V> hoverEvent(Action<V> action, V value) {
        void var1_1;
        Action<V> action2;
        return new HoverEvent<void>(action2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private HoverEvent(Action<V> action, V value) {
        void var2_2;
        void var1_1;
        this.a = (Action)Objects.requireNonNull(var1_1, "action");
        this.b = Objects.requireNonNull(var2_2, "value");
    }

    public final Action<V> action() {
        return this.a;
    }

    public final V value() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public final HoverEvent<V> value(V value) {
        void var1_1;
        return new HoverEvent<void>(this.a, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <C> HoverEvent<V> withRenderedValue(ComponentRenderer<C> renderer, C context) {
        void var2_2;
        V v2;
        V v3 = this.b;
        v2 = ((Action)this.a).d.a(v2, var2_2, v3);
        if (v2 != v3) {
            return new HoverEvent<V>(this.a, v2);
        }
        return this;
    }

    @Override
    public final HoverEvent<V> asHoverEvent() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HoverEvent<V> asHoverEvent(UnaryOperator<V> op) {
        void var1_1;
        if (op == UnaryOperator.identity()) {
            return this;
        }
        return new HoverEvent<V>(this.a, var1_1.apply(this.b));
    }

    @Override
    public final void styleApply(Style.Builder style) {
        style.hoverEvent((HoverEventSource)this);
    }

    public final boolean equals(Object other) {
        HoverEvent hoverEvent;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        hoverEvent = hoverEvent;
        return this.a == hoverEvent.a && this.b.equals(hoverEvent.b);
    }

    public final int hashCode() {
        int n2 = this.a.hashCode();
        n2 = n2 * 31 + this.b.hashCode();
        return n2;
    }

    @Override
    public final Stream<? extends c> examinableProperties() {
        return Stream.of(c.a("action", this.a), c.a("value", this.b));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    public static final class Action<V> {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", Component.class, true, new a<Component>(){

            @Override
            public final /* synthetic */ Object a(ComponentRenderer componentRenderer, Object object, Object object2) {
                object2 = (Component)object2;
                return componentRenderer.render((Component)object2, object);
            }
        });
        public static final Action<ShowItem> SHOW_ITEM = new Action<ShowItem>("show_item", ShowItem.class, true, new a<ShowItem>(){});
        public static final Action<ShowEntity> SHOW_ENTITY = new Action<ShowEntity>("show_entity", ShowEntity.class, true, new a<ShowEntity>(){

            @Override
            public final /* synthetic */ Object a(ComponentRenderer componentRenderer, Object object, Object object2) {
                if (((ShowEntity)(object2 = (ShowEntity)object2)).c == null) {
                    return object2;
                }
                return ((ShowEntity)object2).name(componentRenderer.render(((ShowEntity)object2).c, object));
            }
        });
        @Deprecated
        public static final Action<String> SHOW_ACHIEVEMENT = new Action<String>("show_achievement", String.class, true, new a<String>(){});
        public static final Index<String, Action<?>> NAMES = Index.create(action -> action.a, SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY, SHOW_ACHIEVEMENT);
        private final String a;
        private final Class<V> b;
        private final boolean c;
        private final a<V> d;

        /*
         * WARNING - void declaration
         */
        private Action(String name, Class<V> type, boolean readable, a<V> renderer) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = true;
            this.d = renderer;
        }

        public final Class<V> type() {
            return this.b;
        }

        public final boolean readable() {
            return this.c;
        }

        public final String toString() {
            return this.a;
        }

        @FunctionalInterface
        static interface a<V> {
            public <C> V a(ComponentRenderer<C> var1, C var2, V var3);
        }
    }

    public static final class ShowEntity
    implements b {
        private final Key a;
        private final UUID b;
        private final Component c;

        /*
         * WARNING - void declaration
         */
        public static ShowEntity showEntity(Key type, UUID id) {
            void var1_1;
            return ShowEntity.showEntity(type, (UUID)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowEntity of(Key type, UUID id) {
            void var1_1;
            return ShowEntity.of(type, (UUID)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowEntity showEntity(Keyed type, UUID id) {
            void var1_1;
            return ShowEntity.showEntity(type, (UUID)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowEntity of(Keyed type, UUID id) {
            void var1_1;
            return ShowEntity.of(type, (UUID)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowEntity showEntity(Key type, UUID id, Component name) {
            void var2_2;
            void var1_1;
            Key key;
            return new ShowEntity(Objects.requireNonNull(key, "type"), (UUID)Objects.requireNonNull(var1_1, "id"), (Component)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowEntity of(Key type, UUID id, Component name) {
            void var2_2;
            void var1_1;
            Key key;
            return new ShowEntity(Objects.requireNonNull(key, "type"), (UUID)Objects.requireNonNull(var1_1, "id"), (Component)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowEntity showEntity(Keyed type, UUID id, Component name) {
            void var2_2;
            void var1_1;
            Keyed keyed;
            return new ShowEntity(Objects.requireNonNull(keyed, "type").key(), (UUID)Objects.requireNonNull(var1_1, "id"), (Component)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowEntity of(Keyed type, UUID id, Component name) {
            void var2_2;
            void var1_1;
            Keyed keyed;
            return new ShowEntity(Objects.requireNonNull(keyed, "type").key(), (UUID)Objects.requireNonNull(var1_1, "id"), (Component)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private ShowEntity(Key type, UUID id, Component name) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final Key type() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowEntity type(Key type) {
            void var1_1;
            if (Objects.requireNonNull(type, "type").equals(this.a)) {
                return this;
            }
            return new ShowEntity((Key)var1_1, this.b, this.c);
        }

        /*
         * WARNING - void declaration
         */
        public final ShowEntity type(Keyed type) {
            void var1_1;
            return this.type(((Keyed)Objects.requireNonNull(var1_1, "type")).key());
        }

        public final UUID id() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowEntity id(UUID id) {
            void var1_1;
            if (Objects.requireNonNull(id).equals(this.b)) {
                return this;
            }
            return new ShowEntity(this.a, (UUID)var1_1, this.c);
        }

        public final Component name() {
            return this.c;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowEntity name(Component name) {
            void var1_1;
            if (Objects.equals(name, this.c)) {
                return this;
            }
            return new ShowEntity(this.a, this.b, (Component)var1_1);
        }

        public final boolean equals(Object other) {
            ShowEntity showEntity;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            showEntity = showEntity;
            return this.a.equals(showEntity.a) && this.b.equals(showEntity.b) && Objects.equals(this.c, showEntity.c);
        }

        public final int hashCode() {
            int n2 = this.a.hashCode();
            n2 = n2 * 31 + this.b.hashCode();
            n2 = n2 * 31 + Objects.hashCode(this.c);
            return n2;
        }

        @Override
        public final Stream<? extends c> examinableProperties() {
            return Stream.of(net.kyori.a.c.a("type", this.a), net.kyori.a.c.a("id", this.b), net.kyori.a.c.a("name", this.c));
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }

    public static final class ShowItem
    implements b {
        private final Key a;
        private final int b;
        private final BinaryTagHolder c;

        /*
         * WARNING - void declaration
         */
        public static ShowItem showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            void var1_1;
            return ShowItem.showItem(item, (int)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowItem of(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            void var1_1;
            return ShowItem.of(item, (int)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowItem showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            void var1_1;
            return ShowItem.showItem(item, (int)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowItem of(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count) {
            void var1_1;
            return ShowItem.of(item, (int)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowItem showItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
            void var2_2;
            void var1_1;
            Key key;
            return new ShowItem(Objects.requireNonNull(key, "item"), (int)var1_1, (BinaryTagHolder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowItem of(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
            void var2_2;
            void var1_1;
            Key key;
            return new ShowItem(Objects.requireNonNull(key, "item"), (int)var1_1, (BinaryTagHolder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static ShowItem showItem(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
            void var2_2;
            void var1_1;
            Keyed keyed;
            return new ShowItem(Objects.requireNonNull(keyed, "item").key(), (int)var1_1, (BinaryTagHolder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static ShowItem of(Keyed item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
            void var2_2;
            void var1_1;
            Keyed keyed;
            return new ShowItem(Objects.requireNonNull(keyed, "item").key(), (int)var1_1, (BinaryTagHolder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private ShowItem(Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, BinaryTagHolder nbt) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final Key item() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowItem item(Key item) {
            void var1_1;
            if (Objects.requireNonNull(item, "item").equals(this.a)) {
                return this;
            }
            return new ShowItem((Key)var1_1, this.b, this.c);
        }

        public final @Range(from=0L, to=0x7FFFFFFFL) int count() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowItem count(@Range(from=0L, to=0x7FFFFFFFL) int count) {
            void var1_1;
            if (count == this.b) {
                return this;
            }
            return new ShowItem(this.a, (int)var1_1, this.c);
        }

        public final BinaryTagHolder nbt() {
            return this.c;
        }

        /*
         * WARNING - void declaration
         */
        public final ShowItem nbt(BinaryTagHolder nbt) {
            void var1_1;
            if (Objects.equals(nbt, this.c)) {
                return this;
            }
            return new ShowItem(this.a, this.b, (BinaryTagHolder)var1_1);
        }

        public final boolean equals(Object other) {
            ShowItem showItem;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            showItem = showItem;
            return this.a.equals(showItem.a) && this.b == showItem.b && Objects.equals(this.c, showItem.c);
        }

        public final int hashCode() {
            int n2 = this.a.hashCode();
            n2 = n2 * 31 + Integer.hashCode(this.b);
            n2 = n2 * 31 + Objects.hashCode(this.c);
            return n2;
        }

        @Override
        public final Stream<? extends c> examinableProperties() {
            return Stream.of(net.kyori.a.c.a("item", this.a), net.kyori.a.c.a("count", this.b), net.kyori.a.c.a("nbt", this.c));
        }

        public final String toString() {
            return Internals.toString(this);
        }
    }
}

