/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.legacy;

import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;
import net.kyori.adventure.text.serializer.legacy.c;
import net.kyori.adventure.util.Buildable;
import net.kyori.adventure.util.PlatformAPI;
import org.jetbrains.annotations.ApiStatus;

public interface LegacyComponentSerializer
extends ComponentSerializer<Component, TextComponent, String>,
Buildable<LegacyComponentSerializer, Builder> {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    public static final char HEX_CHAR = '#';

    public static LegacyComponentSerializer legacySection() {
        return c.e.a;
    }

    public static LegacyComponentSerializer legacyAmpersand() {
        return c.e.b;
    }

    public static LegacyComponentSerializer legacy(char legacyCharacter) {
        char c2;
        if (legacyCharacter == '\u00a7') {
            return LegacyComponentSerializer.legacySection();
        }
        if (legacyCharacter == '&') {
            return LegacyComponentSerializer.legacyAmpersand();
        }
        return LegacyComponentSerializer.builder().character(c2).build();
    }

    public static LegacyFormat parseChar(char character) {
        return c.a(character);
    }

    public static Builder builder() {
        return new c.a();
    }

    @Override
    public TextComponent deserialize(String var1);

    @Override
    public String serialize(Component var1);

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @PlatformAPI
        @ApiStatus.Internal
        public LegacyComponentSerializer legacyAmpersand();

        @PlatformAPI
        @ApiStatus.Internal
        public LegacyComponentSerializer legacySection();

        @PlatformAPI
        @ApiStatus.Internal
        public Consumer<Builder> legacy();
    }

    public static interface Builder
    extends AbstractBuilder<LegacyComponentSerializer>,
    Buildable.Builder<LegacyComponentSerializer> {
        public Builder character(char var1);

        public Builder hexCharacter(char var1);

        public Builder extractUrls();

        public Builder extractUrls(Pattern var1);

        public Builder extractUrls(Style var1);

        public Builder extractUrls(Pattern var1, Style var2);

        public Builder hexColors();

        public Builder useUnusualXRepeatedCharacterHexFormat();

        public Builder flattener(ComponentFlattener var1);

        public Builder formats(List<CharacterAndFormat> var1);

        @Override
        public LegacyComponentSerializer build();
    }
}

