/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class AFConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static ForgeConfigSpec.BooleanValue USE_COMPRESSION;
    public static ForgeConfigSpec.IntValue MAX_FILE_SIZE_MB;
    public static ForgeConfigSpec.IntValue PRELOAD_MAX_SIZE_KB;
    public static ForgeConfigSpec.BooleanValue PRELOAD_NEW_PLAYERS;
    public static ForgeConfigSpec.IntValue RETRY_LIMIT;
    public static ForgeConfigSpec.LongValue CHUNK_DELAY_MS;
    public static ForgeConfigSpec.LongValue PRELOAD_CHUNK_DELAY_MS;
    public static ForgeConfigSpec.LongValue PRELOAD_PLAYER_DELAY_MS;
    public static ForgeConfigSpec.IntValue MAX_FRAMES;
    public static ForgeConfigSpec.DoubleValue SCALE_FACTOR;

    private static void setupClientConfig(ForgeConfigSpec.Builder builder) {
    }

    private static void setupServerConfig(ForgeConfigSpec.Builder builder) {
        USE_COMPRESSION = builder.comment("Whether to compress media data before sending it to clients.").define("useCompression", true);
        MAX_FILE_SIZE_MB = builder.comment("Maximum size of a media file in MB.").defineInRange("maxFileSizeMB", 10, 1, 100);
        PRELOAD_MAX_SIZE_KB = builder.comment("Maximum size of a media file to preload in KB.").defineInRange("preloadMaxSizeKB", 512, 100, 10000);
        PRELOAD_NEW_PLAYERS = builder.comment("Whether to preload media files for new players joining the server.").define("preloadNewPlayers", false);
        RETRY_LIMIT = builder.comment("Maximum number of retries for sending missing chunks.").defineInRange("retryLimit", 3, 1, 10);
        CHUNK_DELAY_MS = builder.comment("Delay between sending chunks for user-initiated media (in milliseconds).").defineInRange("chunkDelayMs", 20L, 10L, 1000L);
        PRELOAD_CHUNK_DELAY_MS = builder.comment("Delay between sending chunks during preloading (in milliseconds).").defineInRange("preloadChunkDelayMs", 100L, 10L, 1000L);
        PRELOAD_PLAYER_DELAY_MS = builder.comment("Delay between preloading media for different players (in milliseconds).").defineInRange("preloadPlayerDelayMs", 500L, 100L, 5000L);
        MAX_FRAMES = builder.comment("Maximum number of frames allowed for GIF media.").defineInRange("maxFrames", 100, 1, 1000);
        SCALE_FACTOR = builder.comment("Scaling factor for media rendering (0.1 to 2.0).").defineInRange("scaleFactor", 1.0, 0.1, 2.0);
    }

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC, "animated_frames-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC, "animated_frames-server.toml");
    }

    static {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        AFConfig.setupClientConfig(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        AFConfig.setupServerConfig(serverBuilder);
        SERVER_SPEC = serverBuilder.build();
    }
}

