/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.MediaHandler;
import org.google.animated_frames.NetworkHandler;
import org.google.animated_frames.Utils;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="animated_frames", value={Dist.CLIENT})
public class GifRenderer {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static MediaHandler mediaHandler;
    private static int currentFrame;
    private static long lastFrameTime;
    private static float duration;
    private static String position;
    public static float scale;
    private static volatile boolean isActive;
    private static long serverSyncTime;
    private static final float FADE_DURATION = 0.7f;
    private static long startTime;
    private static long totalDurationMs;
    private static final File TEMP_DIR;
    private static final Map<String, File> tempMediaFiles;

    private static void calculateTotalDuration() {
        if (mediaHandler == null || !mediaHandler.isLoaded()) {
            totalDurationMs = 0L;
            LOGGER.warn("Cannot calculate total duration: mediaHandler is null or not loaded");
            return;
        }
        List<Integer> frameDelays = mediaHandler.getFrameDelays();
        if (frameDelays == null || frameDelays.isEmpty()) {
            totalDurationMs = 0L;
            LOGGER.warn("No frame delays available for media {}", (Object)mediaHandler.getMediaName());
            return;
        }
        totalDurationMs = frameDelays.stream().mapToLong(Integer::longValue).sum();
        LOGGER.debug("Calculated total duration for media {}: {}ms", (Object)mediaHandler.getMediaName(), (Object)totalDurationMs);
    }

    public static boolean isActive() {
        return isActive;
    }

    public static List<ResourceLocation> getFrameTextures() {
        return mediaHandler != null ? mediaHandler.getFrameTextures() : null;
    }

    public static String getCurrentMediaName() {
        return mediaHandler != null ? mediaHandler.getMediaName() : null;
    }

    public static void prepare(String mediaName, int totalChunks, float duration, String position, float scale) {
        LOGGER.info("Preparing media: {}, chunks: {}, duration: {}s, position: {}, scale: {}", (Object)mediaName, (Object)totalChunks, (Object)Float.valueOf(duration), (Object)position, (Object)Float.valueOf(scale));
        GifRenderer.duration = duration;
        GifRenderer.position = position;
        GifRenderer.scale = scale;
        GifRenderer.showProgress(mediaName, 0, totalChunks);
    }

    public static void addChunk(String mediaName, int chunkIndex, byte[] chunkData, int totalChunks) throws IOException {
        List chunks = NetworkHandler.chunkBuffer.computeIfAbsent(mediaName, k -> {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < totalChunks; ++i) {
                list.add(null);
            }
            return list;
        });
        if (chunkIndex >= chunks.size()) {
            LOGGER.error("Invalid chunk index {} for media {}, max expected {}", (Object)chunkIndex, (Object)mediaName, (Object)(chunks.size() - 1));
            return;
        }
        chunks.set(chunkIndex, chunkData);
        LOGGER.info("Chunk received {}/{} for media {}, total received: {}", (Object)chunkIndex, (Object)totalChunks, (Object)mediaName, (Object)chunks.stream().filter(c -> c != null).count());
        NetworkHandler.INSTANCE.sendToServer((Object)new NetworkHandler.ChunkConfirmPacket(mediaName, chunkIndex));
        int receivedCount = (int)chunks.stream().filter(c -> c != null).count();
        GifRenderer.showProgress(mediaName, receivedCount, totalChunks);
        if (chunks.stream().allMatch(data -> data != null) && chunks.size() == totalChunks) {
            LOGGER.info("All chunks received for media {}, assembling data async", (Object)mediaName);
            EXECUTOR.submit(() -> {
                try {
                    byte[] compressedData = new byte[chunks.stream().mapToInt(d -> ((byte[])d).length).sum()];
                    int offset = 0;
                    for (byte[] chunk : chunks) {
                        System.arraycopy(chunk, 0, compressedData, offset, chunk.length);
                        offset += chunk.length;
                    }
                    byte[] mediaData = NetworkHandler.decompressData(compressedData);
                    LOGGER.info("Media data decompressed for {}, size: {}", (Object)mediaName, (Object)mediaData.length);
                    File tempFile = File.createTempFile(mediaName + "_", ".tmp", TEMP_DIR);
                    Files.write(tempFile.toPath(), mediaData, new OpenOption[0]);
                    tempMediaFiles.put(mediaName, tempFile);
                    LOGGER.info("Media {} saved to temporary file: {}", (Object)mediaName, (Object)tempFile.getAbsolutePath());
                    Minecraft.m_91087_().execute(() -> GifRenderer.start(mediaName, mediaData, duration, position, scale));
                    GifRenderer.clearProgress();
                }
                catch (IOException e) {
                    LOGGER.error("Error decompressing media for {}: {}", (Object)mediaName, (Object)e.getMessage(), (Object)e);
                    GifRenderer.clearProgress();
                }
                finally {
                    NetworkHandler.chunkBuffer.remove(mediaName);
                    NetworkHandler.expectedChunks.remove(mediaName);
                    NetworkHandler.receivedChunks.remove(mediaName);
                }
            });
        }
    }

    public static void start(String mediaName, byte[] mediaData, float duration, String position, float scale) {
        GifRenderer.stop();
        mediaHandler = new MediaHandler("animated_frames", mediaName, mediaData);
        GifRenderer.duration = duration;
        GifRenderer.position = position;
        GifRenderer.scale = scale;
        startTime = System.currentTimeMillis();
        isActive = true;
        GifRenderer.calculateTotalDuration();
        LOGGER.info("Started media {} with duration {}s in position {} with scale {}", (Object)mediaName, (Object)Float.valueOf(duration), (Object)position, (Object)Float.valueOf(scale));
    }

    public static void sync(String mediaName, int frame, long serverTime) {
        if (mediaHandler != null && mediaName.equals(mediaHandler.getMediaName())) {
            currentFrame = frame;
            serverSyncTime = serverTime;
            startTime = System.currentTimeMillis() - (serverTime - startTime);
            LOGGER.info("Media {} synced to frame {} with server time {}", (Object)mediaName, (Object)frame, (Object)serverTime);
        } else {
            LOGGER.error("Sync error: Media {} does not match current handler {}", (Object)mediaName, (Object)(mediaHandler != null ? mediaHandler.getMediaName() : "null"));
        }
    }

    public static void stop() {
        if (mediaHandler != null) {
            mediaHandler.close();
            mediaHandler = null;
        }
        isActive = false;
        currentFrame = 0;
        lastFrameTime = 0L;
        serverSyncTime = -1L;
        totalDurationMs = 0L;
        GifRenderer.clearProgress();
        LOGGER.info("Media stopped");
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        int x;
        if (!isActive || mediaHandler == null || !mediaHandler.isLoaded()) {
            return;
        }
        if (mediaHandler.hasFailed()) {
            LOGGER.error("Media handler failed; stopping media");
            GifRenderer.stop();
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedMs = currentTime - startTime;
        float elapsedSeconds = (float)elapsedMs / 1000.0f;
        if (duration > 0.0f && elapsedSeconds > duration) {
            GifRenderer.stop();
            return;
        }
        GifRenderer.calculateTotalDuration();
        List<Integer> frameDelays = mediaHandler.getFrameDelays();
        int numFrames = frameDelays.size();
        if (numFrames == 0) {
            LOGGER.error("No valid frames to render; stopping media");
            Utils.sendErrorMessage(null, "No valid frames to render; media stopped", true);
            GifRenderer.stop();
            return;
        }
        if (numFrames == 1) {
            currentFrame = 0;
        } else {
            long frameTime = 0L;
            int newFrame = 0;
            long loopTime = elapsedMs % totalDurationMs;
            for (int i = 0; i < numFrames; ++i) {
                if (loopTime >= (frameTime += (long)frameDelays.get(i).intValue())) continue;
                newFrame = i;
                break;
            }
            if (newFrame != currentFrame) {
                currentFrame = newFrame;
                lastFrameTime = currentTime;
            }
        }
        List<ResourceLocation> frameTextures = mediaHandler.getFrameTextures();
        if (frameTextures.isEmpty() || currentFrame >= frameTextures.size()) {
            LOGGER.error("Invalid frame index {} or empty textures; stopping media", (Object)currentFrame);
            Utils.sendErrorMessage(null, "Invalid frame index or empty textures; media stopped", true);
            GifRenderer.stop();
            return;
        }
        ResourceLocation currentTexture = frameTextures.get(currentFrame);
        if (currentTexture == null) {
            LOGGER.error("Null texture for frame {} of {}", (Object)currentFrame, (Object)mediaHandler.getMediaName());
            Utils.sendErrorMessage(null, "Invalid texture for frame " + currentFrame, true);
            GifRenderer.stop();
            return;
        }
        LOGGER.debug("Rendering media {}: frame {}/{}, elapsed: {}ms, total duration: {}ms", (Object)mediaHandler.getMediaName(), (Object)currentFrame, (Object)frameTextures.size(), (Object)elapsedMs, (Object)totalDurationMs);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)currentTexture);
        float alpha = 1.0f;
        if (elapsedSeconds < 0.7f) {
            alpha = Math.min(elapsedSeconds / 0.7f, 1.0f);
        } else if (duration > 0.0f && elapsedSeconds > duration - 0.7f) {
            alpha = Math.max((duration - elapsedSeconds) / 0.7f, 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int mediaWidth = (int)((float)mediaHandler.getMediaWidth() * scale);
        int mediaHeight = (int)((float)mediaHandler.getMediaHeight() * scale);
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int y = switch (position.toLowerCase()) {
            case "topleft" -> {
                x = 0;
                yield 0;
            }
            case "topright" -> {
                x = screenWidth - mediaWidth;
                yield 0;
            }
            case "bottomleft" -> {
                x = 0;
                yield screenHeight - mediaHeight;
            }
            case "bottomright" -> {
                x = screenWidth - mediaWidth;
                yield screenHeight - mediaHeight;
            }
            default -> {
                x = (screenWidth - mediaWidth) / 2;
                yield (screenHeight - mediaHeight) / 2;
            }
        };
        GuiGraphics guiGraphics = event.getGuiGraphics();
        guiGraphics.m_280411_(currentTexture, x, y, mediaWidth, mediaHeight, 0.0f, 0.0f, mediaHandler.getMediaWidth(), mediaHandler.getMediaHeight(), mediaHandler.getMediaWidth(), mediaHandler.getMediaHeight());
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void showProgress(String mediaName, int received, int total) {
        if (received == total) {
            GifRenderer.clearProgress();
            return;
        }
        MutableComponent message = Component.m_237113_((String)("Preloading " + mediaName + ": " + received + "/" + total + " chunks received")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55)));
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)message);
        } else {
            LOGGER.warn("Cannot show preloading message for {}: local player is null", (Object)mediaName);
        }
    }

    public static void clearProgress() {
        LOGGER.debug("Cleared progress message");
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        for (File tempFile : tempMediaFiles.values()) {
            try {
                if (tempFile.delete()) {
                    LOGGER.info("Temporary file deleted: {}", (Object)tempFile.getAbsolutePath());
                    continue;
                }
                LOGGER.warn("Could not delete temporary file: {}", (Object)tempFile.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error("Error deleting temporary file {}: {}", (Object)tempFile.getAbsolutePath(), (Object)e.getMessage(), (Object)e);
            }
        }
        tempMediaFiles.clear();
    }

    static {
        currentFrame = 0;
        lastFrameTime = 0L;
        duration = -1.0f;
        position = "center";
        scale = 1.0f;
        isActive = false;
        serverSyncTime = -1L;
        totalDurationMs = 0L;
        TEMP_DIR = new File("config/AnimatedFrames/temp");
        tempMediaFiles = new ConcurrentHashMap<String, File>();
        if (!TEMP_DIR.exists()) {
            TEMP_DIR.mkdirs();
        }
        MinecraftForge.EVENT_BUS.addListener(GifRenderer::onClientLogout);
    }
}

