/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.NetworkHandler;
import org.google.animated_frames.ServerCommands;
import org.google.animated_frames.Utils;

@Mod(value="animated_frames")
public class Animatedframes {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    public static final String MOD_ID = "animated_frames";
    public static final Map<String, byte[]> mediaCache = new HashMap<String, byte[]>();
    private static final AtomicBoolean firstPlayerJoined = new AtomicBoolean(false);

    public Animatedframes() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.register();
        AFConfig.register();
        MinecraftForge.EVENT_BUS.addListener(this::onConfigLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogout);
        Animatedframes.createDirectories();
    }

    private static void createDirectories() {
        File clientMediaDir;
        File serverMediaDir;
        File configDir = new File("config/AnimatedFrames");
        if (!configDir.exists()) {
            configDir.mkdirs();
            LOGGER.info("Created base config directory: {}", (Object)configDir.getAbsolutePath());
        }
        if (!(serverMediaDir = new File("config/AnimatedFrames/server_media")).exists()) {
            serverMediaDir.mkdirs();
            LOGGER.info("Created server media directory: {}", (Object)serverMediaDir.getAbsolutePath());
        }
        if (!(clientMediaDir = new File("config/AnimatedFrames/client_media")).exists()) {
            clientMediaDir.mkdirs();
            LOGGER.info("Created client media directory: {}", (Object)clientMediaDir.getAbsolutePath());
        }
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == AFConfig.SERVER_SPEC) {
            LOGGER.info("Configuration loaded, initializing server media cache async");
            new Thread(() -> Animatedframes.cacheMedia(new File("config/AnimatedFrames/server_media"))).start();
        }
    }

    public static void cacheMedia(File serverMediaDir) {
        File[] mediaFiles;
        mediaCache.clear();
        if (!serverMediaDir.exists()) {
            serverMediaDir.mkdirs();
            LOGGER.info("Created server media directory: {}", (Object)serverMediaDir.getAbsolutePath());
        }
        if ((mediaFiles = serverMediaDir.listFiles((dir, name) -> name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".mp4"))) == null || mediaFiles.length == 0) {
            LOGGER.info("No media files found in {}", (Object)serverMediaDir.getAbsolutePath());
            return;
        }
        for (File mediaFile : mediaFiles) {
            try {
                byte[] mediaData = Files.readAllBytes(mediaFile.toPath());
                int maxSize = (Integer)AFConfig.MAX_FILE_SIZE_MB.get() * 1024 * 1024;
                if (!Utils.checkMemoryForGif((long)mediaData.length * 10L)) {
                    LOGGER.error("Insufficient memory to cache media {}", (Object)mediaFile.getName());
                    continue;
                }
                if (mediaData.length > maxSize) {
                    LOGGER.error("Media {} too large for cache: {}MB", (Object)mediaFile.getName(), (Object)((double)mediaData.length / 1048576.0));
                    continue;
                }
                String extension = mediaFile.getName().substring(mediaFile.getName().lastIndexOf(46) + 1).toLowerCase();
                if (extension.equals("png")) {
                    if (mediaData.length < 8 || !new String(mediaData, 1, 3).equals("PNG")) {
                        LOGGER.error("File is not a valid PNG: {}", (Object)mediaFile.getName());
                        continue;
                    }
                } else if (extension.equals("gif")) {
                    if (mediaData.length < 6 || !new String(mediaData, 0, 6).startsWith("GIF89a") && !new String(mediaData, 0, 6).startsWith("GIF87a")) {
                        LOGGER.error("File is not a valid GIF: {}", (Object)mediaFile.getName());
                        continue;
                    }
                } else if (extension.equals("mp4")) {
                    // empty if block
                }
                mediaCache.put(mediaFile.getName(), mediaData);
                LOGGER.info("Cached media: {}, size: {} bytes", (Object)mediaFile.getName(), (Object)mediaData.length);
            }
            catch (IOException e) {
                LOGGER.error("Error caching media {}: {}", (Object)mediaFile.getName(), (Object)e.getMessage(), (Object)e);
            }
        }
        LOGGER.info("Cached {} media files successfully", (Object)mediaCache.size());
    }

    public static byte[] getCachedMedia(String mediaName) {
        if (mediaName == null) {
            return null;
        }
        return mediaCache.get(mediaName.endsWith(".gif") || mediaName.endsWith(".png") || mediaName.endsWith(".mp4") ? mediaName : mediaName + ".gif");
    }

    public static void reloadConfigsAndMedia() {
        LOGGER.info("Reloading AnimatedFrames media cache async");
        new Thread(() -> Animatedframes.cacheMedia(new File("config/AnimatedFrames/server_media"))).start();
        LOGGER.info("Media cache reloaded. Note: Config changes require a server restart or manual file edit.");
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (firstPlayerJoined.compareAndSet(false, true)) {
                MutableComponent message = Component.m_237113_((String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u2551 Welcome to AnimatedFrames (Full Version)\n\u2551 Thank you for using the full version.\n\u2551 Warning: Media files of 1MB or more may cause errors.\n\u2551 support & Credits  ").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))).m_7220_((Component)Component.m_237113_((String)"x.com/SunnyAim_").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA00FF)).m_131162_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)"\n\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
                player2.m_213846_((Component)message);
            }
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new NetworkHandler.RequestClientMediaListPacket());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerCommands.removeClientMediaList(player2.m_20148_());
            LOGGER.info("Removed media list for player {}", (Object)player2.m_7755_().getString());
        }
    }
}

