/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.GifRenderer;
import org.google.animated_frames.NetworkHandler;
import org.google.animated_frames.Utils;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="animated_frames", value={Dist.CLIENT})
public class ClientCommands {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final SuggestionProvider<CommandSourceStack> MEDIA_SUGGESTIONS = (context, builder) -> {
        File configDir = new File("config/AnimatedFrames/client_media");
        if (configDir.exists()) {
            List mediaFiles = Arrays.stream(configDir.listFiles((dir, name) -> name.endsWith(".gif") || name.endsWith(".png"))).map(File::getName).collect(Collectors.toList());
            return SharedSuggestionProvider.m_82970_(mediaFiles, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
    };

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gif").then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"mediaName", (ArgumentType)StringArgumentType.string()).suggests(MEDIA_SUGGESTIONS).then(Commands.m_82129_((String)"duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"position", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("center", "topleft", "topright", "bottomleft", "bottomright"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(context -> {
            String mediaName = StringArgumentType.getString((CommandContext)context, (String)"mediaName");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String position = StringArgumentType.getString((CommandContext)context, (String)"position");
            float size = FloatArgumentType.getFloat((CommandContext)context, (String)"size");
            File configDir = new File("config/AnimatedFrames/client_media");
            File mediaFile = new File(configDir, (String)(mediaName.endsWith(".gif") || mediaName.endsWith(".png") ? mediaName : mediaName + ".gif"));
            if (!mediaFile.exists()) {
                Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "The media " + mediaName + " does not exist in config/AnimatedFrames/client_media.", true);
                return 0;
            }
            try {
                byte[] mediaData = Files.readAllBytes(mediaFile.toPath());
                int maxSize = (Integer)AFConfig.MAX_FILE_SIZE_MB.get() * 1024 * 1024;
                if (!Utils.checkMemoryForGif(mediaData.length)) {
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "Insufficient memory to load media " + mediaName, true);
                    return 0;
                }
                if (mediaData.length > maxSize) {
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "The media file " + mediaName + " exceeds the maximum size of " + String.valueOf(AFConfig.MAX_FILE_SIZE_MB.get()) + "MB", true);
                    return 0;
                }
                String extension = mediaName.substring(mediaName.lastIndexOf(46) + 1).toLowerCase();
                if (extension.equals("png")) {
                    if (mediaData.length < 8 || !new String(mediaData, 1, 3).equals("PNG")) {
                        Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "The file " + mediaName + " is not a valid PNG", true);
                        return 0;
                    }
                } else if (extension.equals("gif") && (mediaData.length < 6 || !new String(mediaData, 0, 6).startsWith("GIF89a") && !new String(mediaData, 0, 6).startsWith("GIF87a"))) {
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "The file " + mediaName + " is not a valid GIF", true);
                    return 0;
                }
                GifRenderer.start(mediaName, mediaData, duration, position, size);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Displaying media: " + mediaName)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
                return 1;
            }
            catch (Exception e) {
                LOGGER.error("Error reading media {}: {}", (Object)mediaName, (Object)e.getMessage(), (Object)e);
                Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "Error reading media: " + e.getMessage(), true);
                return 0;
            }
        }))))))).then(Commands.m_82127_((String)"stop").executes(context -> {
            GifRenderer.stop();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Media stopped").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
            return 1;
        }))).then(Commands.m_82127_((String)"list").executes(context -> {
            File configDir = new File("config/AnimatedFrames/client_media");
            if (configDir.exists()) {
                String[] mediaFiles = configDir.list((dir, name) -> name.endsWith(".gif") || name.endsWith(".png"));
                if (mediaFiles != null && mediaFiles.length > 0) {
                    List<String> mediaList = Arrays.asList(mediaFiles);
                    NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NetworkHandler.ClientMediaListPacket(mediaList));
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Available media: " + String.join((CharSequence)", ", mediaFiles))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
                } else {
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "No media files found in config/AnimatedFrames/client_media.", true);
                }
            } else {
                Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "Folder config/AnimatedFrames/client_media not found.", true);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"help").executes(context -> {
            MutableComponent message = Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            message.m_7220_((Component)Component.m_237113_((String)"AnimatedFrames Commands (Client):\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))));
            message.m_7220_((Component)Component.m_237113_((String)"/gif show <media> <duration> <position> <size> - Displays a GIF or PNG locally.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            message.m_7220_((Component)Component.m_237113_((String)"  Example: /gif show example.gif 10 center 1.0\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
            message.m_7220_((Component)Component.m_237113_((String)"  Place media in config/AnimatedFrames/client_media folder (.gif or .png).\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
            message.m_7220_((Component)Component.m_237113_((String)"/gif stop - Stops the current media.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            message.m_7220_((Component)Component.m_237113_((String)"/gif list - Lists available local media.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            message.m_7220_((Component)Component.m_237113_((String)"/gif help - Shows this help.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            message.m_7220_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> message, false);
            return 1;
        })));
    }
}

