/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@OnlyIn(value=Dist.CLIENT)
public class MediaHandler
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final int MIN_FRAMES_TO_START = 2;
    private static final int INITIAL_BATCH_SIZE = 2;
    private static final int FRAMES_PER_BATCH = 5;
    private static final long BATCH_SLEEP_MS = 15L;
    private final List<ResourceLocation> frameTextures = new ArrayList<ResourceLocation>();
    private final List<Integer> delays = new ArrayList<Integer>();
    private final List<Integer> disposals = new ArrayList<Integer>();
    private final List<Integer> lefts = new ArrayList<Integer>();
    private final List<Integer> tops = new ArrayList<Integer>();
    private final List<Integer> frameWidths = new ArrayList<Integer>();
    private final List<Integer> frameHeights = new ArrayList<Integer>();
    private final AtomicInteger mediaWidth = new AtomicInteger(0);
    private final AtomicInteger mediaHeight = new AtomicInteger(0);
    private final AtomicBoolean isLoaded = new AtomicBoolean(false);
    private final AtomicBoolean isLoading = new AtomicBoolean(false);
    private final AtomicInteger totalExpectedFrames = new AtomicInteger(0);
    private final TextureManager textureManager;
    private final String modId;
    private final String mediaName;
    private volatile boolean loadingFailed = false;
    private final AtomicLong estimatedMemory = new AtomicLong(0L);
    private final boolean priorityLoad;

    public MediaHandler(String modId, String mediaName) {
        this(modId, mediaName, true);
    }

    public MediaHandler(String modId, String mediaName, boolean priorityLoad) {
        this.modId = modId;
        this.mediaName = mediaName;
        this.priorityLoad = priorityLoad;
        this.textureManager = Minecraft.m_91087_().m_91097_();
        File configDir = new File("config/AnimatedFrames/client_media");
        File mediaFile = new File(configDir, (String)(mediaName.endsWith(".gif") || mediaName.endsWith(".png") ? mediaName : mediaName + ".gif"));
        try {
            byte[] mediaData = Files.readAllBytes(mediaFile.toPath());
            this.processMedia(mediaData);
        }
        catch (IOException e) {
            LOGGER.error("IOException loading media {}: {}", (Object)mediaName, (Object)e.getMessage(), (Object)e);
            Utils.sendErrorMessage(null, "Error loading media: " + e.getMessage(), true);
            this.loadingFailed = true;
        }
    }

    public MediaHandler(String modId, String mediaName, byte[] mediaData) {
        this(modId, mediaName, mediaData, false);
    }

    public MediaHandler(String modId, String mediaName, byte[] mediaData, boolean priorityLoad) {
        this.modId = modId;
        this.mediaName = mediaName;
        this.priorityLoad = priorityLoad;
        this.textureManager = Minecraft.m_91087_().m_91097_();
        this.processMedia(mediaData);
    }

    private void processMedia(byte[] mediaData) {
        int maxSize = (Integer)AFConfig.MAX_FILE_SIZE_MB.get() * 1024 * 1024;
        if (!Utils.checkMemoryForGif((long)mediaData.length * 3L)) {
            LOGGER.error("Insufficient memory to load media {} (estimated size: {} bytes)", (Object)this.mediaName, (Object)((long)mediaData.length * 3L));
            Utils.sendErrorMessage(null, "Insufficient memory to load media " + this.mediaName, true);
            this.loadingFailed = true;
            return;
        }
        if (mediaData.length > maxSize) {
            LOGGER.error("Media {} exceeds max size of {}MB", (Object)this.mediaName, AFConfig.MAX_FILE_SIZE_MB.get());
            Utils.sendErrorMessage(null, "The media file " + this.mediaName + " exceeds the maximum size of " + String.valueOf(AFConfig.MAX_FILE_SIZE_MB.get()) + "MB", true);
            this.loadingFailed = true;
            return;
        }
        this.validateMediaHeader(mediaData, this.mediaName);
        if (this.loadingFailed) {
            return;
        }
        LOGGER.info("Starting to load media {}, size: {} bytes, priorityLoad: {}", (Object)this.mediaName, (Object)mediaData.length, (Object)this.priorityLoad);
        this.loadMediaAsync(mediaData);
        if (mediaData.length > 0x500000) {
            System.gc();
        }
    }

    private void validateMediaHeader(byte[] data, String mediaName) {
        String extension = mediaName.substring(mediaName.lastIndexOf(46) + 1).toLowerCase();
        if (extension.equals("png")) {
            if (data.length < 8 || !new String(data, 1, 3).equals("PNG")) {
                LOGGER.error("Invalid PNG header for {}", (Object)mediaName);
                Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid PNG", true);
                this.loadingFailed = true;
            }
        } else if (extension.equals("gif")) {
            if (data.length < 6 || !new String(data, 0, 6).startsWith("GIF89a") && !new String(data, 0, 6).startsWith("GIF87a")) {
                LOGGER.error("Invalid GIF header for {}", (Object)mediaName);
                Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid GIF", true);
                this.loadingFailed = true;
            }
        } else {
            LOGGER.error("Unsupported media format for {}", (Object)mediaName);
            Utils.sendErrorMessage(null, "Unsupported media format: " + extension, true);
            this.loadingFailed = true;
        }
    }

    private void loadMediaAsync(byte[] mediaData) {
        this.isLoading.set(true);
        EXECUTOR.submit(() -> {
            try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(mediaData));){
                ImageReader reader = ImageIO.getImageReaders(stream).next();
                reader.setInput(stream);
                String extension = this.mediaName.substring(this.mediaName.lastIndexOf(46) + 1).toLowerCase();
                int numFrames = extension.equals("png") ? 1 : Math.min(reader.getNumImages(true), (Integer)AFConfig.MAX_FRAMES.get());
                this.totalExpectedFrames.set(numFrames);
                LOGGER.info("Expected {} frames for media {}", (Object)numFrames, (Object)this.mediaName);
                this.mediaWidth.set(this.getScreenWidth(reader));
                this.mediaHeight.set(this.getScreenHeight(reader));
                if (extension.equals("png")) {
                    this.processPNGFrame(reader);
                } else {
                    this.extractAllMetadata(reader, numFrames);
                    this.processGIFFrames(reader, numFrames);
                }
                List<ResourceLocation> list = this.frameTextures;
                synchronized (list) {
                    block15: {
                        if (!this.frameTextures.isEmpty()) break block15;
                        this.loadingFailed = true;
                        this.isLoading.set(false);
                        LOGGER.error("No frames loaded for media {}", (Object)this.mediaName);
                        return;
                    }
                    this.isLoaded.set(true);
                    this.isLoading.set(false);
                    LOGGER.info("Successfully loaded {} frames for media {}", (Object)this.frameTextures.size(), (Object)this.mediaName);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error loading media {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
                Utils.sendErrorMessage(null, "Error loading media: " + e.getMessage(), true);
                this.loadingFailed = true;
                this.isLoading.set(false);
            }
        });
    }

    private int getScreenWidth(ImageReader reader) throws IOException {
        IIOMetadata meta = reader.getStreamMetadata();
        if (meta != null) {
            Node root = meta.getAsTree("javax_imageio_gif_stream_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"LogicalScreenDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("logicalScreenWidth"));
            }
        }
        int maxW = 0;
        for (int i = 0; i < this.totalExpectedFrames.get(); ++i) {
            maxW = Math.max(maxW, reader.getWidth(i));
        }
        return maxW;
    }

    private int getScreenHeight(ImageReader reader) throws IOException {
        IIOMetadata meta = reader.getStreamMetadata();
        if (meta != null) {
            Node root = meta.getAsTree("javax_imageio_gif_stream_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"LogicalScreenDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("logicalScreenHeight"));
            }
        }
        int maxH = 0;
        for (int i = 0; i < this.totalExpectedFrames.get(); ++i) {
            maxH = Math.max(maxH, reader.getHeight(i));
        }
        return maxH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPNGFrame(ImageReader reader) throws IOException {
        BufferedImage image = reader.read(0);
        this.mediaWidth.set(image.getWidth());
        this.mediaHeight.set(image.getHeight());
        this.estimatedMemory.addAndGet((long)(image.getWidth() * image.getHeight()) * 4L);
        BufferedImage scaled = this.scaleImage(image);
        if (scaled == null) {
            this.loadingFailed = true;
            return;
        }
        ResourceLocation texture = this.registerTexture(scaled, 0);
        if (texture != null) {
            List<ResourceLocation> list = this.frameTextures;
            synchronized (list) {
                this.frameTextures.add(texture);
                this.delays.add(100);
                this.disposals.add(0);
            }
        } else {
            this.loadingFailed = true;
        }
    }

    private void extractAllMetadata(ImageReader reader, int numFrames) throws IOException {
        for (int i = 0; i < numFrames; ++i) {
            IIOMetadata metadata = reader.getImageMetadata(i);
            this.delays.add(this.getFrameDelay(metadata, i));
            this.disposals.add(this.getDisposalMethod(metadata));
            this.lefts.add(this.getImageLeft(metadata));
            this.tops.add(this.getImageTop(metadata));
            this.frameWidths.add(this.getImageFrameWidth(metadata));
            this.frameHeights.add(this.getImageFrameHeight(metadata));
        }
        LOGGER.info("Extracted metadata for {} frames in media {}", (Object)numFrames, (Object)this.mediaName);
    }

    private int getImageLeft(IIOMetadata metadata) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"ImageDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("imageLeftPosition"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting image left for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
        }
        return 0;
    }

    private int getImageTop(IIOMetadata metadata) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"ImageDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("imageTopPosition"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting image top for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
        }
        return 0;
    }

    private int getImageFrameWidth(IIOMetadata metadata) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"ImageDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("imageWidth"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting frame width for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
        }
        return this.mediaWidth.get();
    }

    private int getImageFrameHeight(IIOMetadata metadata) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!"ImageDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("imageHeight"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting frame height for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
        }
        return this.mediaHeight.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGIFFrames(ImageReader reader, int numFrames) throws IOException {
        BufferedImage canvas = new BufferedImage(this.mediaWidth.get(), this.mediaHeight.get(), 2);
        BufferedImage prevCanvas = null;
        for (int i = 0; i < numFrames; ++i) {
            if (i % (this.priorityLoad ? 2 : 5) == 0 && i > 0) {
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted during batch sleep for media {}", (Object)this.mediaName);
                }
                if (i >= 2 && !this.isLoaded.get()) {
                    List<ResourceLocation> e = this.frameTextures;
                    synchronized (e) {
                        this.isLoaded.set(true);
                        LOGGER.info("Initial frames loaded ({}), starting playback for media {}", (Object)this.frameTextures.size(), (Object)this.mediaName);
                    }
                }
            }
            BufferedImage rawFrame = reader.read(i);
            this.estimatedMemory.addAndGet((long)(rawFrame.getWidth() * rawFrame.getHeight()) * 4L);
            int x = this.lefts.get(i);
            int y = this.tops.get(i);
            int fw = this.frameWidths.get(i);
            int fh = this.frameHeights.get(i);
            int disposal = this.disposals.get(i);
            if (disposal == 3) {
                prevCanvas = this.copyImage(canvas);
            }
            Graphics2D g = canvas.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.drawImage((Image)rawFrame, x, y, null);
            g.dispose();
            BufferedImage fullFrame = this.copyImage(canvas);
            BufferedImage scaled = this.scaleImage(fullFrame);
            if (scaled == null) {
                this.loadingFailed = true;
                return;
            }
            ResourceLocation texture = this.registerTexture(scaled, i);
            if (texture != null) {
                List<ResourceLocation> list = this.frameTextures;
                synchronized (list) {
                    this.frameTextures.add(texture);
                    LOGGER.debug("Registered frame {} for media {}", (Object)i, (Object)this.mediaName);
                }
            } else {
                this.loadingFailed = true;
                return;
            }
            if (disposal == 2) {
                g = canvas.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(x, y, fw, fh);
                g.dispose();
            } else if (disposal == 3) {
                canvas = prevCanvas;
            }
            rawFrame.flush();
            fullFrame.flush();
        }
    }

    private BufferedImage copyImage(BufferedImage src) {
        if (src == null) {
            return null;
        }
        BufferedImage copy = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return copy;
    }

    private BufferedImage scaleImage(BufferedImage original) {
        if (original == null) {
            return null;
        }
        int newWidth = (int)((double)original.getWidth() * (Double)AFConfig.SCALE_FACTOR.get());
        int newHeight = (int)((double)original.getHeight() * (Double)AFConfig.SCALE_FACTOR.get());
        try {
            BufferedImage scaled = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D g2d = scaled.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.drawImage(original, 0, 0, newWidth, newHeight, null);
            g2d.dispose();
            original.flush();
            return scaled;
        }
        catch (Exception e) {
            LOGGER.error("Error scaling media for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private int getFrameDelay(IIOMetadata metadata, int frameIndex) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String delayTime;
                Node node = children.item(i);
                if (!"GraphicControlExtension".equals(node.getNodeName()) || (delayTime = ((Element)node).getAttribute("delayTime")) == null || delayTime.isEmpty()) continue;
                int delay = Integer.parseInt(delayTime) * 10;
                return Math.max(delay, 10);
            }
            return 100;
        }
        catch (Exception e) {
            LOGGER.error("Error getting delay for frame {} of media {}: {}", (Object)frameIndex, (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
            return 100;
        }
    }

    private int getDisposalMethod(IIOMetadata metadata) {
        try {
            Node root = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String disposal;
                Node node = children.item(i);
                if (!"GraphicControlExtension".equals(node.getNodeName())) continue;
                switch (disposal = ((Element)node).getAttribute("disposalMethod")) {
                    case "none": {
                        return 1;
                    }
                    case "doNotDispose": {
                        return 1;
                    }
                    case "restoreToBackgroundColor": {
                        return 2;
                    }
                    case "restoreToPrevious": {
                        return 3;
                    }
                }
                return 0;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting disposal method for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
        }
        return 0;
    }

    private ResourceLocation registerTexture(BufferedImage image, int frameIndex) {
        if (image == null) {
            LOGGER.error("Cannot register null image for frame {} of {}", (Object)frameIndex, (Object)this.mediaName);
            return null;
        }
        try {
            NativeImage nativeImage = this.convertToNativeImageOptimized(image);
            if (nativeImage == null) {
                LOGGER.error("Failed to convert frame {} to NativeImage for {}", (Object)frameIndex, (Object)this.mediaName);
                return null;
            }
            if (!Utils.checkMemoryForGif((long)(nativeImage.m_84982_() * nativeImage.m_85084_()) * 4L)) {
                LOGGER.error("Insufficient memory to register texture for frame {} of {}", (Object)frameIndex, (Object)this.mediaName);
                nativeImage.close();
                return null;
            }
            DynamicTexture texture = new DynamicTexture(nativeImage);
            ResourceLocation resourceLocation = new ResourceLocation(this.modId, "media_" + this.mediaName + "_" + frameIndex);
            Minecraft.m_91087_().execute(() -> this.textureManager.m_118495_(resourceLocation, (AbstractTexture)texture));
            return resourceLocation;
        }
        catch (Exception e) {
            LOGGER.error("Error registering texture for frame {} of {}: {}", (Object)frameIndex, (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private NativeImage convertToNativeImageOptimized(BufferedImage image) {
        if (image == null) {
            LOGGER.error("Cannot convert null image for {}", (Object)this.mediaName);
            return null;
        }
        try {
            int width = image.getWidth();
            int height = image.getHeight();
            int[] argb = new int[width * height];
            image.getRGB(0, 0, width, height, argb, 0, width);
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, true);
            for (int i = 0; i < argb.length; ++i) {
                int a = argb[i] >> 24 & 0xFF;
                int r = argb[i] >> 16 & 0xFF;
                int g = argb[i] >> 8 & 0xFF;
                int b = argb[i] & 0xFF;
                nativeImage.m_84988_(i % width, i / width, a << 24 | b << 16 | g << 8 | r);
            }
            image.flush();
            return nativeImage;
        }
        catch (Exception e) {
            LOGGER.error("Error converting BufferedImage to NativeImage for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceLocation> getFrameTextures() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            return new ArrayList<ResourceLocation>(this.frameTextures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getFrameDelays() {
        List<Integer> list = this.delays;
        synchronized (list) {
            return new ArrayList<Integer>(this.delays);
        }
    }

    public int getMediaWidth() {
        return this.mediaWidth.get();
    }

    public int getMediaHeight() {
        return this.mediaHeight.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            return this.isLoaded.get() && !this.loadingFailed && !this.frameTextures.isEmpty();
        }
    }

    public boolean isLoading() {
        return this.isLoading.get();
    }

    public boolean hasFailed() {
        return this.loadingFailed;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            for (ResourceLocation texture : this.frameTextures) {
                this.textureManager.m_118513_(texture);
            }
            this.frameTextures.clear();
            this.delays.clear();
            this.disposals.clear();
            this.isLoaded.set(false);
            this.isLoading.set(false);
            LOGGER.info("Closed media handler for {}", (Object)this.mediaName);
            System.gc();
        }
    }
}

