/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.ClientCommands;
import org.google.animated_frames.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@OnlyIn(value=Dist.CLIENT)
public class MediaHandler
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final int MIN_FRAMES_TO_START = 2;
    private static final int BATCH_SIZE = 3;
    private static final long BATCH_DELAY_MS = 8L;
    private final List<ResourceLocation> frameTextures = new ArrayList<ResourceLocation>();
    private final List<Integer> delays = new ArrayList<Integer>();
    private final List<Integer> disposals = new ArrayList<Integer>();
    private final List<Integer> lefts = new ArrayList<Integer>();
    private final List<Integer> tops = new ArrayList<Integer>();
    private final List<Integer> frameWidths = new ArrayList<Integer>();
    private final List<Integer> frameHeights = new ArrayList<Integer>();
    private final AtomicInteger mediaWidth = new AtomicInteger(0);
    private final AtomicInteger mediaHeight = new AtomicInteger(0);
    private final AtomicBoolean isLoaded = new AtomicBoolean(false);
    private final AtomicBoolean isLoading = new AtomicBoolean(false);
    private final AtomicInteger totalExpectedFrames = new AtomicInteger(0);
    private final TextureManager textureManager;
    private final String modId;
    private final String mediaName;
    private volatile boolean loadingFailed = false;
    private final AtomicLong estimatedMemory = new AtomicLong(0L);
    private final boolean priorityLoad;

    public MediaHandler(String modId, String mediaName) {
        this(modId, mediaName, true);
    }

    public MediaHandler(String modId, String mediaName, boolean priorityLoad) {
        this.modId = modId;
        this.mediaName = mediaName;
        this.priorityLoad = priorityLoad;
        this.textureManager = Minecraft.m_91087_().m_91097_();
        File configDir = new File("config/AnimatedFrames/client_media");
        File mediaFile = new File(configDir, ClientCommands.getMediaFileName(mediaName));
        try {
            byte[] mediaData = Files.readAllBytes(mediaFile.toPath());
            this.processMedia(mediaData);
        }
        catch (IOException e) {
            LOGGER.error("IOException loading media {}: {}", (Object)mediaName, (Object)e.getMessage(), (Object)e);
            Utils.sendErrorMessage(null, "Error loading media: " + e.getMessage(), true);
            this.loadingFailed = true;
        }
    }

    public MediaHandler(String modId, String mediaName, byte[] mediaData) {
        this(modId, mediaName, mediaData, false);
    }

    public MediaHandler(String modId, String mediaName, byte[] mediaData, boolean priorityLoad) {
        this.modId = modId;
        this.mediaName = mediaName;
        this.priorityLoad = priorityLoad;
        this.textureManager = Minecraft.m_91087_().m_91097_();
        this.processMedia(mediaData);
    }

    private void processMedia(byte[] mediaData) {
        if (mediaData == null || mediaData.length == 0) {
            this.loadingFailed = true;
            return;
        }
        int maxSize = (Integer)AFConfig.MAX_FILE_SIZE_MB.get() * 1024 * 1024;
        long estimatedSize = (long)mediaData.length * 4L;
        if (!Utils.checkMemoryForGif(estimatedSize)) {
            LOGGER.error("Insufficient memory to load media {} (estimated size: {} bytes)", (Object)this.mediaName, (Object)estimatedSize);
            Utils.sendErrorMessage(null, "Insufficient memory to load media " + this.mediaName, true);
            this.loadingFailed = true;
            return;
        }
        if (mediaData.length > maxSize) {
            LOGGER.error("Media {} exceeds max size of {}MB", (Object)this.mediaName, AFConfig.MAX_FILE_SIZE_MB.get());
            Utils.sendErrorMessage(null, "The media file " + this.mediaName + " exceeds the maximum size of " + String.valueOf(AFConfig.MAX_FILE_SIZE_MB.get()) + "MB", true);
            this.loadingFailed = true;
            return;
        }
        if (!this.validateMediaHeader(mediaData, this.mediaName)) {
            return;
        }
        LOGGER.info("Loading media {} asynchronously with batching ({} bytes, priority: {})", (Object)this.mediaName, (Object)mediaData.length, (Object)this.priorityLoad);
        this.loadMediaAsyncWithBatching(mediaData);
    }

    private boolean validateMediaHeader(byte[] data, String mediaName) {
        String ext = mediaName.substring(mediaName.lastIndexOf(46) + 1).toLowerCase();
        if (ext.equals("png")) {
            if (data.length < 8 || !new String(data, 1, 3).equals("PNG")) {
                Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid PNG", true);
                this.loadingFailed = true;
                return false;
            }
        } else if (ext.equals("gif")) {
            if (data.length < 6 || !new String(data, 0, 6).startsWith("GIF89a") && !new String(data, 0, 6).startsWith("GIF87a")) {
                Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid GIF", true);
                this.loadingFailed = true;
                return false;
            }
        } else if (ext.equals("jpg") || ext.equals("jpeg")) {
            if (data.length < 2 || (data[0] & 0xFF) != 255 || (data[1] & 0xFF) != 216) {
                Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid JPG/JPEG", true);
                this.loadingFailed = true;
                return false;
            }
        } else {
            if (ext.equals("mp4")) {
                if (data.length < 8 || !new String(data, 4, 4).equals("ftyp")) {
                    Utils.sendErrorMessage(null, "The file " + mediaName + " is not a valid MP4", true);
                    this.loadingFailed = true;
                    return false;
                }
                Utils.sendErrorMessage(null, "MP4 no soportado a\u00fan. Usa GIF, PNG o JPG.", true);
                this.loadingFailed = true;
                return false;
            }
            Utils.sendErrorMessage(null, "Formato no soportado: " + ext, true);
            this.loadingFailed = true;
            return false;
        }
        return true;
    }

    private void loadMediaAsyncWithBatching(byte[] mediaData) {
        this.isLoading.set(true);
        EXECUTOR.submit(() -> {
            try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(mediaData));){
                ImageReader reader = ImageIO.getImageReaders(stream).next();
                reader.setInput(stream);
                String ext = this.mediaName.substring(this.mediaName.lastIndexOf(46) + 1).toLowerCase();
                int numFrames = ext.equals("png") || ext.equals("jpg") || ext.equals("jpeg") ? 1 : Math.min(reader.getNumImages(true), (Integer)AFConfig.MAX_FRAMES.get());
                this.totalExpectedFrames.set(numFrames);
                this.mediaWidth.set(this.getLogicalWidth(reader));
                this.mediaHeight.set(this.getLogicalHeight(reader));
                if (ext.equals("png") || ext.equals("jpg") || ext.equals("jpeg")) {
                    this.processStaticImage(reader);
                } else {
                    this.extractAllMetadata(reader, numFrames);
                    this.processGIFFramesWithBatching(reader, numFrames);
                }
                List<ResourceLocation> list = this.frameTextures;
                synchronized (list) {
                    if (this.frameTextures.isEmpty()) {
                        this.loadingFailed = true;
                        LOGGER.error("No frames loaded for media {}", (Object)this.mediaName);
                    } else {
                        this.isLoaded.set(true);
                        LOGGER.info("Successfully loaded {} frames for media {}", (Object)this.frameTextures.size(), (Object)this.mediaName);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Load failed for {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
                this.loadingFailed = true;
            }
            finally {
                this.isLoading.set(false);
            }
        });
    }

    private int getLogicalWidth(ImageReader reader) throws IOException {
        Node root;
        IIOMetadata meta = reader.getStreamMetadata();
        if (meta != null && (root = meta.getAsTree("javax_imageio_gif_stream_1.0")) != null) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"LogicalScreenDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("logicalScreenWidth"));
            }
        }
        return reader.getWidth(0);
    }

    private int getLogicalHeight(ImageReader reader) throws IOException {
        Node root;
        IIOMetadata meta = reader.getStreamMetadata();
        if (meta != null && (root = meta.getAsTree("javax_imageio_gif_stream_1.0")) != null) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"LogicalScreenDescriptor".equals(node.getNodeName())) continue;
                return Integer.parseInt(((Element)node).getAttribute("logicalScreenHeight"));
            }
        }
        return reader.getHeight(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStaticImage(ImageReader reader) throws IOException {
        BufferedImage image = reader.read(0);
        this.mediaWidth.set(image.getWidth());
        this.mediaHeight.set(image.getHeight());
        this.estimatedMemory.addAndGet((long)(image.getWidth() * image.getHeight()) * 4L);
        BufferedImage scaled = this.scaleImage(image);
        if (scaled == null) {
            this.loadingFailed = true;
            return;
        }
        ResourceLocation tex = this.registerTexture(scaled, 0);
        if (tex != null) {
            List<ResourceLocation> list = this.frameTextures;
            synchronized (list) {
                this.frameTextures.add(tex);
                this.delays.add(100);
                this.disposals.add(0);
                this.lefts.add(0);
                this.tops.add(0);
                this.frameWidths.add(scaled.getWidth());
                this.frameHeights.add(scaled.getHeight());
            }
        } else {
            this.loadingFailed = true;
        }
    }

    private void extractAllMetadata(ImageReader reader, int numFrames) throws IOException {
        for (int i = 0; i < numFrames; ++i) {
            IIOMetadata meta = reader.getImageMetadata(i);
            this.delays.add(this.getFrameDelay(meta));
            this.disposals.add(this.getDisposalMethod(meta));
            this.lefts.add(this.getLeft(meta));
            this.tops.add(this.getTop(meta));
            this.frameWidths.add(this.getFrameWidth(meta));
            this.frameHeights.add(this.getFrameHeight(meta));
        }
        LOGGER.info("Extracted metadata for {} frames in media {}", (Object)numFrames, (Object)this.mediaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGIFFramesWithBatching(ImageReader reader, int numFrames) throws IOException {
        BufferedImage canvas = new BufferedImage(this.mediaWidth.get(), this.mediaHeight.get(), 2);
        BufferedImage prevCanvas = null;
        for (int i = 0; i < numFrames; ++i) {
            if (i > 0 && i % 3 == 0) {
                try {
                    Thread.sleep(8L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (i == 1 && !this.isLoaded.get()) {
                List<ResourceLocation> ignored = this.frameTextures;
                synchronized (ignored) {
                    this.isLoaded.set(true);
                    LOGGER.info("Started playback early with {} frames for {}", (Object)this.frameTextures.size(), (Object)this.mediaName);
                }
            }
            BufferedImage rawFrame = reader.read(i);
            this.estimatedMemory.addAndGet((long)(rawFrame.getWidth() * rawFrame.getHeight()) * 4L);
            int x = this.lefts.get(i);
            int y = this.tops.get(i);
            int fw = this.frameWidths.get(i);
            int fh = this.frameHeights.get(i);
            int disposal = this.disposals.get(i);
            if (disposal == 3 && prevCanvas == null) {
                prevCanvas = this.copyImage(canvas);
            }
            Graphics2D g = canvas.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.drawImage((Image)rawFrame, x, y, null);
            g.dispose();
            BufferedImage fullFrame = this.copyImage(canvas);
            BufferedImage scaled = this.scaleImage(fullFrame);
            if (scaled == null) {
                this.loadingFailed = true;
                return;
            }
            ResourceLocation tex = this.registerTexture(scaled, i);
            if (tex != null) {
                List<ResourceLocation> list = this.frameTextures;
                synchronized (list) {
                    this.frameTextures.add(tex);
                }
            } else {
                this.loadingFailed = true;
                return;
            }
            if (disposal == 2) {
                g = canvas.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(x, y, fw, fh);
                g.dispose();
            } else if (disposal == 3 && prevCanvas != null) {
                canvas = this.copyImage(prevCanvas);
            }
            rawFrame.flush();
            fullFrame.flush();
        }
    }

    private BufferedImage copyImage(BufferedImage src) {
        if (src == null) {
            return null;
        }
        BufferedImage copy = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return copy;
    }

    private BufferedImage scaleImage(BufferedImage src) {
        if (src == null) {
            return null;
        }
        double scale = (Double)AFConfig.SCALE_FACTOR.get();
        int w = (int)((double)src.getWidth() * scale);
        int h = (int)((double)src.getHeight() * scale);
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage scaled = new BufferedImage(w, h, 2);
        Graphics2D g2d = scaled.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.drawImage(src, 0, 0, w, h, null);
        g2d.dispose();
        src.flush();
        return scaled;
    }

    private int getFrameDelay(IIOMetadata meta) {
        try {
            Node root = meta.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String delay;
                Node node = children.item(i);
                if (!"GraphicControlExtension".equals(node.getNodeName()) || (delay = ((Element)node).getAttribute("delayTime")).isEmpty()) continue;
                return Math.max(Integer.parseInt(delay) * 10, 10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 100;
    }

    private int getDisposalMethod(IIOMetadata meta) {
        try {
            Node root = meta.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String d;
                Node node = children.item(i);
                if (!"GraphicControlExtension".equals(node.getNodeName())) continue;
                return switch (d = ((Element)node).getAttribute("disposalMethod")) {
                    case "none", "doNotDispose" -> 1;
                    case "restoreToBackgroundColor" -> 2;
                    case "restoreToPrevious" -> 3;
                    default -> 0;
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private int getLeft(IIOMetadata meta) {
        return this.getIntAttr(meta, "imageLeftPosition", 0);
    }

    private int getTop(IIOMetadata meta) {
        return this.getIntAttr(meta, "imageTopPosition", 0);
    }

    private int getFrameWidth(IIOMetadata meta) {
        return this.getIntAttr(meta, "imageWidth", this.mediaWidth.get());
    }

    private int getFrameHeight(IIOMetadata meta) {
        return this.getIntAttr(meta, "imageHeight", this.mediaHeight.get());
    }

    private int getIntAttr(IIOMetadata meta, String attr, int fallback) {
        try {
            Node root = meta.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String val;
                Node node = children.item(i);
                if (!"ImageDescriptor".equals(node.getNodeName()) || (val = ((Element)node).getAttribute(attr)).isEmpty()) continue;
                return Integer.parseInt(val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private ResourceLocation registerTexture(BufferedImage image, int index) {
        if (image == null) {
            return null;
        }
        NativeImage nativeImg = this.convertToNativeImage(image);
        if (nativeImg == null || !Utils.checkMemoryForGif((long)(nativeImg.m_84982_() * nativeImg.m_85084_()) * 4L)) {
            if (nativeImg != null) {
                nativeImg.close();
            }
            return null;
        }
        DynamicTexture tex = new DynamicTexture(nativeImg);
        ResourceLocation loc = new ResourceLocation(this.modId, "media_" + this.mediaName + "_" + index);
        Minecraft.m_91087_().execute(() -> this.textureManager.m_118495_(loc, (AbstractTexture)tex));
        return loc;
    }

    private NativeImage convertToNativeImage(BufferedImage img) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            int[] pixels = img.getRGB(0, 0, w, h, null, 0, w);
            NativeImage nativeImg = new NativeImage(NativeImage.Format.RGBA, w, h, true);
            for (int i = 0; i < pixels.length; ++i) {
                int a = pixels[i] >> 24 & 0xFF;
                int r = pixels[i] >> 16 & 0xFF;
                int g = pixels[i] >> 8 & 0xFF;
                int b = pixels[i] & 0xFF;
                nativeImg.m_84988_(i % w, i / w, a << 24 | b << 16 | g << 8 | r);
            }
            img.flush();
            return nativeImg;
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert image: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceLocation> getFrameTextures() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            return new ArrayList<ResourceLocation>(this.frameTextures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getFrameDelays() {
        List<Integer> list = this.delays;
        synchronized (list) {
            return new ArrayList<Integer>(this.delays);
        }
    }

    public int getMediaWidth() {
        return this.mediaWidth.get();
    }

    public int getMediaHeight() {
        return this.mediaHeight.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            return this.isLoaded.get() && !this.loadingFailed && !this.frameTextures.isEmpty();
        }
    }

    public boolean isLoading() {
        return this.isLoading.get();
    }

    public boolean hasFailed() {
        return this.loadingFailed;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ResourceLocation> list = this.frameTextures;
        synchronized (list) {
            for (ResourceLocation tex : this.frameTextures) {
                this.textureManager.m_118513_(tex);
            }
            this.frameTextures.clear();
            this.delays.clear();
            this.disposals.clear();
            this.lefts.clear();
            this.tops.clear();
            this.frameWidths.clear();
            this.frameHeights.clear();
            this.isLoaded.set(false);
            this.isLoading.set(false);
            LOGGER.info("Closed media handler for {}", (Object)this.mediaName);
            System.gc();
        }
    }
}

