/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.ClientCommands;
import org.google.animated_frames.GifRenderer;
import org.google.animated_frames.ServerCommands;
import org.google.animated_frames.Utils;

public class NetworkHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("animated_frames", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final int MAX_PACKET_SIZE = 524288;
    protected static final Map<String, List<byte[]>> chunkBuffer = new ConcurrentHashMap<String, List<byte[]>>();
    protected static final Map<String, Integer> expectedChunks = new ConcurrentHashMap<String, Integer>();
    protected static final Map<String, List<Integer>> receivedChunks = new ConcurrentHashMap<String, List<Integer>>();
    private static final Map<String, Integer> retryCounts = new ConcurrentHashMap<String, Integer>();
    private static final ScheduledExecutorService RETRY_EXECUTOR = Executors.newScheduledThreadPool(1);
    private static final long RETRY_DELAY_SEC = 2L;

    public static void register() {
        int id = 0;
        INSTANCE.registerMessage(id++, MediaPrepPacket.class, MediaPrepPacket::encode, MediaPrepPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, MediaChunkPacket.class, MediaChunkPacket::encode, MediaChunkPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, SyncMediaPacket.class, SyncMediaPacket::encode, SyncMediaPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, StopMediaPacket.class, StopMediaPacket::encode, StopMediaPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, ChunkConfirmPacket.class, ChunkConfirmPacket::encode, ChunkConfirmPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, PlayLocalMediaPacket.class, PlayLocalMediaPacket::encode, PlayLocalMediaPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, ClientMediaListPacket.class, ClientMediaListPacket::encode, ClientMediaListPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        INSTANCE.registerMessage(id++, RequestClientMediaListPacket.class, RequestClientMediaListPacket::encode, RequestClientMediaListPacket::decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                packet.handle((Supplier<NetworkEvent.Context>)ctx);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static void initializeRetryCount(String mediaName, ServerPlayer player) {
        String key = mediaName + ":" + player.m_20148_().toString();
        retryCounts.put(key, 0);
    }

    public static void scheduleMediaRetry(ServerPlayer player, String mediaName, int totalChunks, List<byte[]> chunks) {
        NetworkHandler.scheduleRetry(player, mediaName, totalChunks, chunks);
    }

    private static void scheduleRetry(ServerPlayer player, String mediaName, int totalChunks, List<byte[]> chunks) {
        String key = mediaName + ":" + player.m_20148_().toString();
        RETRY_EXECUTOR.schedule(() -> {
            int currentRetry = retryCounts.getOrDefault(key, 0);
            if (currentRetry >= (Integer)AFConfig.RETRY_LIMIT.get()) {
                LOGGER.error("Max retries reached for media {} to player {} ({}/{})", (Object)mediaName, (Object)player.m_7755_().getString(), (Object)currentRetry, AFConfig.RETRY_LIMIT.get());
                Utils.sendErrorMessage(null, "Failed to receive all media chunks for " + mediaName + " after max retries.", true);
                return;
            }
            List<Integer> received = receivedChunks.get(mediaName);
            if (received == null || received.size() < totalChunks) {
                LOGGER.info("Retrying missing chunks for media {}, received: {}/{} (retry {}) to player {}", (Object)mediaName, (Object)(received != null ? received.size() : 0), (Object)totalChunks, (Object)(currentRetry + 1), (Object)player.m_7755_().getString());
                for (int i = 0; i < totalChunks; ++i) {
                    if (received != null && received.contains(i)) continue;
                    LOGGER.info("Resending chunk {} for media {} to player {}", (Object)i, (Object)mediaName, (Object)player.m_7755_().getString());
                    INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MediaChunkPacket(mediaName, i, (byte[])chunks.get(i), totalChunks));
                }
                retryCounts.put(key, currentRetry + 1);
                NetworkHandler.scheduleRetry(player, mediaName, totalChunks, chunks);
            }
        }, 2L, TimeUnit.SECONDS);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] compressData(byte[] data) throws IOException {
        if (!((Boolean)AFConfig.USE_COMPRESSION.get()).booleanValue()) {
            return data;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(baos);){
                gzip.write(data);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error("Error compressing media data: {}", (Object)e.getMessage(), (Object)e);
            Utils.sendErrorMessage(null, "Error compressing media: " + e.getMessage(), true);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressData(byte[] compressedData) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(compressedData);){
            byte[] byArray;
            try (GZIPInputStream gzip = new GZIPInputStream(bais);){
                byArray = gzip.readAllBytes();
            }
            return byArray;
        }
        catch (IOException e) {
            LOGGER.error("Error decompressing media data: {}", (Object)e.getMessage(), (Object)e);
            Utils.sendErrorMessage(null, "Error decompressing media: " + e.getMessage(), true);
            throw e;
        }
    }

    public static void sendMediaPacket(ServerPlayer player, String mediaName, byte[] mediaData, float duration, String position, float scale) throws IOException {
        int i;
        byte[] compressedData = NetworkHandler.compressData(mediaData);
        int totalChunks = (int)Math.ceil((double)compressedData.length / 524288.0);
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (i = 0; i < totalChunks; ++i) {
            int start = i * 524288;
            int length = Math.min(524288, compressedData.length - start);
            byte[] chunk = new byte[length];
            System.arraycopy(compressedData, start, chunk, 0, length);
            chunks.add(chunk);
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MediaPrepPacket(mediaName, totalChunks, duration, position, scale));
        for (i = 0; i < totalChunks; ++i) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MediaChunkPacket(mediaName, i, (byte[])chunks.get(i), totalChunks));
            LOGGER.info("Sent chunk {}/{} for media {} to player {}", (Object)i, (Object)totalChunks, (Object)mediaName, (Object)player.m_7755_().getString());
            try {
                Thread.sleep((Long)AFConfig.CHUNK_DELAY_MS.get());
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while delaying chunk send");
                Thread.currentThread().interrupt();
            }
        }
        NetworkHandler.initializeRetryCount(mediaName, player);
        NetworkHandler.scheduleMediaRetry(player, mediaName, totalChunks, chunks);
    }

    public static class MediaPrepPacket {
        private final String mediaName;
        private final int totalChunks;
        private final float duration;
        private final String position;
        private final float scale;

        public MediaPrepPacket(String mediaName, int totalChunks, float duration, String position, float scale) {
            this.mediaName = mediaName;
            this.totalChunks = totalChunks;
            this.duration = duration;
            this.position = position;
            this.scale = scale;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.mediaName, Short.MAX_VALUE);
            buf.writeInt(this.totalChunks);
            buf.writeFloat(this.duration);
            buf.m_130072_(this.position, Short.MAX_VALUE);
            buf.writeFloat(this.scale);
        }

        public static MediaPrepPacket decode(FriendlyByteBuf buf) {
            return new MediaPrepPacket(buf.m_130136_(Short.MAX_VALUE), buf.readInt(), buf.readFloat(), buf.m_130136_(Short.MAX_VALUE), buf.readFloat());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> GifRenderer.prepare(this.mediaName, this.totalChunks, this.duration, this.position, this.scale));
            context.setPacketHandled(true);
        }
    }

    public static class MediaChunkPacket {
        private final String mediaName;
        private final int chunkIndex;
        private final byte[] chunkData;
        private final int totalChunks;

        public MediaChunkPacket(String mediaName, int chunkIndex, byte[] chunkData, int totalChunks) {
            this.mediaName = mediaName;
            this.chunkIndex = chunkIndex;
            this.chunkData = chunkData;
            this.totalChunks = totalChunks;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.mediaName, Short.MAX_VALUE);
            buf.writeInt(this.chunkIndex);
            buf.m_130087_(this.chunkData);
            buf.writeInt(this.totalChunks);
        }

        public static MediaChunkPacket decode(FriendlyByteBuf buf) {
            return new MediaChunkPacket(buf.m_130136_(Short.MAX_VALUE), buf.readInt(), buf.m_130052_(), buf.readInt());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                try {
                    GifRenderer.addChunk(this.mediaName, this.chunkIndex, this.chunkData, this.totalChunks);
                }
                catch (IOException e) {
                    LOGGER.error("Error adding chunk for media {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class SyncMediaPacket {
        private final String mediaName;
        private final int frame;
        private final long serverTime;

        public SyncMediaPacket(String mediaName, int frame, long serverTime) {
            this.mediaName = mediaName;
            this.frame = frame;
            this.serverTime = serverTime;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.mediaName, Short.MAX_VALUE);
            buf.writeInt(this.frame);
            buf.writeLong(this.serverTime);
        }

        public static SyncMediaPacket decode(FriendlyByteBuf buf) {
            return new SyncMediaPacket(buf.m_130136_(Short.MAX_VALUE), buf.readInt(), buf.readLong());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> GifRenderer.sync(this.mediaName, this.frame, this.serverTime));
            context.setPacketHandled(true);
        }
    }

    public static class StopMediaPacket {
        public void encode(FriendlyByteBuf buf) {
        }

        public static StopMediaPacket decode(FriendlyByteBuf buf) {
            return new StopMediaPacket();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(GifRenderer::stop);
            context.setPacketHandled(true);
        }
    }

    public static class ChunkConfirmPacket {
        private final String mediaName;
        private final int chunkIndex;

        public ChunkConfirmPacket(String mediaName, int chunkIndex) {
            this.mediaName = mediaName;
            this.chunkIndex = chunkIndex;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.mediaName, Short.MAX_VALUE);
            buf.writeInt(this.chunkIndex);
        }

        public static ChunkConfirmPacket decode(FriendlyByteBuf buf) {
            return new ChunkConfirmPacket(buf.m_130136_(Short.MAX_VALUE), buf.readInt());
        }

        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                List received = receivedChunks.computeIfAbsent(this.mediaName, k -> new ArrayList());
                received.add(this.chunkIndex);
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayLocalMediaPacket {
        private final String mediaName;
        private final float duration;
        private final String position;
        private final float scale;

        public PlayLocalMediaPacket(String mediaName, float duration, String position, float scale) {
            this.mediaName = mediaName;
            this.duration = duration;
            this.position = position;
            this.scale = scale;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130072_(this.mediaName, Short.MAX_VALUE);
            buf.writeFloat(this.duration);
            buf.m_130072_(this.position, Short.MAX_VALUE);
            buf.writeFloat(this.scale);
        }

        public static PlayLocalMediaPacket decode(FriendlyByteBuf buf) {
            return new PlayLocalMediaPacket(buf.m_130136_(Short.MAX_VALUE), buf.readFloat(), buf.m_130136_(Short.MAX_VALUE), buf.readFloat());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                GifRenderer.stop();
                File configDir = new File("config/AnimatedFrames/client_media");
                File mediaFile = new File(configDir, ClientCommands.getMediaFileName(this.mediaName));
                if (!mediaFile.exists()) {
                    LOGGER.error("Local media {} does not exist in config/AnimatedFrames/client_media", (Object)this.mediaName);
                    Utils.sendErrorMessage(null, "The media " + this.mediaName + " does not exist in config/AnimatedFrames/client_media.", true);
                    return;
                }
                try {
                    byte[] mediaData = Files.readAllBytes(mediaFile.toPath());
                    if (ClientCommands.validateMedia(mediaData, this.mediaName)) {
                        GifRenderer.startLocal(this.mediaName, this.duration, this.position, this.scale);
                        LOGGER.info("Playing local media: {}", (Object)this.mediaName);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error reading local media {}: {}", (Object)this.mediaName, (Object)e.getMessage(), (Object)e);
                    Utils.sendErrorMessage(null, "Error reading local media: " + e.getMessage(), true);
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class ClientMediaListPacket {
        private final List<String> mediaFiles;

        public ClientMediaListPacket(List<String> mediaFiles) {
            this.mediaFiles = mediaFiles;
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeInt(this.mediaFiles.size());
            for (String file : this.mediaFiles) {
                buf.m_130072_(file, Short.MAX_VALUE);
            }
        }

        public static ClientMediaListPacket decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<String> mediaFiles = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                mediaFiles.add(buf.m_130136_(Short.MAX_VALUE));
            }
            return new ClientMediaListPacket(mediaFiles);
        }

        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null) {
                    ServerCommands.updateClientMediaList(player, this.mediaFiles);
                    LOGGER.info("Received media list from player {}: {}", (Object)player.m_7755_().getString(), this.mediaFiles);
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class RequestClientMediaListPacket {
        public void encode(FriendlyByteBuf buf) {
        }

        public static RequestClientMediaListPacket decode(FriendlyByteBuf buf) {
            return new RequestClientMediaListPacket();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                File configDir = new File("config/AnimatedFrames/client_media");
                if (configDir.exists()) {
                    String[] mediaFiles = configDir.list((dir, name) -> Utils.isValidMediaExtension(name));
                    if (mediaFiles != null && mediaFiles.length > 0) {
                        List<String> mediaList = Arrays.asList(mediaFiles);
                        INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ClientMediaListPacket(mediaList));
                        LOGGER.info("Sent media list to server: {}", mediaList);
                    } else {
                        LOGGER.info("No media files found in config/AnimatedFrames/client_media to send to server");
                    }
                } else {
                    LOGGER.info("Folder config/AnimatedFrames/client_media not found; no media list sent to server");
                }
            });
            context.setPacketHandled(true);
        }
    }
}

