/*
 * Decompiled with CFR 0.152.
 */
package org.google.animated_frames;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.google.animated_frames.AFConfig;
import org.google.animated_frames.Animatedframes;
import org.google.animated_frames.ClientCommands;
import org.google.animated_frames.NetworkHandler;
import org.google.animated_frames.Utils;

@Mod.EventBusSubscriber(modid="animated_frames")
public class ServerCommands {
    private static final Logger LOGGER = LogManager.getLogger((String)"animated_frames");
    private static final Map<UUID, List<String>> clientMediaLists = new ConcurrentHashMap<UUID, List<String>>();
    private static final SuggestionProvider<CommandSourceStack> PLAYER_SUGGESTIONS = (context, builder) -> {
        List suggestions = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_().stream().map(Player::m_7755_).map(Component::getString).collect(Collectors.toList());
        suggestions.addAll(Arrays.asList("@a", "@p", "@r"));
        return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> MEDIA_SUGGESTIONS = (context, builder) -> {
        File configDir = new File("config/AnimatedFrames/server_media");
        if (configDir.exists()) {
            List mediaFiles = Arrays.stream(configDir.listFiles((dir, name) -> Utils.isValidMediaExtension(name))).map(File::getName).collect(Collectors.toList());
            return SharedSuggestionProvider.m_82970_(mediaFiles, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> LOCAL_MEDIA_SUGGESTIONS = (context, builder) -> {
        try {
            Collection targetPlayers = EntityArgument.m_91477_((CommandContext)context, (String)"target");
            if (targetPlayers.isEmpty()) {
                return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
            }
            List allMediaLists = targetPlayers.stream().map(player -> clientMediaLists.getOrDefault(player.m_20148_(), List.of())).filter(mediaList -> !mediaList.isEmpty()).collect(Collectors.toList());
            if (allMediaLists.isEmpty()) {
                return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
            }
            HashSet commonMedia = new HashSet((Collection)allMediaLists.get(0));
            for (List mediaList2 : allMediaLists) {
                commonMedia.retainAll(new HashSet(mediaList2));
            }
            return SharedSuggestionProvider.m_82970_(commonMedia, (SuggestionsBuilder)builder);
        }
        catch (CommandSyntaxException e) {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_230896_();
            if (executor != null) {
                List mediaFiles = clientMediaLists.getOrDefault(executor.m_20148_(), List.of());
                return SharedSuggestionProvider.m_82970_(mediaFiles, (SuggestionsBuilder)builder);
            }
            return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
        }
    };

    public static void updateClientMediaList(ServerPlayer player, List<String> mediaFiles) {
        clientMediaLists.put(player.m_20148_(), mediaFiles);
        LOGGER.debug("Updated media list for player {}: {}", (Object)player.m_7755_().getString(), mediaFiles);
    }

    public static void removeClientMediaList(UUID playerUUID) {
        clientMediaLists.remove(playerUUID);
        LOGGER.info("Removed media list for player with UUID {}", (Object)playerUUID);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mediaserver").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).suggests(PLAYER_SUGGESTIONS).then(Commands.m_82129_((String)"mediaName", (ArgumentType)StringArgumentType.string()).suggests(MEDIA_SUGGESTIONS).then(Commands.m_82129_((String)"duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"position", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("center", "topleft", "topright", "bottomleft", "bottomright", "topcenter", "bottomcenter", "leftcenter", "rightcenter"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(context -> {
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"target");
            String mediaName = StringArgumentType.getString((CommandContext)context, (String)"mediaName");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String position = StringArgumentType.getString((CommandContext)context, (String)"position");
            float size = FloatArgumentType.getFloat((CommandContext)context, (String)"size");
            byte[] mediaData = ServerCommands.getMediaData(mediaName);
            if (mediaData == null) {
                Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "The media " + mediaName + " does not exist or is invalid.", false);
                return 0;
            }
            for (ServerPlayer player : players) {
                try {
                    NetworkHandler.sendMediaPacket(player, mediaName, mediaData, duration, position, size);
                }
                catch (IOException e) {
                    LOGGER.error("Error sending media {} to player {}: {}", (Object)mediaName, (Object)player.m_7755_().getString(), (Object)e.getMessage(), (Object)e);
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "Error sending media to " + player.m_7755_().getString() + ": " + e.getMessage(), false);
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Sent media to " + players.size() + " players.")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
            return 1;
        })))))))).then(Commands.m_82127_((String)"playlocal").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).suggests(PLAYER_SUGGESTIONS).then(Commands.m_82129_((String)"mediaName", (ArgumentType)StringArgumentType.string()).suggests(LOCAL_MEDIA_SUGGESTIONS).then(Commands.m_82129_((String)"duration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"position", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("center", "topleft", "topright", "bottomleft", "bottomright", "topcenter", "bottomcenter", "leftcenter", "rightcenter"), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(context -> {
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"target");
            String mediaName = StringArgumentType.getString((CommandContext)context, (String)"mediaName");
            float duration = FloatArgumentType.getFloat((CommandContext)context, (String)"duration");
            String position = StringArgumentType.getString((CommandContext)context, (String)"position");
            float size = FloatArgumentType.getFloat((CommandContext)context, (String)"size");
            for (ServerPlayer player : players) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new NetworkHandler.PlayLocalMediaPacket(mediaName, duration, position, size));
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Instructed " + players.size() + " players to play local media: " + mediaName)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
            return 1;
        })))))))).then(Commands.m_82127_((String)"stop").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).suggests(PLAYER_SUGGESTIONS).executes(context -> {
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"target");
            for (ServerPlayer player : players) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new NetworkHandler.StopMediaPacket());
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Media stopped for " + players.size() + " players.")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
            return 1;
        })))).then(Commands.m_82127_((String)"list").executes(context -> {
            File configDir = new File("config/AnimatedFrames/server_media");
            if (configDir.exists()) {
                String[] mediaFiles = configDir.list((dir, name) -> Utils.isValidMediaExtension(name));
                if (mediaFiles != null && mediaFiles.length > 0) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Available server media: " + String.join((CharSequence)", ", mediaFiles))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
                } else {
                    Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "No media files found in config/AnimatedFrames/server_media/.", false);
                }
            } else {
                Utils.sendErrorMessage((CommandSourceStack)context.getSource(), "Folder config/AnimatedFrames/server_media/ not found.", false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(context -> {
            Animatedframes.reloadConfigsAndMedia();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Reloaded AnimatedFrames configs and media cache.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55))), false);
            return 1;
        }))).then(Commands.m_82127_((String)"help").executes(context -> {
            MutableComponent message = Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))).m_7220_((Component)Component.m_237113_((String)"AnimatedFrames Commands (Server):\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x55FF55)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver show <players> <media> <duration> <position> <size> - Displays a server-hosted GIF, PNG, JPG, JPEG, or MP4 to players.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"  Example: /mediaserver show @a example.jpg 10 center 1.0\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA)))).m_7220_((Component)Component.m_237113_((String)"  Positions: center, topleft, topright, bottomleft, bottomright, topcenter, bottomcenter, leftcenter, rightcenter\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA)))).m_7220_((Component)Component.m_237113_((String)"  Place media in config/AnimatedFrames/server_media/ folder (.gif, .png, .jpg, .jpeg, .mp4).\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver playlocal <players> <media> <duration> <position> <size> - Instructs players to play local media.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"  Example: /mediaserver playlocal @a example.jpg 10 center 1.0\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver stop <players> - Stops the media for players.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver list - Lists available server media.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver reload - Reloads configs and media cache.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"/mediaserver help - Shows this help.\n").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> message, false);
            return 1;
        })));
    }

    private static byte[] getMediaData(String mediaName) {
        byte[] mediaData = Animatedframes.getCachedMedia(mediaName);
        if (mediaData == null) {
            File configDir = new File("config/AnimatedFrames/server_media");
            File mediaFile = new File(configDir, ClientCommands.getMediaFileName(mediaName));
            if (!mediaFile.exists()) {
                return null;
            }
            try {
                mediaData = Files.readAllBytes(mediaFile.toPath());
                int maxSize = (Integer)AFConfig.MAX_FILE_SIZE_MB.get() * 1024 * 1024;
                if (mediaData.length > maxSize) {
                    return null;
                }
                if (!ClientCommands.validateMedia(mediaData, mediaName)) {
                    return null;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error reading media {}: {}", (Object)mediaName, (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
        return mediaData;
    }
}

