/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsong.fluid;

import net.mcreator.voidsong.init.VoidsongModBlocks;
import net.mcreator.voidsong.init.VoidsongModFluidTypes;
import net.mcreator.voidsong.init.VoidsongModFluids;
import net.mcreator.voidsong.init.VoidsongModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class LiquidVoidFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)VoidsongModFluidTypes.LIQUID_VOID_TYPE.get(), () -> (Fluid)VoidsongModFluids.LIQUID_VOID.get(), () -> (Fluid)VoidsongModFluids.FLOWING_LIQUID_VOID.get()).explosionResistance(100.0f).levelDecreasePerBlock(2).bucket(() -> (Item)VoidsongModItems.LIQUID_VOID_BUCKET.get()).block(() -> (LiquidBlock)VoidsongModBlocks.LIQUID_VOID.get());

    private LiquidVoidFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.ASH;
    }

    public static class Flowing
    extends LiquidVoidFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends LiquidVoidFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

