/*
 * Decompiled with CFR 0.152.
 */
package net.qualityequipment.configuration;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ReforgesConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<String> FALLBACK_MATERIAL;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MATERIAL_OVERRIDES;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> REFORGE_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<Boolean> AUTO_REFORGE;
    public static final ModConfigSpec.ConfigValue<Double> AUTO_REFORGE_CHANCE;

    static {
        BUILDER.push("Materials");
        FALLBACK_MATERIAL = BUILDER.comment("This material will be used to reforge an item that does not have a material override or repair item").define("Fallback", (Object)BuiltInRegistries.ITEM.getKey((Object)Blocks.OBSIDIAN.asItem()).toString());
        MATERIAL_OVERRIDES = BUILDER.comment("In this list you can define different reforge items for specific equipment.\nThis can override repair items and will be used instead of the fallback item in case no repair item exists.\nThe left item is the equipment and right is the material.").defineList("Overrides", List.of("minecraft:bow,minecraft:string", "minecraft:crossbow,minecraft:iron_ingot", "quality_equipment:emerald_ring,minecraft:emerald", "quality_equipment:emerald_amulet,minecraft:emerald"), entry -> true);
        BUILDER.pop();
        BUILDER.push("Reforging");
        REFORGE_BLACKLIST = BUILDER.comment("A list of equipment that cannot be reforged.").defineList("Blacklist", List.of(" "), entry -> true);
        AUTO_REFORGE = BUILDER.comment("If true, items have a chance to be automatically reforged when they enter the player's inventory.").define("AutoReforge", true);
        AUTO_REFORGE_CHANCE = BUILDER.comment("The chance an item has of being automatically reforged.\nMax is 1.0 (100%) and minimum is 0.1 (10%).").define("AutoReforgeChance", (Object)0.5);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

