/*
 * Decompiled with CFR 0.152.
 */
package net.qualityequipment.procedures;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.qualityequipment.block.entity.ReforgingStationBlockEntity;

@EventBusSubscriber(modid="quality_equipment", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ReforgingStationRendererProcedure {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        double cameraX = event.getCamera().getPosition().x;
        double cameraY = event.getCamera().getPosition().y;
        double cameraZ = event.getCamera().getPosition().z;
        int renderDistance = (Integer)minecraft.options.renderDistance().get();
        int minChunkX = ((int)cameraX >> 4) - renderDistance;
        int maxChunkX = ((int)cameraX >> 4) + renderDistance;
        int minChunkZ = ((int)cameraZ >> 4) - renderDistance;
        int maxChunkZ = ((int)cameraZ >> 4) + renderDistance;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (!level.hasChunk(chunkX, chunkZ)) continue;
                LevelChunk chunk = level.getChunk(chunkX, chunkZ);
                for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
                    BlockPos pos = (BlockPos)entry.getKey();
                    BlockEntity blockEntity = (BlockEntity)entry.getValue();
                    if (!(blockEntity instanceof ReforgingStationBlockEntity)) continue;
                    ReforgingStationBlockEntity reforgingStation = (ReforgingStationBlockEntity)blockEntity;
                    double distance = pos.distSqr((Vec3i)new BlockPos((int)cameraX, (int)cameraY, (int)cameraZ));
                    if (distance > 4096.0) continue;
                    ReforgingStationRendererProcedure.renderReforgingStationItems(reforgingStation, poseStack, (MultiBufferSource)bufferSource, pos, cameraX, cameraY, cameraZ, event.getPartialTick().getGameTimeDeltaTicks());
                }
            }
        }
    }

    private static ItemStack itemFromBlockInventory(LevelAccessor world, BlockPos pos, int slot) {
        ILevelExtension ext;
        IItemHandler itemHandler;
        if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private static void renderReforgingStationItems(ReforgingStationBlockEntity te, PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, double cameraX, double cameraY, double cameraZ, float partialTicks) {
        ItemStack item1;
        int packedLight;
        BlockState blockState = te.getLevel().getBlockState(pos);
        Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        float blockRotation = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraX + 0.5, (double)pos.getY() - cameraY, (double)pos.getZ() - cameraZ + 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(blockRotation));
        double yOffset = 1.01;
        try {
            int blockLight = te.getLevel().getBrightness(LightLayer.BLOCK, pos);
            int skyLight = te.getLevel().getBrightness(LightLayer.SKY, pos);
            packedLight = blockLight << 4 | skyLight << 20;
        }
        catch (Exception e) {
            packedLight = OverlayTexture.NO_OVERLAY;
        }
        int packedOverlay = 655360;
        ItemStack item0 = ReforgingStationRendererProcedure.itemFromBlockInventory((LevelAccessor)te.getLevel(), pos, 0);
        if (!item0.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0, yOffset, -0.25);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(160.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.renderStatic(item0, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, te.getLevel(), 0);
            poseStack.popPose();
        }
        if (!(item1 = ReforgingStationRendererProcedure.itemFromBlockInventory((LevelAccessor)te.getLevel(), pos, 1)).isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.25, yOffset, 0.25);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(40.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.renderStatic(item1, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, te.getLevel(), 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

