/*
 * Decompiled with CFR 0.152.
 */
package net.qualityequipment.procedures;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.qualityequipment.QualityEquipmentMod;
import net.qualityequipment.network.QualityEquipmentModVariables;

@EventBusSubscriber
public class SyncQualitiesProcedure {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean clear = true;
        for (Object object : QualityEquipmentModVariables.qualities) {
            JsonObject quality = (JsonObject)object;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new QualityMessage(quality.toString(), clear), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!clear) continue;
            clear = false;
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public record QualityMessage(String quality, boolean clear) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<QualityMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"quality_equipment", (String)"init_quality"));
        public static final StreamCodec<RegistryFriendlyByteBuf, QualityMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeUtf(message.quality);
            buffer.writeBoolean(message.clear);
        }, buffer -> new QualityMessage(buffer.readUtf(), buffer.readBoolean()));

        public CustomPacketPayload.Type<QualityMessage> type() {
            return TYPE;
        }

        public static void handleData(QualityMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                context.enqueueWork(() -> {
                    if (message.clear) {
                        QualityEquipmentModVariables.qualities.clear();
                    }
                    QualityEquipmentModVariables.qualities.add(new Object(){

                        public JsonObject parse(String rawJson) {
                            try {
                                return (JsonObject)new Gson().fromJson(rawJson, JsonObject.class);
                            }
                            catch (Exception e) {
                                QualityEquipmentMod.LOGGER.error((Object)e);
                                return (JsonObject)new Gson().fromJson("{}", JsonObject.class);
                            }
                        }
                    }.parse(message.quality));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            QualityEquipmentMod.addNetworkMessage(TYPE, STREAM_CODEC, QualityMessage::handleData);
        }
    }
}

