/*
 * Decompiled with CFR 0.152.
 */
package com.funcybear;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;

public class FuncysScreenshot
implements ClientModInitializer {
    private final Set<String> knownScreenshots = new HashSet<String>();
    private Path screenshotsDir;
    private boolean initialized = false;

    public void onInitializeClient() {
        System.out.println("[FuncysScreenshot] Screenshot Watcher Activated!");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.screenshotsDir = client.field_1697.toPath().resolve("screenshots");
                try {
                    if (Files.exists(this.screenshotsDir, new LinkOption[0])) {
                        this.knownScreenshots.addAll(Files.list(this.screenshotsDir).filter(p -> p.toString().endsWith(".png")).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet()));
                    }
                }
                catch (Exception e) {
                    System.err.println("[FuncysScreenshot] Failed to scan existing screenshots.");
                    e.printStackTrace();
                }
            }
            try {
                if (this.screenshotsDir != null && Files.exists(this.screenshotsDir, new LinkOption[0])) {
                    Files.list(this.screenshotsDir).filter(p -> p.toString().endsWith(".png")).filter(p -> !this.knownScreenshots.contains(p.getFileName().toString())).forEach(p -> this.moveScreenshot((Path)p, client));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void moveScreenshot(Path screenshotPath, class_310 client) {
        try {
            String fileName = screenshotPath.getFileName().toString();
            this.knownScreenshots.add(fileName);
            Object subfolder = client.method_1576() != null ? "singleplayer/" + this.sanitize(client.method_1576().method_27728().method_150()) : (client.method_1558() != null ? "multiplayer/" + this.sanitize(client.method_1558().field_3761) : "unknown");
            Path targetDir = this.screenshotsDir.resolve((String)subfolder);
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Path targetPath = targetDir.resolve(fileName);
            Files.move(screenshotPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("[FuncysScreenshot] Moved: " + fileName + " -> " + (String)subfolder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String sanitize(String input) {
        return input.replaceAll("[^a-zA-Z0-9-_]", "_");
    }
}

