/*
 * Decompiled with CFR 0.152.
 */
package me.arthropodr.reversiblecrafting.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.arthropodr.reversiblecrafting.ReversibleCrafting;
import me.arthropodr.reversiblecrafting.utils.DisableManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DisableCommand {
    private final DisableManager disableManager;

    public DisableCommand(ReversibleCrafting plugin) {
        this.disableManager = new DisableManager(plugin);
    }

    public boolean handleCommand(CommandSender sender, String[] args) {
        String action;
        switch (action = args[0].toLowerCase()) {
            case "disable": {
                if (!sender.hasPermission("reversiblecrafting.disable")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to disable items!");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rvc disable <item_name/this>");
                    return true;
                }
                this.handleDisable(sender, args[1].toUpperCase());
                break;
            }
            case "enable": {
                if (!sender.hasPermission("reversiblecrafting.enable")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to enable items!");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rvc enable <item_name>");
                    return true;
                }
                this.handleEnable(sender, args[1].toUpperCase());
                break;
            }
            case "list": {
                if (!sender.hasPermission("reversiblecrafting.list")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view disabled items!");
                    return true;
                }
                this.handleList(sender);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown action. Use disable, enable, or list");
            }
        }
        return true;
    }

    private void handleDisable(CommandSender sender, String itemIdentifier) {
        if (itemIdentifier.equals("THIS") && sender instanceof Player) {
            Player player = (Player)sender;
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.getType() == Material.AIR) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must hold an item to disable it!");
                return;
            }
            ItemMeta meta = item.getItemMeta();
            String identifier = meta != null && meta.hasDisplayName() ? meta.getDisplayName() : item.getType().name();
            this.disableManager.disableItem(identifier);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully disabled: " + identifier);
        } else {
            try {
                Material material = Material.valueOf((String)itemIdentifier);
                this.disableManager.disableItem(material.name());
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully disabled: " + material.name());
            }
            catch (IllegalArgumentException e) {
                this.disableManager.disableItem(itemIdentifier);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully disabled custom item: " + itemIdentifier);
            }
        }
    }

    private void handleEnable(CommandSender sender, String itemIdentifier) {
        if (this.disableManager.getDisabledItems().contains(itemIdentifier)) {
            this.disableManager.enableItem(itemIdentifier);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully enabled: " + itemIdentifier);
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This item is not disabled!");
        }
    }

    private void handleList(CommandSender sender) {
        List<String> disabledItems = this.disableManager.getDisabledItems();
        if (disabledItems.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No items are currently disabled.");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabled items:");
        for (String item : disabledItems) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "- " + item);
        }
    }

    public List<String> onTabComplete(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            String action = args[0].toLowerCase();
            String partial = args[1].toUpperCase();
            if (action.equals("disable")) {
                if ("THIS".startsWith(partial)) {
                    completions.add("this");
                }
                completions.addAll(Arrays.stream(Material.values()).filter(material -> material.isItem() && !material.isAir()).map(Enum::name).filter(name -> name.startsWith(partial)).collect(Collectors.toList()));
            } else if (action.equals("enable")) {
                completions.addAll(this.disableManager.getDisabledItems().stream().filter(item -> item.toUpperCase().startsWith(partial)).collect(Collectors.toList()));
            }
        }
        return completions;
    }
}

