/*
 * Decompiled with CFR 0.152.
 */
package me.arthropodr.reversiblecrafting.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.arthropodr.reversiblecrafting.ReversibleCrafting;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DisableManager {
    private final ReversibleCrafting plugin;
    private final File configFile;
    private FileConfiguration disabledConfig;
    private List<String> disabledItems;

    public DisableManager(ReversibleCrafting plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "disabled-items.yml");
        this.loadDisabledItems();
    }

    private void loadDisabledItems() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("disabled-items.yml", false);
        }
        this.disabledConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.disabledItems = this.disabledConfig.getStringList("disabled-items");
        if (this.disabledItems == null) {
            this.disabledItems = new ArrayList<String>();
            this.disabledConfig.set("disabled-items", this.disabledItems);
            this.saveDisabledItems();
        }
    }

    private void saveDisabledItems() {
        try {
            this.disabledConfig.set("disabled-items", this.disabledItems);
            this.disabledConfig.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save disabled items to " + String.valueOf(this.configFile));
            e.printStackTrace();
        }
    }

    public boolean isItemDisabled(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.disabledItems.contains(item.getType().name())) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            String strippedName = ChatColor.stripColor((String)displayName);
            return this.disabledItems.contains(displayName) || this.disabledItems.contains(strippedName);
        }
        return false;
    }

    public void disableItem(String itemIdentifier) {
        this.disabledItems.removeIf(item -> ChatColor.stripColor((String)item).equalsIgnoreCase(ChatColor.stripColor((String)itemIdentifier)));
        this.disabledItems.add(itemIdentifier);
        this.saveDisabledItems();
    }

    public void enableItem(String itemIdentifier) {
        boolean removed = this.disabledItems.remove(itemIdentifier);
        if (!removed) {
            this.disabledItems.removeIf(item -> ChatColor.stripColor((String)item).equalsIgnoreCase(ChatColor.stripColor((String)itemIdentifier)));
        }
        this.saveDisabledItems();
    }

    public List<String> getDisabledItems() {
        return new ArrayList<String>(this.disabledItems);
    }
}

