/*
 * Decompiled with CFR 0.152.
 */
package me.arthropodr.reversiblecrafting.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.arthropodr.reversiblecrafting.ReversibleCrafting;
import me.arthropodr.reversiblecrafting.utils.DisableManager;
import me.arthropodr.reversiblecrafting.utils.NetheriteItems;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ReverseUtils {
    private static final Map<Material, ItemStack[]> customReverseRecipes = new HashMap<Material, ItemStack[]>();

    public static boolean reverseItem(Player player, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        DisableManager disableManager = new DisableManager(ReversibleCrafting.getInstance());
        if (disableManager.isItemDisabled(item)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This item cannot be reversed.");
            return false;
        }
        Material itemType = item.getType();
        ItemStack originalItem = item.clone();
        if (customReverseRecipes.containsKey(itemType)) {
            ReverseUtils.giveReversedItems(player, originalItem, customReverseRecipes.get(itemType));
            return true;
        }
        List recipes = Bukkit.getServer().getRecipesFor(new ItemStack(itemType));
        if (recipes.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This item cannot be reversed.");
            return false;
        }
        Recipe bestRecipe = ReverseUtils.findBestRecipe(recipes);
        if (bestRecipe == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No valid recipe found for this item.");
            return false;
        }
        int resultAmount = bestRecipe.getResult().getAmount();
        if (originalItem.getAmount() < resultAmount) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Need at least " + resultAmount + " items to reverse craft.");
            return false;
        }
        int timesToReverse = originalItem.getAmount() / resultAmount;
        HashMap<Material, Integer> ingredients = new HashMap<Material, Integer>();
        if (bestRecipe instanceof ShapelessRecipe) {
            ((ShapelessRecipe)bestRecipe).getIngredientList().forEach(ingredient -> {
                if (ingredient != null) {
                    ingredients.merge(ingredient.getType(), ingredient.getAmount() * timesToReverse, Integer::sum);
                }
            });
        } else if (bestRecipe instanceof ShapedRecipe) {
            ((ShapedRecipe)bestRecipe).getIngredientMap().values().forEach(ingredient -> {
                if (ingredient != null) {
                    ingredients.merge(ingredient.getType(), ingredient.getAmount() * timesToReverse, Integer::sum);
                }
            });
        }
        if (ingredients.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This recipe has no ingredients to return.");
            return false;
        }
        ItemStack itemToRemove = originalItem.clone();
        itemToRemove.setAmount(timesToReverse * resultAmount);
        ingredients.forEach((material, amount) -> {
            ItemStack ingredient = new ItemStack(material, amount.intValue());
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{ingredient});
            leftover.values().forEach(stack -> player.getWorld().dropItemNaturally(player.getLocation(), stack));
        });
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully reversed " + timesToReverse * resultAmount + " items!");
        return true;
    }

    private static void removeExactItem(Player player, ItemStack originalItem, int amountToRemove) {
        int remainingToRemove = amountToRemove;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length && remainingToRemove > 0; ++i) {
            ItemStack invItem = contents[i];
            if (invItem == null || !invItem.isSimilar(originalItem)) continue;
            if (invItem.getAmount() > remainingToRemove) {
                invItem.setAmount(invItem.getAmount() - remainingToRemove);
                remainingToRemove = 0;
                continue;
            }
            remainingToRemove -= invItem.getAmount();
            player.getInventory().setItem(i, null);
        }
        player.updateInventory();
    }

    private static void giveReversedItems(Player player, ItemStack item, ItemStack[] results) {
        if (!player.getInventory().containsAtLeast(item, 1)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find the required item in your inventory.");
            return;
        }
        ReverseUtils.removeExactItem(player, item, 1);
        for (ItemStack result : results) {
            player.getInventory().addItem(new ItemStack[]{result}).values().forEach(leftover -> player.getWorld().dropItemNaturally(player.getLocation(), leftover));
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Successfully reversed " + item.getType().name() + "!");
    }

    private static Recipe findBestRecipe(Iterable<Recipe> recipes) {
        Recipe bestRecipe = null;
        int bestIngredientCount = 0;
        for (Recipe recipe : recipes) {
            int ingredientCount;
            if (!(recipe instanceof ShapelessRecipe) && !(recipe instanceof ShapedRecipe) || (ingredientCount = ReverseUtils.countIngredients(recipe)) <= bestIngredientCount) continue;
            bestIngredientCount = ingredientCount;
            bestRecipe = recipe;
        }
        return bestRecipe;
    }

    private static int countIngredients(Recipe recipe) {
        if (recipe instanceof ShapelessRecipe) {
            return ((ShapelessRecipe)recipe).getIngredientList().size();
        }
        if (recipe instanceof ShapedRecipe) {
            return ((ShapedRecipe)recipe).getIngredientMap().size();
        }
        return 0;
    }

    static {
        customReverseRecipes.putAll(NetheriteItems.getNetheriteRecipes());
    }
}

