/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.command;

import cn.handyplus.login.expansion.constants.TabListEnum;
import cn.handyplus.login.expansion.lib.annotation.HandyCommand;
import cn.handyplus.login.expansion.lib.command.HandyCommandWrapper;
import cn.handyplus.login.expansion.lib.constants.BaseConstants;
import cn.handyplus.login.expansion.lib.util.BaseUtil;
import cn.handyplus.login.expansion.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="loginExpansion")
public class LoginExpansionCommand
implements TabExecutor {
    private static final String PERMISSION = "loginExpansion.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Object> commands = !sender.hasPermission(PERMISSION) ? new ArrayList() : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return;
        }
        List helps = BaseConstants.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
    }
}

