/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.command.player;

import cn.handyplus.login.expansion.constants.LoginExpansionConstants;
import cn.handyplus.login.expansion.hook.PlaceholderApiUtil;
import cn.handyplus.login.expansion.hook.VaultUtil;
import cn.handyplus.login.expansion.lib.command.IHandyCommandEvent;
import cn.handyplus.login.expansion.lib.constants.BaseConstants;
import cn.handyplus.login.expansion.lib.core.CollUtil;
import cn.handyplus.login.expansion.lib.util.AssertUtil;
import cn.handyplus.login.expansion.lib.util.BaseUtil;
import cn.handyplus.login.expansion.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WelcomeCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "welcome";
    }

    @Override
    public String permission() {
        return "loginExpansion.welcome";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        this.welcome(args[1], args[2]);
    }

    private synchronized void welcome(String regPlayerName, String onlinePlayerName) {
        Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(onlinePlayerName);
        if (!onlinePlayerOpt.isPresent()) {
            return;
        }
        Player onlinePlayer = onlinePlayerOpt.get();
        Long time = LoginExpansionConstants.REG_PLAYER_LIST.get(regPlayerName);
        if (time == null) {
            MessageUtil.sendMessage(onlinePlayerName, BaseUtil.getMsgNotColor("noPlayerMsg"));
            return;
        }
        if ((System.currentTimeMillis() - time) / (long)LoginExpansionConstants.ONE_THOUSAND.intValue() > (long)BaseConstants.CONFIG.getInt("welcomeTime", 600)) {
            MessageUtil.sendMessage(onlinePlayerName, BaseUtil.getMsgNotColor("noPlayerMsg"));
            return;
        }
        String welcomeMsg = this.getWelcomeMsg(regPlayerName, onlinePlayer);
        List<String> playerList = LoginExpansionConstants.PLAYER_WELCOME_NUMBER.get(onlinePlayer.getUniqueId());
        if (CollUtil.isEmpty(playerList)) {
            playerList = new ArrayList<String>();
        }
        if (playerList.contains(regPlayerName)) {
            MessageUtil.sendMessage(onlinePlayer, BaseUtil.getMsgNotColor("executedMsg", ""));
            return;
        }
        onlinePlayer.chat(welcomeMsg);
        if (playerList.size() >= BaseConstants.CONFIG.getInt("moneyNumber", 3)) {
            return;
        }
        int rewardMin = BaseConstants.CONFIG.getInt("money.min", 100);
        int rewardMax = BaseConstants.CONFIG.getInt("money.max", 1000);
        int rewardAmount = new Random().nextInt(rewardMax - rewardMin + 1) + rewardMin;
        VaultUtil.add(onlinePlayer, rewardAmount);
        MessageUtil.sendMessage(onlinePlayer, BaseUtil.getMsgNotColor("moneyMsg", "").replace("${money}", rewardAmount + ""));
        playerList.add(regPlayerName);
        LoginExpansionConstants.PLAYER_WELCOME_NUMBER.put(onlinePlayer.getUniqueId(), playerList);
    }

    private String getWelcomeMsg(String playerName, Player player) {
        List welcomeMsg = BaseConstants.LANG_CONFIG.getStringList("welcome");
        if (CollUtil.isEmpty(welcomeMsg)) {
            return "";
        }
        Collections.shuffle(welcomeMsg);
        String mag = ((String)welcomeMsg.get(0)).replace("${player}", playerName);
        BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, mag));
        return mag;
    }
}

