/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.core;

import cn.handyplus.login.expansion.constants.LoginExpansionConstants;
import cn.handyplus.login.expansion.hook.PlaceholderApiUtil;
import cn.handyplus.login.expansion.lib.constants.BaseConstants;
import cn.handyplus.login.expansion.lib.core.CollUtil;
import cn.handyplus.login.expansion.lib.core.StrUtil;
import cn.handyplus.login.expansion.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.login.expansion.lib.util.BaseUtil;
import cn.handyplus.login.expansion.lib.util.RgbTextUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class RegSuccessCore {
    private RegSuccessCore() {
    }

    public static void register(String playerName) {
        LoginExpansionConstants.REG_PLAYER_LIST.put(playerName, System.currentTimeMillis());
        String registerLeftMsg = BaseConstants.LANG_CONFIG.getString("registerLeftMsg", "").replace("${player}", playerName);
        String registerMoneyMsg = BaseConstants.LANG_CONFIG.getString("registerMoneyMsg");
        String registerNoMoneyMsg = BaseConstants.LANG_CONFIG.getString("registerNoMoneyMsg");
        Optional<Player> rdgPlayerOpt = BaseUtil.getOnlinePlayer(playerName);
        if (rdgPlayerOpt.isPresent()) {
            Player player = rdgPlayerOpt.get();
            registerLeftMsg = BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, registerLeftMsg));
            registerMoneyMsg = BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, registerMoneyMsg));
            registerNoMoneyMsg = BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, registerNoMoneyMsg));
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            String onlinePlayerName = onlinePlayer.getName();
            if (onlinePlayerName.equals(playerName)) continue;
            String type = registerMoneyMsg;
            List<String> playerList = LoginExpansionConstants.PLAYER_WELCOME_NUMBER.get(onlinePlayer.getUniqueId());
            if (CollUtil.isNotEmpty(playerList) && playerList.size() >= BaseConstants.CONFIG.getInt("moneyNumber", 3)) {
                type = registerNoMoneyMsg;
            }
            RgbTextUtil rgbTextUtil = RgbTextUtil.getInstance().init(registerLeftMsg);
            rgbTextUtil.addExtra(RgbTextUtil.getInstance().init(type).addClickCommand("/le welcome " + playerName + " " + onlinePlayerName).build());
            rgbTextUtil.send((CommandSender)onlinePlayer);
        }
        String command = BaseConstants.CONFIG.getString("command");
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncDispatchCommand(command);
        }
    }
}

