/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.lib.command;

import cn.handyplus.login.expansion.lib.command.HandySubCommandParam;
import cn.handyplus.login.expansion.lib.command.IHandyCommandEvent;
import cn.handyplus.login.expansion.lib.core.CollUtil;
import cn.handyplus.login.expansion.lib.core.LockUtil;
import cn.handyplus.login.expansion.lib.core.StrUtil;
import cn.handyplus.login.expansion.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.login.expansion.lib.util.MessageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class HandyCommandFactory {
    private static final HandyCommandFactory INSTANCE = new HandyCommandFactory();
    private static final Map<String, IHandyCommandEvent> HANDY_COMMAND_EVENT_MAP = new HashMap<String, IHandyCommandEvent>();
    private static Map<String, Map<String, HandySubCommandParam>> SUB_COMMAND_MAP = new HashMap<String, Map<String, HandySubCommandParam>>();

    private HandyCommandFactory() {
    }

    protected static HandyCommandFactory getInstance() {
        return INSTANCE;
    }

    protected void init(List<IHandyCommandEvent> handyCommandEvents) {
        if (CollUtil.isEmpty(handyCommandEvents)) {
            return;
        }
        for (IHandyCommandEvent handyCommandEvent : handyCommandEvents) {
            HANDY_COMMAND_EVENT_MAP.put(handyCommandEvent.command().toLowerCase(), handyCommandEvent);
        }
    }

    protected void initSubCommand(Map<String, Map<String, HandySubCommandParam>> subCommandMap) {
        SUB_COMMAND_MAP = subCommandMap;
    }

    protected boolean onSubCommand(String command, CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        Map<String, HandySubCommandParam> subCommandParamMap = SUB_COMMAND_MAP.get(command.toLowerCase());
        if (subCommandParamMap == null) {
            return false;
        }
        HandySubCommandParam param = subCommandParamMap.get(args[0].toLowerCase());
        if (param == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(param.getPermission()) && !sender.hasPermission(param.getPermission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", param.getPermission()));
            return true;
        }
        if (param.isAsync()) {
            this.onAsyncSubCommandExecution(param, sender, cmd, label, args);
            return true;
        }
        this.onSubCommandExecution(param, sender, cmd, label, args);
        return true;
    }

    protected boolean onCommand(CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        IHandyCommandEvent handyCommandEvent = HANDY_COMMAND_EVENT_MAP.get(args[0].toLowerCase());
        if (handyCommandEvent == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(handyCommandEvent.permission()) && !sender.hasPermission(handyCommandEvent.permission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", handyCommandEvent.permission()));
            return true;
        }
        if (handyCommandEvent.isAsync()) {
            this.onAsyncCommand(handyCommandEvent, sender, cmd, label, args);
            return true;
        }
        this.onCommandExecution(handyCommandEvent, sender, cmd, label, args);
        return true;
    }

    private void onAsyncSubCommandExecution(HandySubCommandParam param, CommandSender sender, Command cmd, String label, String[] args) {
        HandySchedulerUtil.runTaskAsynchronously(() -> this.onSubCommandExecution(param, sender, cmd, label, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubCommandExecution(HandySubCommandParam param, CommandSender sender, Command cmd, String label, String[] args) {
        String name = sender.getName();
        try {
            LockUtil.reentrantLock(name);
            param.getMethod().invoke(param.getAClass().newInstance(), sender, cmd, label, args);
        }
        catch (RuntimeException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        finally {
            LockUtil.unReentrantLock(name);
        }
    }

    private void onAsyncCommand(IHandyCommandEvent handyCommandEvent, CommandSender sender, Command cmd, String label, String[] args) {
        HandySchedulerUtil.runTaskAsynchronously(() -> this.onCommandExecution(handyCommandEvent, sender, cmd, label, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCommandExecution(IHandyCommandEvent handyCommandEvent, CommandSender sender, Command cmd, String label, String[] args) {
        String name = sender.getName();
        try {
            LockUtil.reentrantLock(name);
            handyCommandEvent.onCommand(sender, cmd, label, args);
        }
        catch (RuntimeException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        finally {
            LockUtil.unReentrantLock(name);
        }
    }
}

