/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.lib.db;

import cn.handyplus.login.expansion.lib.annotation.TableField;
import cn.handyplus.login.expansion.lib.annotation.TableName;
import cn.handyplus.login.expansion.lib.core.CollUtil;
import cn.handyplus.login.expansion.lib.core.StrUtil;
import cn.handyplus.login.expansion.lib.db.Compare;
import cn.handyplus.login.expansion.lib.db.DbColumnUtil;
import cn.handyplus.login.expansion.lib.db.DbExecution;
import cn.handyplus.login.expansion.lib.db.DbFunction;
import cn.handyplus.login.expansion.lib.db.DbSql;
import cn.handyplus.login.expansion.lib.db.FieldInfoParam;
import cn.handyplus.login.expansion.lib.db.TableInfoParam;
import cn.handyplus.login.expansion.lib.db.UpdateCondition;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import lombok.Generated;

public class Db<T> {
    private final Class<T> clazz;
    private DbSql dbSql;

    public Db(Class<T> clazz) {
        this.clazz = clazz;
        this.init();
    }

    public static <T> Db<T> use(Class<T> clazz) {
        return new Db<T>(clazz);
    }

    @SafeVarargs
    public final <R> void select(DbFunction<R, ?> ... fn) {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (DbFunction<R, ?> rDbFunction : fn) {
            fieldList.add(DbColumnUtil.getFieldName(rDbFunction));
        }
        this.dbSql.setField(CollUtil.listToStr(fieldList));
        this.dbSql.getFieldInfoMap().entrySet().removeIf(entry -> !fieldList.contains(entry.getKey()));
    }

    public final <R> void select(String ... fields) {
        ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields));
        this.dbSql.setField(CollUtil.listToStr(fieldList));
        this.dbSql.getFieldInfoMap().entrySet().removeIf(entry -> !fieldList.contains(entry.getKey()));
    }

    public Compare<T> where() {
        return new Compare(this.dbSql);
    }

    public UpdateCondition<T> update() {
        return new UpdateCondition(this.dbSql);
    }

    public DbExecution<T> execution() {
        return new DbExecution<T>(this.dbSql, this.clazz);
    }

    public void createTable() {
        new DbExecution<T>(this.dbSql, this.clazz, false).create();
    }

    public DbExecution<T> execution(String storageMethod) {
        return new DbExecution<T>(this.dbSql, this.clazz, storageMethod);
    }

    public DbExecution<T> execution(Connection connection) {
        return new DbExecution<T>(this.dbSql, this.clazz, connection);
    }

    private void init() {
        TableName tableName = this.clazz.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new RuntimeException("tableName \u4e3a\u7a7a");
        }
        TableInfoParam tableInfoParam = TableInfoParam.builder().tableName(tableName.value()).tableComment(tableName.comment()).build();
        Field[] fields = this.clazz.getDeclaredFields();
        ArrayList<String> fieldList = new ArrayList<String>();
        LinkedHashMap<String, FieldInfoParam> fieldInfoMap = new LinkedHashMap<String, FieldInfoParam>();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField == null || !StrUtil.isNotEmpty(tableField.value())) continue;
            fieldList.add("`" + tableField.value() + "`");
            FieldInfoParam build = FieldInfoParam.builder().fieldName(tableField.value()).fieldRealName(field.getName()).fieldType(field.getGenericType().getTypeName()).fieldComment(tableField.comment()).fieldNotNull(tableField.notNull()).fieldDefault(tableField.fieldDefault()).fieldIndex(i + 1).fieldLength(tableField.length()).indexEnum(tableField.indexEnum()).build();
            fieldInfoMap.put(tableField.value(), build);
        }
        if (CollUtil.isEmpty(fieldList)) {
            throw new RuntimeException("fieldList \u4e3a\u7a7a");
        }
        this.dbSql = DbSql.builder().tableName("`" + tableName.value() + "`").tableInfoParam(tableInfoParam).field(CollUtil.listToStr(fieldList)).fieldInfoMap(fieldInfoMap).where(" where 1 = 1").updatefieldList(new ArrayList<String>()).updateFieldMap(new LinkedHashMap<Integer, Object>()).build();
    }

    @Generated
    public DbSql getDbSql() {
        return this.dbSql;
    }
}

