/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.lib.util;

import cn.handyplus.login.expansion.lib.InitApi;
import cn.handyplus.login.expansion.lib.constants.BaseConstants;
import cn.handyplus.login.expansion.lib.constants.VersionCheckEnum;
import cn.handyplus.login.expansion.lib.core.JsonUtil;
import cn.handyplus.login.expansion.lib.core.StrUtil;
import cn.handyplus.login.expansion.lib.expand.TexturesParam;
import cn.handyplus.login.expansion.lib.util.BaseUtil;
import cn.handyplus.login.expansion.lib.util.LegacyUtil;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public final class ItemMetaUtil {
    private ItemMetaUtil() {
    }

    public static void setUnbreakable(ItemMeta itemMeta) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.setUnbreakable(true);
    }

    public static void setEnchant(ItemMeta itemMeta) {
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_20_5.getVersionId()) {
            itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        } else {
            itemMeta.addEnchant(LegacyUtil.getDurability(), 1, true);
            ItemMetaUtil.hideEnchant(itemMeta);
        }
    }

    public static void hideEnchant(ItemMeta itemMeta) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_7.getVersionId()) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
    }

    public static void hideAttributes(ItemMeta itemMeta) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            itemMeta.setAttributeModifiers((Multimap)MultimapBuilder.hashKeys().hashSetValues().build());
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_7.getVersionId()) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_19_3.getVersionId()) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
    }

    public static void setCustomModelData(ItemMeta itemMeta, int id) {
        if (itemMeta == null || BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || id == 0) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(id));
    }

    public static void setTooltipStyle(ItemMeta itemMeta, String tooltipStyle) {
        if (itemMeta == null || BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21_2.getVersionId() || StrUtil.isEmpty(tooltipStyle)) {
            return;
        }
        itemMeta.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
    }

    public static void setItemModel(ItemMeta itemMeta, String itemModel) {
        if (itemMeta == null || BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21_2.getVersionId() || StrUtil.isEmpty(itemModel)) {
            return;
        }
        itemMeta.setItemModel(NamespacedKey.fromString((String)itemModel));
    }

    public static void setPersistentData(ItemMeta itemMeta, String customData, String key) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || itemMeta == null || StrUtil.isEmpty(customData)) {
            return;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        String namespacedKeyStr = "handy_data";
        if (StrUtil.isNotEmpty(key)) {
            namespacedKeyStr = namespacedKeyStr + "_" + key;
        }
        dataContainer.set(new NamespacedKey((Plugin)InitApi.PLUGIN, namespacedKeyStr), PersistentDataType.STRING, (Object)customData);
    }

    public static Optional<String> getPersistentData(ItemMeta itemMeta, String key) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || itemMeta == null) {
            return Optional.empty();
        }
        String namespacedKeyStr = "handy_data";
        if (StrUtil.isNotEmpty(key)) {
            namespacedKeyStr = namespacedKeyStr + "_" + key;
        }
        String persistentData = (String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)InitApi.PLUGIN, namespacedKeyStr), PersistentDataType.STRING);
        return Optional.ofNullable(persistentData);
    }

    public static void removePersistentData(ItemMeta itemMeta, String key) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || itemMeta == null) {
            return;
        }
        String namespacedKeyStr = "handy_data";
        if (StrUtil.isNotEmpty(key)) {
            namespacedKeyStr = namespacedKeyStr + "_" + key;
        }
        itemMeta.getPersistentDataContainer().remove(new NamespacedKey((Plugin)InitApi.PLUGIN, namespacedKeyStr));
    }

    public static void setOwner(SkullMeta itemMeta, String playerName) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_12.getVersionId()) {
            itemMeta.setOwner(playerName);
            return;
        }
        itemMeta.setOwningPlayer(BaseUtil.getOfflinePlayer(playerName));
    }

    public static void setSkull(SkullMeta itemMeta, String base64) {
        if (itemMeta == null || StrUtil.isEmpty(base64)) {
            return;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_18.getVersionId()) {
            ItemMetaUtil.setTexture((ItemMeta)itemMeta, base64);
            return;
        }
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        PlayerTextures textures = profile.getTextures();
        byte[] decode = Base64.getDecoder().decode(base64);
        String decodedString = new String(decode, StandardCharsets.UTF_8);
        TexturesParam texturesParam = JsonUtil.toBean(decodedString, TexturesParam.class);
        textures.setSkin(new URL(texturesParam.getUrl()));
        profile.setTextures(textures);
        itemMeta.setOwnerProfile(profile);
    }

    public static void setTrim(ArmorMeta armorMeta, String materialKey, String patternKey) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_19_4.getVersionId()) {
            return;
        }
        ItemMetaUtil.setTrim(armorMeta, ItemMetaUtil.getTrimMaterial(materialKey), ItemMetaUtil.getTrimPattern(patternKey));
    }

    public static void setTrim(ArmorMeta armorMeta, TrimMaterial trimMaterial, TrimPattern trimPattern) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_19_4.getVersionId()) {
            return;
        }
        armorMeta.setTrim(new ArmorTrim(trimMaterial, trimPattern));
    }

    private static TrimMaterial getTrimMaterial(String materialKey) {
        TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.minecraft((String)materialKey));
        if (trimMaterial == null) {
            throw new RuntimeException("trim material type error:" + materialKey);
        }
        return trimMaterial;
    }

    private static TrimPattern getTrimPattern(String patternKey) {
        TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.minecraft((String)patternKey));
        if (trimPattern == null) {
            throw new RuntimeException("trim pattern type error:" + patternKey);
        }
        return trimPattern;
    }

    private static void setTexture(ItemMeta itemMeta, String url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), UUID.randomUUID() + "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", url));
        Field profileField = itemMeta.getClass().getDeclaredField("profile");
        profileField.setAccessible(true);
        profileField.set(itemMeta, profile);
    }
}

