/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.login.expansion.lib.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class ProbabilityUtil {
    private final Random random = new Random();
    private final List<Integer> probabilityNumList = new ArrayList<Integer>();

    private ProbabilityUtil() {
    }

    public static ProbabilityUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean pickIndex(double num) {
        if (num == 0.0) {
            return false;
        }
        BigDecimal rate = BigDecimal.ONE.divide(new BigDecimal(num + ""), RoundingMode.UP);
        return this.pickIndex(1, rate.intValue());
    }

    public boolean pickIndex(int num, int maxNum) {
        int[] nums;
        if (num >= maxNum) {
            num = maxNum;
        }
        return this.randomIndex(nums = new int[]{num, maxNum - num}) == 0;
    }

    public synchronized boolean pickSyncIndex(double num) {
        return this.pickIndex(num);
    }

    public synchronized boolean pickSyncIndex(int num, int maxNum) {
        return this.pickIndex(num, maxNum);
    }

    private int randomIndex(int[] nums) {
        this.probabilityNumList.clear();
        int tot = 0;
        for (int num : nums) {
            this.probabilityNumList.add(tot += num);
        }
        int randomNum = this.random.nextInt(tot);
        int hi = this.probabilityNumList.size() - 1;
        int lo = 0;
        while (lo != hi) {
            int mid = (lo + hi) / 2;
            if (randomNum >= this.probabilityNumList.get(mid)) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return lo;
    }

    private static class SingletonHolder {
        private static final ProbabilityUtil INSTANCE = new ProbabilityUtil();

        private SingletonHolder() {
        }
    }
}

