/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.staffhelp;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class StaffHelp
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private List<Report> reports = new ArrayList<Report>();
    private List<Suggestion> suggestions = new ArrayList<Suggestion>();
    private Map<UUID, Long> reportCooldowns = new HashMap<UUID, Long>();
    private Map<UUID, Long> suggestionCooldowns = new HashMap<UUID, Long>();
    private Map<UUID, List<String>> pendingNotifications = new HashMap<UUID, List<String>>();
    private Set<String> activeSessions = new HashSet<String>();
    private File reportsFile;
    private File suggestionsFile;
    private HttpServer webServer;
    private Gson gson = new Gson();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getCommand("report").setExecutor((CommandExecutor)new ReportCommand());
        this.getCommand("readreports").setExecutor((CommandExecutor)new ReadReportsCommand());
        this.getCommand("suggest").setExecutor((CommandExecutor)new SuggestionCommand());
        this.getCommand("readsuggestions").setExecutor((CommandExecutor)new ReadSuggestionsCommand());
        this.getCommand("staffhelp").setExecutor((CommandExecutor)new MainCommand());
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.reportsFile = new File(this.getDataFolder(), "reports.yml");
        this.suggestionsFile = new File(this.getDataFolder(), "suggestions.yml");
        this.loadData();
        if (this.config.getBoolean("web-interface.enabled", true)) {
            this.startWebServer();
        }
        this.getLogger().info("StaffHelp Enhanced v2.0.0 has been enabled!");
        if (this.webServer != null) {
            this.getLogger().info("Web interface available at: http://localhost:" + this.config.getInt("web-interface.port", 9090));
        }
    }

    public void onDisable() {
        this.saveData();
        if (this.webServer != null) {
            this.webServer.stop(0);
        }
        this.getLogger().info("StaffHelp has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.pendingNotifications.containsKey(playerId)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                for (String notification : this.pendingNotifications.get(playerId)) {
                    player.sendMessage(this.colorize(notification));
                }
                this.pendingNotifications.remove(playerId);
                this.saveData();
            }, 20L);
        }
    }

    private void startWebServer() {
        try {
            int port = this.config.getInt("web-interface.port", 9090);
            this.webServer = HttpServer.create(new InetSocketAddress(port), 0);
            this.webServer.createContext("/", new LoginPageHandler());
            this.webServer.createContext("/login", new LoginHandler());
            this.webServer.createContext("/dashboard", new DashboardHandler());
            this.webServer.createContext("/api/reports", new ReportsAPIHandler());
            this.webServer.createContext("/api/suggestions", new SuggestionsAPIHandler());
            this.webServer.createContext("/api/action", new ActionAPIHandler());
            this.webServer.createContext("/api/theme", new ThemeAPIHandler());
            this.webServer.createContext("/logout", new LogoutHandler());
            this.webServer.start();
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to start web server: " + e.getMessage());
        }
    }

    private boolean isAuthenticated(HttpExchange exchange) {
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        if (cookies == null) {
            return false;
        }
        for (String cookie : cookies.split(";")) {
            String[] parts = cookie.trim().split("=");
            if (parts.length != 2 || !"staffhelp_session".equals(parts[0])) continue;
            return this.activeSessions.contains(parts[1]);
        }
        return false;
    }

    private String generateSessionId() {
        return UUID.randomUUID().toString();
    }

    private Map<String, String> parseFormData(String formData) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        if (formData == null || formData.isEmpty()) {
            return result;
        }
        for (String pair : pairs = formData.split("&")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) continue;
            try {
                String key = URLDecoder.decode(keyValue[0], StandardCharsets.UTF_8.name());
                String value = URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8.name());
                result.put(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void handleReportAction(int reportId, String action, JsonObject request) {
        Report report = this.reports.stream().filter(r -> r.id == reportId).findFirst().orElse(null);
        if (report == null) {
            return;
        }
        report.resolved = true;
        report.action = action;
        if (!"no_action".equals(action)) {
            String player = request.has("target") && "reporter".equals(request.get("target").getAsString()) ? report.reporter : report.reported;
            String reason = request.has("reason") ? request.get("reason").getAsString() : "Staff action";
            String time = request.has("time") ? request.get("time").getAsString() : "permanent";
            String command = this.config.getString("moderation-commands." + action, "").replace("%player%", player).replace("%reason%", reason).replace("%time%", time);
            if (!command.isEmpty()) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    this.getLogger().info("Executed moderation command: " + command);
                });
            }
        }
        this.saveData();
    }

    private void handleSuggestionStatus(int suggestionId, String status) {
        Suggestion suggestion = this.suggestions.stream().filter(s -> s.id == suggestionId).findFirst().orElse(null);
        if (suggestion == null) {
            return;
        }
        SuggestionStatus oldStatus = suggestion.status;
        suggestion.status = SuggestionStatus.valueOf(status.toUpperCase());
        if (this.config.getBoolean("notify-suggestion-status", true) && oldStatus != suggestion.status) {
            UUID playerId = suggestion.playerUUID;
            String message = "";
            switch (suggestion.status.ordinal()) {
                case 1: {
                    message = this.config.getString("messages.suggestion-accepted");
                    break;
                }
                case 2: {
                    message = this.config.getString("messages.suggestion-declined");
                    break;
                }
                case 3: {
                    message = this.config.getString("messages.suggestion-completed");
                }
            }
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && player.isOnline()) {
                player.sendMessage(this.colorize(message));
            } else if (!message.isEmpty()) {
                this.pendingNotifications.computeIfAbsent(playerId, k -> new ArrayList()).add(message);
            }
        }
        this.saveData();
    }

    private String generateLoginHTML(String theme) {
        boolean isDark = "dark".equals(theme);
        String bgColor = isDark ? "#1a1a1a" : "#ffffff";
        String textColor = isDark ? "#ffffff" : "#000000";
        String cardBg = isDark ? "#2d2d2d" : "#f8f9fa";
        String inputBg = isDark ? "#3d3d3d" : "#ffffff";
        String borderColor = isDark ? "#444444" : "#dee2e6";
        return "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>StaffHelp - Login</title>\n    <style>\n        * { margin: 0; padding: 0; box-sizing: border-box; }\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: " + bgColor + ";\n            color: " + textColor + ";\n            min-height: 100vh;\n            display: flex;\n            align-items: center;\n            justify-content: center;\n        }\n        .login-container {\n            background: " + cardBg + ";\n            padding: 2rem;\n            border-radius: 15px;\n            box-shadow: 0 10px 30px rgba(0,0,0,0.2);\n            width: 100%;\n            max-width: 400px;\n            border: 1px solid " + borderColor + ";\n        }\n        .logo {\n            text-align: center;\n            margin-bottom: 2rem;\n        }\n        .logo h1 {\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            -webkit-background-clip: text;\n            -webkit-text-fill-color: transparent;\n            background-clip: text;\n            font-size: 2rem;\n            margin-bottom: 0.5rem;\n        }\n        .logo p { color: #888; }\n        .form-group {\n            margin-bottom: 1.5rem;\n        }\n        .form-group label {\n            display: block;\n            margin-bottom: 0.5rem;\n            font-weight: 600;\n        }\n        .form-group input {\n            width: 100%;\n            padding: 0.75rem;\n            border: 2px solid " + borderColor + ";\n            border-radius: 8px;\n            background: " + inputBg + ";\n            color: " + textColor + ";\n            font-size: 1rem;\n            transition: border-color 0.3s ease;\n        }\n        .form-group input:focus {\n            outline: none;\n            border-color: #667eea;\n        }\n        .login-btn {\n            width: 100%;\n            padding: 0.75rem;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            border: none;\n            border-radius: 8px;\n            color: white;\n            font-size: 1rem;\n            font-weight: 600;\n            cursor: pointer;\n            transition: transform 0.3s ease;\n        }\n        .login-btn:hover {\n            transform: translateY(-2px);\n        }\n        .error {\n            background: #f8d7da;\n            color: #721c24;\n            padding: 0.75rem;\n            border-radius: 8px;\n            margin-bottom: 1rem;\n            text-align: center;\n        }\n        .theme-toggle {\n            position: absolute;\n            top: 20px;\n            right: 20px;\n            background: " + cardBg + ";\n            border: 1px solid " + borderColor + ";\n            color: " + textColor + ";\n            padding: 0.5rem 1rem;\n            border-radius: 20px;\n            cursor: pointer;\n            transition: all 0.3s ease;\n        }\n        .theme-toggle:hover {\n            background: #667eea;\n            color: white;\n        }\n    </style>\n</head>\n<body>\n    <button class=\"theme-toggle\" onclick=\"toggleTheme()\">\n        " + (isDark ? "\u2600\ufe0f Light" : "\ud83c\udf19 Dark") + "\n    </button>\n\n    <div class=\"login-container\">\n        <div class=\"logo\">\n            <h1>\ud83d\udee1\ufe0f StaffHelp</h1>\n            <p>Staff Management Dashboard</p>\n        </div>\n\n        <script>\n            const urlParams = new URLSearchParams(window.location.search);\n            if (urlParams.get('error') === 'invalid') {\n                document.write('<div class=\"error\">\u274c Invalid username or password!</div>');\n            }\n        </script>\n\n        <form method=\"POST\" action=\"/login\">\n            <div class=\"form-group\">\n                <label for=\"username\">\ud83d\udc64 Username:</label>\n                <input type=\"text\" id=\"username\" name=\"username\" required autocomplete=\"username\">\n            </div>\n\n            <div class=\"form-group\">\n                <label for=\"password\">\ud83d\udd12 Password:</label>\n                <input type=\"password\" id=\"password\" name=\"password\" required autocomplete=\"current-password\">\n            </div>\n\n            <button type=\"submit\" class=\"login-btn\">\ud83d\ude80 Login to Dashboard</button>\n        </form>\n    </div>\n\n    <script>\n        function toggleTheme() {\n            fetch('/api/theme', {\n                method: 'POST',\n                headers: { 'Content-Type': 'application/json' },\n                body: JSON.stringify({ theme: '" + (isDark ? "light" : "dark") + "' })\n            }).then(() => location.reload());\n        }\n        \n        // Auto-focus username field\n        document.getElementById('username').focus();\n    </script>\n</body>\n</html>";
    }

    private String generateDashboardHTML(String theme) {
        boolean isDark = "dark".equals(theme);
        String bgColor = isDark ? "#1a1a1a" : "#ffffff";
        String textColor = isDark ? "#ffffff" : "#000000";
        String cardBg = isDark ? "#2d2d2d" : "#f8f9fa";
        String borderColor = isDark ? "#444444" : "#dee2e6";
        String inputBg = isDark ? "#3d3d3d" : "#ffffff";
        return "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>StaffHelp Dashboard</title>\n    <style>\n        * { margin: 0; padding: 0; box-sizing: border-box; }\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: " + bgColor + ";\n            color: " + textColor + ";\n            line-height: 1.6;\n        }\n        .header {\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            padding: 1rem 2rem;\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            box-shadow: 0 2px 10px rgba(0,0,0,0.1);\n        }\n        .header h1 { color: white; font-size: 1.8rem; }\n        .header-controls {\n            display: flex;\n            gap: 1rem;\n            align-items: center;\n        }\n        .theme-toggle, .logout-btn {\n            background: rgba(255,255,255,0.2);\n            border: none;\n            color: white;\n            padding: 0.5rem 1rem;\n            border-radius: 20px;\n            cursor: pointer;\n            transition: all 0.3s ease;\n            text-decoration: none;\n            display: inline-block;\n        }\n        .theme-toggle:hover, .logout-btn:hover { background: rgba(255,255,255,0.3); }\n        .container {\n            max-width: 1200px;\n            margin: 0 auto;\n            padding: 2rem;\n        }\n        .stats {\n            display: grid;\n            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));\n            gap: 1rem;\n            margin-bottom: 2rem;\n        }\n        .stat-card {\n            background: " + cardBg + ";\n            padding: 1.5rem;\n            border-radius: 10px;\n            border: 1px solid " + borderColor + ";\n            text-align: center;\n            transition: transform 0.3s ease, box-shadow 0.3s ease;\n        }\n        .stat-card:hover {\n            transform: translateY(-5px);\n            box-shadow: 0 5px 20px rgba(0,0,0,0.1);\n        }\n        .stat-number { font-size: 2rem; font-weight: bold; color: #667eea; }\n        .tabs {\n            display: flex;\n            margin-bottom: 1rem;\n            border-bottom: 2px solid " + borderColor + ";\n        }\n        .tab {\n            padding: 1rem 2rem;\n            cursor: pointer;\n            border: none;\n            background: none;\n            color: " + textColor + ";\n            font-size: 1rem;\n            transition: all 0.3s ease;\n        }\n        .tab.active {\n            border-bottom: 3px solid #667eea;\n            color: #667eea;\n        }\n        .content { background: " + cardBg + "; border-radius: 10px; padding: 1rem; }\n        .item {\n            padding: 1rem;\n            margin: 0.5rem 0;\n            background: " + bgColor + ";\n            border-radius: 8px;\n            border: 1px solid " + borderColor + ";\n            transition: all 0.3s ease;\n        }\n        .item:hover { box-shadow: 0 3px 15px rgba(0,0,0,0.1); }\n        .item-header {\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            margin-bottom: 0.5rem;\n        }\n        .item-id { font-weight: bold; color: #667eea; }\n        .item-date { color: #888; font-size: 0.9rem; }\n        .status {\n            padding: 0.3rem 0.8rem;\n            border-radius: 15px;\n            font-size: 0.8rem;\n            font-weight: bold;\n        }\n        .status.resolved { background: #d4edda; color: #155724; }\n        .status.unresolved { background: #f8d7da; color: #721c24; }\n        .status.pending { background: #fff3cd; color: #856404; }\n        .status.accepted { background: #d1ecf1; color: #0c5460; }\n        .status.declined { background: #f8d7da; color: #721c24; }\n        .status.completed { background: #d4edda; color: #155724; }\n        .actions {\n            display: flex;\n            gap: 0.5rem;\n            margin-top: 1rem;\n            flex-wrap: wrap;\n        }\n        .btn {\n            padding: 0.5rem 1rem;\n            border: none;\n            border-radius: 5px;\n            cursor: pointer;\n            font-size: 0.9rem;\n            transition: all 0.3s ease;\n        }\n        .btn-primary { background: #007bff; color: white; }\n        .btn-success { background: #28a745; color: white; }\n        .btn-danger { background: #dc3545; color: white; }\n        .btn-warning { background: #ffc107; color: black; }\n        .btn-secondary { background: #6c757d; color: white; }\n        .btn:hover { opacity: 0.8; transform: translateY(-2px); }\n        .modal {\n            display: none;\n            position: fixed;\n            z-index: 1000;\n            left: 0;\n            top: 0;\n            width: 100%;\n            height: 100%;\n            background: rgba(0,0,0,0.5);\n        }\n        .modal-content {\n            background: " + cardBg + ";\n            margin: 5% auto;\n            padding: 2rem;\n            border-radius: 10px;\n            width: 90%;\n            max-width: 500px;\n            border: 1px solid " + borderColor + ";\n        }\n        .form-group {\n            margin-bottom: 1rem;\n        }\n        .form-group label {\n            display: block;\n            margin-bottom: 0.5rem;\n            font-weight: bold;\n        }\n        .form-group input, .form-group select, .form-group textarea {\n            width: 100%;\n            padding: 0.5rem;\n            border: 1px solid " + borderColor + ";\n            border-radius: 5px;\n            background: " + inputBg + ";\n            color: " + textColor + ";\n        }\n        .hidden { display: none; }\n        .loading {\n            text-align: center;\n            padding: 2rem;\n            color: #888;\n        }\n        .empty-state {\n            text-align: center;\n            padding: 3rem;\n            color: #888;\n        }\n        .close {\n            float: right;\n            font-size: 1.5rem;\n            cursor: pointer;\n            color: #999;\n        }\n        .close:hover { color: " + textColor + "; }\n    </style>\n</head>\n<body>\n    <div class=\"header\">\n        <h1>\ud83d\udee1\ufe0f StaffHelp Dashboard</h1>\n        <div class=\"header-controls\">\n            <button class=\"theme-toggle\" onclick=\"toggleTheme()\">\n                " + (isDark ? "\u2600\ufe0f Light" : "\ud83c\udf19 Dark") + "\n            </button>\n            <a href=\"/logout\" class=\"logout-btn\">\ud83d\udeaa Logout</a>\n        </div>\n    </div>\n\n    <div class=\"container\">\n        <div class=\"stats\">\n            <div class=\"stat-card\">\n                <div class=\"stat-number\" id=\"totalReports\">\ud83d\udcca</div>\n                <div>Total Reports</div>\n            </div>\n            <div class=\"stat-card\">\n                <div class=\"stat-number\" id=\"unresolvedReports\">\u26a0\ufe0f</div>\n                <div>Unresolved Reports</div>\n            </div>\n            <div class=\"stat-card\">\n                <div class=\"stat-number\" id=\"totalSuggestions\">\ud83d\udca1</div>\n                <div>Total Suggestions</div>\n            </div>\n            <div class=\"stat-card\">\n                <div class=\"stat-number\" id=\"pendingSuggestions\">\u23f3</div>\n                <div>Pending Suggestions</div>\n            </div>\n        </div>\n\n        <div class=\"tabs\">\n            <button class=\"tab active\" onclick=\"showTab('reports')\">\ud83d\udccb Reports</button>\n            <button class=\"tab\" onclick=\"showTab('suggestions')\">\ud83d\udca1 Suggestions</button>\n            <button class=\"tab\" onclick=\"showTab('logs')\">\ud83d\udcdd Action Logs</button>\n        </div>\n\n        <div id=\"reports\" class=\"content\">\n            <div class=\"loading\">\ud83d\udd04 Loading reports...</div>\n            <div id=\"reportsList\"></div>\n        </div>\n\n        <div id=\"suggestions\" class=\"content hidden\">\n            <div class=\"loading\">\ud83d\udd04 Loading suggestions...</div>\n            <div id=\"suggestionsList\"></div>\n        </div>\n\n        <div id=\"logs\" class=\"content hidden\">\n            <div class=\"empty-state\">\n                <h3>\ud83d\udcdd Action Logs</h3>\n                <p>Resolved reports and completed suggestions will appear here.</p>\n                <div id=\"logsList\"></div>\n            </div>\n        </div>\n    </div>\n\n    <!-- Action Modal -->\n    <div id=\"actionModal\" class=\"modal\">\n        <div class=\"modal-content\">\n            <span class=\"close\" onclick=\"closeModal()\">&times;</span>\n            <h3 id=\"modalTitle\">Take Moderation Action</h3>\n            <form id=\"actionForm\">\n                <div class=\"form-group\">\n                    <label for=\"actionType\">\ud83d\udd28 Action Type:</label>\n                    <select id=\"actionType\" name=\"actionType\" required>\n                        <option value=\"no_action\">No Action</option>\n                        <option value=\"warn\">\u26a0\ufe0f Warn</option>\n                        <option value=\"kick\">\ud83d\udc62 Kick</option>\n                        <option value=\"tempban\">\u23f0 Temporary Ban</option>\n                        <option value=\"ban\">\ud83d\udd28 Permanent Ban</option>\n                        <option value=\"ipban\">\ud83d\udeab IP Ban</option>\n                        <option value=\"mute\">\ud83d\udd07 Mute</option>\n                    </select>\n                </div>\n                <div class=\"form-group\">\n                    <label for=\"actionTarget\">\ud83c\udfaf Target Player:</label>\n                    <select id=\"actionTarget\" name=\"actionTarget\">\n                        <option value=\"reported\">Reported Player</option>\n                        <option value=\"reporter\">Reporter (Fake Report)</option>\n                    </select>\n                </div>\n                <div class=\"form-group\" id=\"timeGroup\" style=\"display: none;\">\n                    <label for=\"actionTime\">\u23f1\ufe0f Duration:</label>\n                    <input type=\"text\" id=\"actionTime\" name=\"actionTime\" placeholder=\"e.g., 1h, 30m, 7d, 1w\">\n                    <small>Examples: 30m (30 minutes), 2h (2 hours), 1d (1 day), 1w (1 week)</small>\n                </div>\n                <div class=\"form-group\">\n                    <label for=\"actionReason\">\ud83d\udcdd Reason:</label>\n                    <textarea id=\"actionReason\" name=\"actionReason\" rows=\"3\" placeholder=\"Enter the reason for this action...\"></textarea>\n                </div>\n                <div class=\"actions\">\n                    <button type=\"submit\" class=\"btn btn-primary\">\u2705 Execute Action</button>\n                    <button type=\"button\" class=\"btn btn-secondary\" onclick=\"closeModal()\">\u274c Cancel</button>\n                </div>\n            </form>\n        </div>\n    </div>\n\n    <script>\n        let currentReportId = null;\n        let reportsData = [];\n        let suggestionsData = [];\n        \n        function showTab(tabName) {\n            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));\n            document.querySelectorAll('.content').forEach(c => c.classList.add('hidden'));\n            \n            event.target.classList.add('active');\n            document.getElementById(tabName).classList.remove('hidden');\n            \n            if (tabName === 'reports') {\n                loadReports();\n            } else if (tabName === 'suggestions') {\n                loadSuggestions();\n            } else if (tabName === 'logs') {\n                loadLogs();\n            }\n        }\n        \n        function toggleTheme() {\n            fetch('/api/theme', {\n                method: 'POST',\n                headers: { 'Content-Type': 'application/json' },\n                body: JSON.stringify({ theme: '" + (isDark ? "light" : "dark") + "' })\n            }).then(() => location.reload());\n        }\n        \n        function loadReports() {\n            fetch('/api/reports')\n                .then(response => response.json())\n                .then(data => {\n                    reportsData = data.reports;\n                    updateStats();\n                    displayReports();\n                })\n                .catch(error => {\n                    console.error('Error loading reports:', error);\n                    document.getElementById('reportsList').innerHTML = '<div class=\"empty-state\">\u274c Error loading reports</div>';\n                });\n        }\n        \n        function loadSuggestions() {\n            fetch('/api/suggestions')\n                .then(response => response.json())\n                .then(data => {\n                    suggestionsData = data.suggestions;\n                    updateStats();\n                    displaySuggestions();\n                })\n                .catch(error => {\n                    console.error('Error loading suggestions:', error);\n                    document.getElementById('suggestionsList').innerHTML = '<div class=\"empty-state\">\u274c Error loading suggestions</div>';\n                });\n        }\n        \n        function updateStats() {\n            document.getElementById('totalReports').textContent = reportsData.length;\n            document.getElementById('unresolvedReports').textContent = reportsData.filter(r => !r.resolved).length;\n            document.getElementById('totalSuggestions').textContent = suggestionsData.length;\n            document.getElementById('pendingSuggestions').textContent = suggestionsData.filter(s => s.status === 'PENDING').length;\n        }\n        \n        function displayReports() {\n            const reportsList = document.getElementById('reportsList');\n            \n            if (reportsData.length === 0) {\n                reportsList.innerHTML = '<div class=\"empty-state\">\ud83d\udccb No reports found<br><small>Reports will appear here when players submit them</small></div>';\n                return;\n            }\n            \n            reportsList.innerHTML = '';\n            \n            reportsData.slice().reverse().forEach(report => {\n                const div = document.createElement('div');\n                div.className = 'item';\n                \n                const date = new Date(report.timestamp).toLocaleString();\n                const statusClass = report.resolved ? 'resolved' : 'unresolved';\n                const statusText = report.resolved ? '\u2705 Resolved' : '\u23f3 Unresolved';\n                \n                div.innerHTML = `\n                    <div class=\"item-header\">\n                        <span class=\"item-id\">#${report.id}</span>\n                        <span class=\"status ${statusClass}\">${statusText}</span>\n                        <span class=\"item-date\">${date}</span>\n                    </div>\n                    <div><strong>\ud83d\udc64 Reporter:</strong> ${report.reporter}</div>\n                    <div><strong>\ud83c\udfaf Reported:</strong> ${report.reported}</div>\n                    <div><strong>\ud83d\udcdd Reason:</strong> ${report.reason}</div>\n                    ${report.resolved ? `<div><strong>\u2696\ufe0f Action Taken:</strong> ${report.action}</div>` : ''}\n                    ${!report.resolved ? `\n                        <div class=\"actions\">\n                            <button class=\"btn btn-primary\" onclick=\"takeAction(${report.id})\">\u2696\ufe0f Take Action</button>\n                        </div>\n                    ` : ''}\n                `;\n                reportsList.appendChild(div);\n            });\n        }\n        \n        function displaySuggestions() {\n            const suggestionsList = document.getElementById('suggestionsList');\n            \n            if (suggestionsData.length === 0) {\n                suggestionsList.innerHTML = '<div class=\"empty-state\">\ud83d\udca1 No suggestions found<br><small>Player suggestions will appear here</small></div>';\n                return;\n            }\n            \n            suggestionsList.innerHTML = '';\n            \n            suggestionsData.slice().reverse().forEach(suggestion => {\n                const div = document.createElement('div');\n                div.className = 'item';\n                \n                const date = new Date(suggestion.timestamp).toLocaleString();\n                let statusClass = suggestion.status.toLowerCase();\n                let statusText = {\n                    'PENDING': '\u23f3 Pending',\n                    'ACCEPTED': '\u2705 Accepted',\n                    'DECLINED': '\u274c Declined',\n                    'COMPLETED': '\ud83c\udf89 Completed'\n                }[suggestion.status] || suggestion.status;\n                \n                div.innerHTML = `\n                    <div class=\"item-header\">\n                        <span class=\"item-id\">#${suggestion.id}</span>\n                        <span class=\"status ${statusClass}\">${statusText}</span>\n                        <span class=\"item-date\">${date}</span>\n                    </div>\n                    <div><strong>\ud83d\udc64 Player:</strong> ${suggestion.player}</div>\n                    <div><strong>\ud83d\udca1 Suggestion:</strong> ${suggestion.suggestion}</div>\n                    <div class=\"actions\">\n                        ${suggestion.status === 'PENDING' ? `\n                            <button class=\"btn btn-success\" onclick=\"updateSuggestionStatus(${suggestion.id}, 'ACCEPTED')\">\u2705 Accept</button>\n                            <button class=\"btn btn-danger\" onclick=\"updateSuggestionStatus(${suggestion.id}, 'DECLINED')\">\u274c Decline</button>\n                        ` : suggestion.status === 'ACCEPTED' ? `\n                            <button class=\"btn btn-primary\" onclick=\"updateSuggestionStatus(${suggestion.id}, 'COMPLETED')\">\ud83c\udf89 Mark Complete</button>\n                        ` : ''}\n                    </div>\n                `;\n                suggestionsList.appendChild(div);\n            });\n        }\n        \n        function loadLogs() {\n            const logsList = document.getElementById('logsList');\n            const resolvedReports = reportsData.filter(r => r.resolved);\n            const completedSuggestions = suggestionsData.filter(s => s.status === 'COMPLETED');\n            \n            if (resolvedReports.length === 0 && completedSuggestions.length === 0) {\n                logsList.innerHTML = '<div class=\"empty-state\">\ud83d\udcdd No action logs yet<br><small>Resolved reports and completed suggestions will appear here</small></div>';\n                return;\n            }\n            \n            logsList.innerHTML = '';\n            \n            // Combine and sort by timestamp\n            const allLogs = [];\n            \n            resolvedReports.forEach(report => {\n                allLogs.push({\n                    type: 'report',\n                    id: report.id,\n                    timestamp: report.timestamp,\n                    content: `Report #${report.id}: ${report.reporter} \u2192 ${report.reported} | Action: ${report.action}`\n                });\n            });\n            \n            completedSuggestions.forEach(suggestion => {\n                allLogs.push({\n                    type: 'suggestion',\n                    id: suggestion.id,\n                    timestamp: suggestion.timestamp,\n                    content: `Suggestion #${suggestion.id}: ${suggestion.player} | Status: Completed`\n                });\n            });\n            \n            allLogs.sort((a, b) => b.timestamp - a.timestamp);\n            \n            allLogs.forEach(log => {\n                const div = document.createElement('div');\n                div.className = 'item';\n                div.innerHTML = `\n                    <div class=\"item-header\">\n                        <span class=\"item-id\">${log.type === 'report' ? '\ud83d\udccb' : '\ud83d\udca1'} ${log.content}</span>\n                        <span class=\"item-date\">${new Date(log.timestamp).toLocaleString()}</span>\n                    </div>\n                `;\n                logsList.appendChild(div);\n            });\n        }\n        \n        function takeAction(reportId) {\n            currentReportId = reportId;\n            const modal = document.getElementById('actionModal');\n            modal.style.display = 'block';\n            \n            // Find the report\n            const report = reportsData.find(r => r.id === reportId);\n            if (report) {\n                document.getElementById('modalTitle').textContent = `Take Action - Report #${reportId}`;\n            }\n        }\n        \n        function updateSuggestionStatus(id, status) {\n            fetch('/api/action', {\n                method: 'POST',\n                headers: { 'Content-Type': 'application/json' },\n                body: JSON.stringify({ type: 'suggestion', id: id, status: status })\n            })\n            .then(response => response.json())\n            .then(() => {\n                loadSuggestions();\n            })\n            .catch(error => {\n                console.error('Error updating suggestion:', error);\n                alert('Error updating suggestion status');\n            });\n        }\n        \n        function closeModal() {\n            document.getElementById('actionModal').style.display = 'none';\n            document.getElementById('actionForm').reset();\n            document.getElementById('timeGroup').style.display = 'none';\n        }\n        \n        // Action type change handler\n        document.getElementById('actionType').addEventListener('change', function() {\n            const timeGroup = document.getElementById('timeGroup');\n            if (['tempban', 'mute'].includes(this.value)) {\n                timeGroup.style.display = 'block';\n            } else {\n                timeGroup.style.display = 'none';\n            }\n        });\n        \n        // Action form submission\n        document.getElementById('actionForm').addEventListener('submit', function(e) {\n            e.preventDefault();\n            \n            const formData = new FormData(this);\n            const actionData = {\n                type: 'report',\n                id: currentReportId,\n                action: formData.get('actionType'),\n                target: formData.get('actionTarget'),\n                time: formData.get('actionTime') || '',\n                reason: formData.get('actionReason') || 'No reason provided'\n            };\n            \n            fetch('/api/action', {\n                method: 'POST',\n                headers: { 'Content-Type': 'application/json' },\n                body: JSON.stringify(actionData)\n            })\n            .then(response => response.json())\n            .then(() => {\n                closeModal();\n                loadReports();\n            })\n            .catch(error => {\n                console.error('Error taking action:', error);\n                alert('Error executing action');\n            });\n        });\n        \n        // Close modal when clicking outside\n        window.onclick = function(event) {\n            const modal = document.getElementById('actionModal');\n            if (event.target === modal) {\n                closeModal();\n            }\n        }\n        \n        // Auto-refresh every 30 seconds\n        setInterval(() => {\n            const activeTab = document.querySelector('.tab.active');\n            if (activeTab.textContent.includes('Reports')) {\n                loadReports();\n            } else if (activeTab.textContent.includes('Suggestions')) {\n                loadSuggestions();\n            }\n        }, " + this.config.getInt("web-interface.auto-refresh", 30) * 1000 + ");\n        \n        // Load initial data\n        loadReports();\n        loadSuggestions();\n    </script>\n</body>\n</html>";
    }

    private void loadData() {
        this.loadReports();
        this.loadSuggestions();
        this.loadNotifications();
    }

    private void saveData() {
        this.saveReports();
        this.saveSuggestions();
        this.saveNotifications();
    }

    private void loadReports() {
        if (!this.reportsFile.exists()) {
            return;
        }
        YamlConfiguration reportsConfig = YamlConfiguration.loadConfiguration((File)this.reportsFile);
        this.reports.clear();
        if (reportsConfig.contains("reports")) {
            for (String key : reportsConfig.getConfigurationSection("reports").getKeys(false)) {
                String path = "reports." + key;
                Report report = new Report(this, reportsConfig.getInt(path + ".id"), reportsConfig.getString(path + ".reporter"), UUID.fromString(reportsConfig.getString(path + ".reporterUUID")), reportsConfig.getString(path + ".reported"), reportsConfig.getString(path + ".reportedUUID"), reportsConfig.getString(path + ".reason"), reportsConfig.getLong(path + ".timestamp"), reportsConfig.getBoolean(path + ".resolved"), reportsConfig.getString(path + ".action", "none"));
                this.reports.add(report);
            }
        }
    }

    private void saveReports() {
        try {
            if (!this.reportsFile.exists()) {
                this.reportsFile.createNewFile();
            }
            YamlConfiguration reportsConfig = new YamlConfiguration();
            for (int i = 0; i < this.reports.size(); ++i) {
                Report report = this.reports.get(i);
                String path = "reports." + i;
                reportsConfig.set(path + ".id", (Object)report.id);
                reportsConfig.set(path + ".reporter", (Object)report.reporter);
                reportsConfig.set(path + ".reporterUUID", (Object)report.reporterUUID.toString());
                reportsConfig.set(path + ".reported", (Object)report.reported);
                reportsConfig.set(path + ".reportedUUID", (Object)report.reportedUUID);
                reportsConfig.set(path + ".reason", (Object)report.reason);
                reportsConfig.set(path + ".timestamp", (Object)report.timestamp);
                reportsConfig.set(path + ".resolved", (Object)report.resolved);
                reportsConfig.set(path + ".action", (Object)report.action);
            }
            reportsConfig.save(this.reportsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save reports: " + e.getMessage());
        }
    }

    private void loadSuggestions() {
        if (!this.suggestionsFile.exists()) {
            return;
        }
        YamlConfiguration suggestionsConfig = YamlConfiguration.loadConfiguration((File)this.suggestionsFile);
        this.suggestions.clear();
        if (suggestionsConfig.contains("suggestions")) {
            for (String key : suggestionsConfig.getConfigurationSection("suggestions").getKeys(false)) {
                String path = "suggestions." + key;
                Suggestion suggestion = new Suggestion(this, suggestionsConfig.getInt(path + ".id"), suggestionsConfig.getString(path + ".player"), UUID.fromString(suggestionsConfig.getString(path + ".playerUUID")), suggestionsConfig.getString(path + ".suggestion"), suggestionsConfig.getLong(path + ".timestamp"), SuggestionStatus.valueOf(suggestionsConfig.getString(path + ".status", "PENDING")));
                this.suggestions.add(suggestion);
            }
        }
    }

    private void saveSuggestions() {
        try {
            if (!this.suggestionsFile.exists()) {
                this.suggestionsFile.createNewFile();
            }
            YamlConfiguration suggestionsConfig = new YamlConfiguration();
            for (int i = 0; i < this.suggestions.size(); ++i) {
                Suggestion suggestion = this.suggestions.get(i);
                String path = "suggestions." + i;
                suggestionsConfig.set(path + ".id", (Object)suggestion.id);
                suggestionsConfig.set(path + ".player", (Object)suggestion.player);
                suggestionsConfig.set(path + ".playerUUID", (Object)suggestion.playerUUID.toString());
                suggestionsConfig.set(path + ".suggestion", (Object)suggestion.suggestion);
                suggestionsConfig.set(path + ".timestamp", (Object)suggestion.timestamp);
                suggestionsConfig.set(path + ".status", (Object)suggestion.status.name());
            }
            suggestionsConfig.save(this.suggestionsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save suggestions: " + e.getMessage());
        }
    }

    private void loadNotifications() {
        File notificationsFile = new File(this.getDataFolder(), "notifications.yml");
        if (!notificationsFile.exists()) {
            return;
        }
        YamlConfiguration notificationsConfig = YamlConfiguration.loadConfiguration((File)notificationsFile);
        this.pendingNotifications.clear();
        if (notificationsConfig.contains("notifications")) {
            for (String key : notificationsConfig.getConfigurationSection("notifications").getKeys(false)) {
                UUID playerId = UUID.fromString(key);
                List notifications = notificationsConfig.getStringList("notifications." + key);
                this.pendingNotifications.put(playerId, notifications);
            }
        }
    }

    private void saveNotifications() {
        try {
            File notificationsFile = new File(this.getDataFolder(), "notifications.yml");
            if (!notificationsFile.exists()) {
                notificationsFile.createNewFile();
            }
            YamlConfiguration notificationsConfig = new YamlConfiguration();
            for (Map.Entry<UUID, List<String>> entry : this.pendingNotifications.entrySet()) {
                notificationsConfig.set("notifications." + entry.getKey().toString(), entry.getValue());
            }
            notificationsConfig.save(notificationsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save notifications: " + e.getMessage());
        }
    }

    private void displayReports(CommandSender sender, int page) {
        int reportsPerPage = this.config.getInt("reports-per-page", 10);
        int maxPage = (int)Math.ceil((double)this.reports.size() / (double)reportsPerPage);
        if (page < 1 || page > maxPage) {
            sender.sendMessage(this.colorize(this.config.getString("messages.invalid-page")));
            return;
        }
        sender.sendMessage(this.colorize(this.config.getString("messages.reports-header").replace("%page%", String.valueOf(page)).replace("%maxpage%", String.valueOf(maxPage))));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int startIndex = (page - 1) * reportsPerPage;
        int endIndex = Math.min(this.reports.size(), startIndex + reportsPerPage);
        for (int i = startIndex; i < endIndex; ++i) {
            Report report = this.reports.get(i);
            String date = dateFormat.format(new Date(report.timestamp));
            String status = report.resolved ? this.config.getString("messages.resolved-tag") : this.config.getString("messages.unresolved-tag");
            sender.sendMessage(this.colorize(this.config.getString("messages.report-format").replace("%id%", String.valueOf(report.id)).replace("%reporter%", report.reporter).replace("%reported%", report.reported).replace("%reason%", report.reason).replace("%date%", date).replace("%status%", status)));
        }
        sender.sendMessage(this.colorize(this.config.getString("messages.reports-footer")));
    }

    private void displaySuggestions(CommandSender sender, int page) {
        int suggestionsPerPage = this.config.getInt("suggestions-per-page", 10);
        int maxPage = (int)Math.ceil((double)this.suggestions.size() / (double)suggestionsPerPage);
        if (page < 1 || page > maxPage) {
            sender.sendMessage(this.colorize(this.config.getString("messages.invalid-page")));
            return;
        }
        sender.sendMessage(this.colorize(this.config.getString("messages.suggestions-header").replace("%page%", String.valueOf(page)).replace("%maxpage%", String.valueOf(maxPage))));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int startIndex = (page - 1) * suggestionsPerPage;
        int endIndex = Math.min(this.suggestions.size(), startIndex + suggestionsPerPage);
        for (int i = startIndex; i < endIndex; ++i) {
            Suggestion suggestion = this.suggestions.get(i);
            String date = dateFormat.format(new Date(suggestion.timestamp));
            String status = "";
            switch (suggestion.status.ordinal()) {
                case 0: {
                    status = this.config.getString("messages.pending-tag");
                    break;
                }
                case 1: {
                    status = this.config.getString("messages.accepted-tag");
                    break;
                }
                case 2: {
                    status = this.config.getString("messages.declined-tag");
                    break;
                }
                case 3: {
                    status = this.config.getString("messages.completed-tag");
                }
            }
            sender.sendMessage(this.colorize(this.config.getString("messages.suggestion-format").replace("%id%", String.valueOf(suggestion.id)).replace("%player%", suggestion.player).replace("%suggestion%", suggestion.suggestion).replace("%date%", date).replace("%status%", status)));
        }
        sender.sendMessage(this.colorize(this.config.getString("messages.suggestions-footer")));
    }

    private int getNextReportId() {
        return this.reports.isEmpty() ? 1 : this.reports.stream().mapToInt(r -> r.id).max().orElse(0) + 1;
    }

    private int getNextSuggestionId() {
        return this.suggestions.isEmpty() ? 1 : this.suggestions.stream().mapToInt(s -> s.id).max().orElse(0) + 1;
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public class ReportCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            long timeLeft;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("staffhelp.report")) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-permission")));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.report-usage")));
                return true;
            }
            int cooldownTime = StaffHelp.this.config.getInt("report-cooldown");
            if (StaffHelp.this.reportCooldowns.containsKey(player.getUniqueId()) && (timeLeft = StaffHelp.this.reportCooldowns.get(player.getUniqueId()) + TimeUnit.SECONDS.toMillis(cooldownTime) - System.currentTimeMillis()) > 0L) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.cooldown").replace("%time%", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(timeLeft)))));
                return true;
            }
            String targetName = args[0];
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null && StaffHelp.this.config.getBoolean("require-online-player")) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.player-not-found")));
                return true;
            }
            StringBuilder reason = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                reason.append(args[i]).append(" ");
            }
            String uuid = target != null ? target.getUniqueId().toString() : "unknown";
            Report report = new Report(StaffHelp.this, StaffHelp.this.getNextReportId(), player.getName(), player.getUniqueId(), targetName, uuid, reason.toString().trim(), System.currentTimeMillis(), false, "none");
            StaffHelp.this.reports.add(report);
            StaffHelp.this.reportCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.report-sent")));
            String staffNotification = StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.staff-notification").replace("%reporter%", player.getName()).replace("%reported%", targetName).replace("%reason%", reason.toString().trim()));
            for (Player staff : Bukkit.getOnlinePlayers()) {
                if (!staff.hasPermission("staffhelp.notify")) continue;
                staff.sendMessage(staffNotification);
            }
            StaffHelp.this.saveData();
            return true;
        }
    }

    public class ReadReportsCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("staffhelp.readreports")) {
                sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-permission")));
                return true;
            }
            if (StaffHelp.this.reports.isEmpty()) {
                sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-reports")));
                return true;
            }
            int page = 1;
            if (args.length > 0) {
                try {
                    page = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.invalid-page")));
                    return true;
                }
            }
            StaffHelp.this.displayReports(sender, page);
            return true;
        }
    }

    public class SuggestionCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            long timeLeft;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("staffhelp.suggest")) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-permission")));
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.suggestion-usage")));
                return true;
            }
            int cooldownTime = StaffHelp.this.config.getInt("suggestion-cooldown");
            if (StaffHelp.this.suggestionCooldowns.containsKey(player.getUniqueId()) && (timeLeft = StaffHelp.this.suggestionCooldowns.get(player.getUniqueId()) + TimeUnit.SECONDS.toMillis(cooldownTime) - System.currentTimeMillis()) > 0L) {
                player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.cooldown").replace("%time%", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(timeLeft)))));
                return true;
            }
            StringBuilder suggestionText = new StringBuilder();
            for (String arg : args) {
                suggestionText.append(arg).append(" ");
            }
            Suggestion suggestion = new Suggestion(StaffHelp.this, StaffHelp.this.getNextSuggestionId(), player.getName(), player.getUniqueId(), suggestionText.toString().trim(), System.currentTimeMillis(), SuggestionStatus.PENDING);
            StaffHelp.this.suggestions.add(suggestion);
            StaffHelp.this.suggestionCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            player.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.suggestion-sent")));
            StaffHelp.this.saveData();
            return true;
        }
    }

    public class ReadSuggestionsCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("staffhelp.readsuggestions")) {
                sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-permission")));
                return true;
            }
            if (StaffHelp.this.suggestions.isEmpty()) {
                sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-suggestions")));
                return true;
            }
            int page = 1;
            if (args.length > 0) {
                try {
                    page = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.invalid-page")));
                    return true;
                }
            }
            StaffHelp.this.displaySuggestions(sender, page);
            return true;
        }
    }

    public class MainCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("staffhelp.admin")) {
                sender.sendMessage(StaffHelp.this.colorize(StaffHelp.this.config.getString("messages.no-permission")));
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(StaffHelp.this.colorize("&6StaffHelp Enhanced v2.0.0"));
                sender.sendMessage(StaffHelp.this.colorize("&7Commands: /staffhelp [reload|webinfo]"));
                return true;
            }
            if ("reload".equals(args[0])) {
                StaffHelp.this.reloadConfig();
                StaffHelp.this.config = StaffHelp.this.getConfig();
                StaffHelp.this.loadData();
                sender.sendMessage(StaffHelp.this.colorize("&aStaffHelp configuration reloaded!"));
            } else if ("webinfo".equals(args[0]) && sender.hasPermission("staffhelp.web")) {
                int port = StaffHelp.this.config.getInt("web-interface.port", 9090);
                String username = StaffHelp.this.config.getString("web-interface.username", "admin");
                sender.sendMessage(StaffHelp.this.colorize("&6Web Interface Info:"));
                sender.sendMessage(StaffHelp.this.colorize("&7URL: &fhttp://localhost:" + port));
                sender.sendMessage(StaffHelp.this.colorize("&7Username: &f" + username));
                sender.sendMessage(StaffHelp.this.colorize("&7Password: &f[Check config]"));
            }
            return true;
        }
    }

    private class LoginPageHandler
    implements HttpHandler {
        private LoginPageHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (StaffHelp.this.isAuthenticated(exchange)) {
                exchange.getResponseHeaders().set("Location", "/dashboard");
                exchange.sendResponseHeaders(302, -1L);
                return;
            }
            String theme = StaffHelp.this.config.getString("web-interface.theme", "dark");
            String html = StaffHelp.this.generateLoginHTML(theme);
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(200, html.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(html.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class LoginHandler
    implements HttpHandler {
        private LoginHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String body = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            Map<String, String> params = StaffHelp.this.parseFormData(body);
            String username = params.get("username");
            String password = params.get("password");
            String expectedUsername = StaffHelp.this.config.getString("web-interface.username", "admin");
            String expectedPassword = StaffHelp.this.config.getString("web-interface.password", "staffhelp123");
            if (expectedUsername.equals(username) && expectedPassword.equals(password)) {
                String sessionId = StaffHelp.this.generateSessionId();
                StaffHelp.this.activeSessions.add(sessionId);
                exchange.getResponseHeaders().set("Set-Cookie", "staffhelp_session=" + sessionId + "; Path=/; HttpOnly");
                exchange.getResponseHeaders().set("Location", "/dashboard");
                exchange.sendResponseHeaders(302, -1L);
            } else {
                exchange.getResponseHeaders().set("Location", "/?error=invalid");
                exchange.sendResponseHeaders(302, -1L);
            }
        }
    }

    private class DashboardHandler
    implements HttpHandler {
        private DashboardHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!StaffHelp.this.isAuthenticated(exchange)) {
                exchange.getResponseHeaders().set("Location", "/");
                exchange.sendResponseHeaders(302, -1L);
                return;
            }
            String theme = StaffHelp.this.config.getString("web-interface.theme", "dark");
            String html = StaffHelp.this.generateDashboardHTML(theme);
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(200, html.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(html.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class ReportsAPIHandler
    implements HttpHandler {
        private ReportsAPIHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!StaffHelp.this.isAuthenticated(exchange)) {
                exchange.sendResponseHeaders(401, -1L);
                return;
            }
            JsonObject response = new JsonObject();
            JsonArray reportsJson = new JsonArray();
            for (Report report : StaffHelp.this.reports) {
                JsonObject reportJson = new JsonObject();
                reportJson.addProperty("id", (Number)report.id);
                reportJson.addProperty("reporter", report.reporter);
                reportJson.addProperty("reported", report.reported);
                reportJson.addProperty("reason", report.reason);
                reportJson.addProperty("timestamp", (Number)report.timestamp);
                reportJson.addProperty("resolved", Boolean.valueOf(report.resolved));
                reportJson.addProperty("action", report.action);
                reportsJson.add((JsonElement)reportJson);
            }
            response.add("reports", (JsonElement)reportsJson);
            String jsonResponse = StaffHelp.this.gson.toJson((JsonElement)response);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, jsonResponse.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(jsonResponse.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class SuggestionsAPIHandler
    implements HttpHandler {
        private SuggestionsAPIHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!StaffHelp.this.isAuthenticated(exchange)) {
                exchange.sendResponseHeaders(401, -1L);
                return;
            }
            JsonObject response = new JsonObject();
            JsonArray suggestionsJson = new JsonArray();
            for (Suggestion suggestion : StaffHelp.this.suggestions) {
                JsonObject suggestionJson = new JsonObject();
                suggestionJson.addProperty("id", (Number)suggestion.id);
                suggestionJson.addProperty("player", suggestion.player);
                suggestionJson.addProperty("suggestion", suggestion.suggestion);
                suggestionJson.addProperty("timestamp", (Number)suggestion.timestamp);
                suggestionJson.addProperty("status", suggestion.status.name());
                suggestionsJson.add((JsonElement)suggestionJson);
            }
            response.add("suggestions", (JsonElement)suggestionsJson);
            String jsonResponse = StaffHelp.this.gson.toJson((JsonElement)response);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, jsonResponse.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(jsonResponse.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class ActionAPIHandler
    implements HttpHandler {
        private ActionAPIHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!StaffHelp.this.isAuthenticated(exchange) || !"POST".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(401, -1L);
                return;
            }
            String body = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            JsonObject request = (JsonObject)StaffHelp.this.gson.fromJson(body, JsonObject.class);
            String type = request.get("type").getAsString();
            int id = request.get("id").getAsInt();
            JsonObject response = new JsonObject();
            if ("report".equals(type)) {
                String action = request.get("action").getAsString();
                StaffHelp.this.handleReportAction(id, action, request);
                response.addProperty("success", Boolean.valueOf(true));
            } else if ("suggestion".equals(type)) {
                String status = request.get("status").getAsString();
                StaffHelp.this.handleSuggestionStatus(id, status);
                response.addProperty("success", Boolean.valueOf(true));
            }
            String jsonResponse = StaffHelp.this.gson.toJson((JsonElement)response);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, jsonResponse.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(jsonResponse.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class ThemeAPIHandler
    implements HttpHandler {
        private ThemeAPIHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!StaffHelp.this.isAuthenticated(exchange) || !"POST".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(401, -1L);
                return;
            }
            String body = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            JsonObject request = (JsonObject)StaffHelp.this.gson.fromJson(body, JsonObject.class);
            String theme = request.get("theme").getAsString();
            StaffHelp.this.config.set("web-interface.theme", (Object)theme);
            StaffHelp.this.saveConfig();
            JsonObject response = new JsonObject();
            response.addProperty("success", Boolean.valueOf(true));
            String jsonResponse = StaffHelp.this.gson.toJson((JsonElement)response);
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, jsonResponse.getBytes(StandardCharsets.UTF_8).length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(jsonResponse.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class LogoutHandler
    implements HttpHandler {
        private LogoutHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String cookies = exchange.getRequestHeaders().getFirst("Cookie");
            if (cookies != null) {
                for (String cookie : cookies.split(";")) {
                    String[] parts = cookie.trim().split("=");
                    if (parts.length != 2 || !"staffhelp_session".equals(parts[0])) continue;
                    StaffHelp.this.activeSessions.remove(parts[1]);
                    break;
                }
            }
            exchange.getResponseHeaders().set("Set-Cookie", "staffhelp_session=; Path=/; HttpOnly; Max-Age=0");
            exchange.getResponseHeaders().set("Location", "/");
            exchange.sendResponseHeaders(302, -1L);
        }
    }

    public class Report {
        public int id;
        public String reporter;
        public UUID reporterUUID;
        public String reported;
        public String reportedUUID;
        public String reason;
        public long timestamp;
        public boolean resolved;
        public String action;

        public Report(StaffHelp this$0, int id, String reporter, UUID reporterUUID, String reported, String reportedUUID, String reason, long timestamp, boolean resolved, String action) {
            this.id = id;
            this.reporter = reporter;
            this.reporterUUID = reporterUUID;
            this.reported = reported;
            this.reportedUUID = reportedUUID;
            this.reason = reason;
            this.timestamp = timestamp;
            this.resolved = resolved;
            this.action = action;
        }
    }

    public class Suggestion {
        public int id;
        public String player;
        public UUID playerUUID;
        public String suggestion;
        public long timestamp;
        public SuggestionStatus status;

        public Suggestion(StaffHelp this$0, int id, String player, UUID playerUUID, String suggestion, long timestamp, SuggestionStatus status) {
            this.id = id;
            this.player = player;
            this.playerUUID = playerUUID;
            this.suggestion = suggestion;
            this.timestamp = timestamp;
            this.status = status;
        }
    }

    public static enum SuggestionStatus {
        PENDING,
        ACCEPTED,
        DECLINED,
        COMPLETED;

    }
}

