/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.vrk.shared.mixin;

import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.server.packs.repository.Pack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PackSelectionModel.EntryBase.class})
public abstract class EntryBaseMixin {
    @Unique
    private static final Set<String> PROTECTED_PACK_IDS = Set.of("vanilla", "fabric", "mod_data", "mod_resources");
    @Shadow
    @Final
    private Pack pack;

    @Shadow
    public abstract String getId();

    @Shadow
    protected abstract List<Pack> getSelfList();

    @Inject(method={"canMoveUp"}, at={@At(value="HEAD")}, cancellable=true)
    private void vrkmod$canMoveUp(CallbackInfoReturnable<Boolean> cir) {
        Pack packAbove;
        if (PROTECTED_PACK_IDS.contains(this.getId())) {
            cir.setReturnValue((Object)false);
            return;
        }
        List<Pack> list = this.getSelfList();
        int currentIndex = list.indexOf(this.pack);
        if (currentIndex > 0 && PROTECTED_PACK_IDS.contains((packAbove = list.get(currentIndex - 1)).getId())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canMoveDown"}, at={@At(value="HEAD")}, cancellable=true)
    private void vrkmod$canMoveDown(CallbackInfoReturnable<Boolean> cir) {
        Pack packBelow;
        if (PROTECTED_PACK_IDS.contains(this.getId())) {
            cir.setReturnValue((Object)false);
            return;
        }
        List<Pack> list = this.getSelfList();
        int currentIndex = list.indexOf(this.pack);
        if (currentIndex >= 0 && currentIndex < list.size() - 1 && PROTECTED_PACK_IDS.contains((packBelow = list.get(currentIndex + 1)).getId())) {
            cir.setReturnValue((Object)false);
        }
    }
}

