/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.vrk.shared.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PackRepository.class})
public abstract class PackRepositoryMixin {
    @Unique
    private static final String VANILLA_PACK_ID = "vanilla";

    @Unique
    private boolean isValidForSort() {
        return PackRepository.class.cast(this) == Minecraft.getInstance().getResourcePackRepository();
    }

    @Inject(method={"rebuildSelected"}, at={@At(value="RETURN")}, cancellable=true)
    private void vrkmod$sortRebuildSelected(CallbackInfoReturnable<List<Pack>> cir) {
        ObjectArrayList list = new ObjectArrayList((Collection)cir.getReturnValue());
        if (!this.isValidForSort() || list.isEmpty() || VANILLA_PACK_ID.equals(((Pack)list.get(0)).getId())) {
            return;
        }
        list.sort((pack1, pack2) -> {
            boolean pack1IsVanilla = VANILLA_PACK_ID.equals(pack1.getId());
            boolean pack2IsVanilla = VANILLA_PACK_ID.equals(pack2.getId());
            if (pack1IsVanilla && !pack2IsVanilla) {
                return -1;
            }
            if (!pack1IsVanilla && pack2IsVanilla) {
                return 1;
            }
            return 0;
        });
        cir.setReturnValue((Object)list);
    }
}

