/*
 * Decompiled with CFR 0.152.
 */
package JP.MichiJP.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1670;
import net.minecraft.class_1674;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1687;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class ProjectileSimulator {
    private static final class_310 mc = class_310.method_1551();
    public final Vector3d pos = new Vector3d();
    private final Vector3d velocity = new Vector3d();
    private class_1297 simulatingEntity;
    private double gravity;
    private double airDrag;
    private double waterDrag;
    private float width;
    private float height;

    public boolean set(class_1309 user, class_1799 itemStack, float tickDelta) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1753) {
            float pullProgress = class_1753.method_7722((int)user.method_6048());
            if ((double)pullProgress <= 0.1) {
                return false;
            }
            this.set(user, 0.0, pullProgress * 3.0f, 0.05, 0.6, tickDelta, class_1299.field_6122);
        } else if (item instanceof class_1764) {
            class_9278 projectiles = (class_9278)itemStack.method_57824(class_9334.field_49649);
            if (projectiles == null || projectiles.method_57442()) {
                return false;
            }
            if (projectiles.method_57438(class_1802.field_8639)) {
                this.set(user, 0.0, 1.6, 0.0, 1.0, tickDelta, class_1299.field_6133);
            } else {
                this.set(user, 0.0, 3.15, 0.05, 0.6, tickDelta, class_1299.field_6122);
            }
        } else if (item instanceof class_1787) {
            this.setFishingBobber(user, tickDelta);
        } else if (item instanceof class_1835) {
            this.set(user, 0.0, 2.5, 0.05, 0.99, tickDelta, class_1299.field_6127);
        } else if (item instanceof class_1823) {
            this.set(user, 0.0, 1.5, 0.03, 0.8, tickDelta, class_1299.field_6068);
        } else if (item instanceof class_1771) {
            this.set(user, 0.0, 1.5, 0.03, 0.8, tickDelta, class_1299.field_6144);
        } else if (item instanceof class_1776) {
            this.set(user, 0.0, 1.5, 0.03, 0.8, tickDelta, class_1299.field_6082);
        } else if (item instanceof class_1779) {
            this.set(user, -20.0, 0.7, 0.07, 0.8, tickDelta, class_1299.field_6064);
        } else if (item instanceof class_4537) {
            this.set(user, -20.0, 0.5, 0.05, 0.8, tickDelta, class_1299.field_6045);
        } else {
            return false;
        }
        return true;
    }

    public void set(class_1309 user, double roll, double speed, double gravity, double waterDrag, float tickDelta, class_1299<?> type) {
        class_243 eyePos = user.method_33571();
        this.pos.set(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
        float yaw = user.method_5705(tickDelta);
        float pitch = user.method_5695(tickDelta);
        double x = -Math.sin((double)yaw * 0.017453292) * Math.cos((double)pitch * 0.017453292);
        double y = -Math.sin(((double)pitch + roll) * 0.017453292);
        double z = Math.cos((double)yaw * 0.017453292) * Math.cos((double)pitch * 0.017453292);
        this.velocity.set(x, y, z).normalize().mul(speed);
        class_243 userVel = user.method_18798();
        if (!user.method_24828()) {
            this.velocity.add(userVel.field_1352, userVel.field_1351, userVel.field_1350);
        } else {
            this.velocity.add(userVel.field_1352, 0.0, userVel.field_1350);
        }
        this.simulatingEntity = type.method_5883((class_1937)ProjectileSimulator.mc.field_1687);
        this.gravity = gravity;
        this.airDrag = 0.99;
        this.waterDrag = waterDrag;
        this.width = type.method_17685();
        this.height = type.method_17686();
    }

    public void setFishingBobber(class_1309 user, float tickDelta) {
        class_243 eyePos = user.method_33571();
        float yaw = user.method_5705(tickDelta);
        float pitch = user.method_5695(tickDelta);
        double h = Math.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        double i = Math.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        double j = -Math.cos(-pitch * ((float)Math.PI / 180));
        double k = Math.sin(-pitch * ((float)Math.PI / 180));
        this.pos.set(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350).sub(i * 0.3, 0.0, h * 0.3);
        this.velocity.set(-i, class_3532.method_15350((double)(-(k / j)), (double)-5.0, (double)5.0), -h);
        double l = this.velocity.length();
        this.velocity.mul(0.6 / l + 0.5, 0.6 / l + 0.5, 0.6 / l + 0.5);
        this.simulatingEntity = class_1299.field_6103.method_5883((class_1937)ProjectileSimulator.mc.field_1687);
        this.gravity = 0.03;
        this.airDrag = 0.92;
        this.waterDrag = 0.0;
        this.width = class_1299.field_6103.method_17685();
        this.height = class_1299.field_6103.method_17686();
    }

    public boolean set(class_1297 entity, float tickDelta) {
        if (entity instanceof class_1667) {
            this.setEntityParams(entity, 0.05, 0.6, tickDelta);
        } else if (entity instanceof class_1685) {
            this.setEntityParams(entity, 0.05, 0.99, tickDelta);
        } else if (entity instanceof class_1684 || entity instanceof class_1680 || entity instanceof class_1681) {
            this.setEntityParams(entity, 0.03, 0.8, tickDelta);
        } else if (entity instanceof class_1683) {
            this.setEntityParams(entity, 0.07, 0.8, tickDelta);
        } else if (entity instanceof class_1686) {
            this.setEntityParams(entity, 0.05, 0.8, tickDelta);
        } else if (entity instanceof class_1687 || entity instanceof class_1674 || entity instanceof class_1670) {
            this.setEntityParams(entity, 0.0, 1.0, tickDelta);
            this.airDrag = 1.0;
        } else {
            return false;
        }
        if (entity.method_5740()) {
            this.gravity = 0.0;
        }
        return true;
    }

    private void setEntityParams(class_1297 entity, double gravity, double waterDrag, float tickDelta) {
        this.simulatingEntity = entity;
        class_243 p = entity.method_19538();
        this.pos.set(p.field_1352, p.field_1351, p.field_1350);
        class_243 v = entity.method_18798();
        this.velocity.set(v.field_1352, v.field_1351, v.field_1350);
        this.gravity = gravity;
        this.waterDrag = waterDrag;
        this.airDrag = 0.99;
        this.width = entity.method_17681();
        this.height = entity.method_17682();
    }

    public class_239 tick() {
        class_243 prevPos = new class_243(this.pos.x, this.pos.y, this.pos.z);
        this.pos.add((Vector3dc)this.velocity);
        class_243 currentPos = new class_243(this.pos.x, this.pos.y, this.pos.z);
        this.velocity.mul(this.isTouchingWater(currentPos) ? this.waterDrag : this.airDrag);
        this.velocity.sub(0.0, this.gravity, 0.0);
        class_3965 hitResult = ProjectileSimulator.mc.field_1687.method_17742(new class_3959(prevPos, currentPos, class_3959.class_3960.field_17558, this.waterDrag == 0.0 ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, this.simulatingEntity));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            return hitResult;
        }
        class_238 box = new class_238(prevPos.field_1352, prevPos.field_1351, prevPos.field_1350, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350).method_1014(1.0);
        class_3966 entityHit = class_1675.method_37226((class_1937)ProjectileSimulator.mc.field_1687, (class_1297)this.simulatingEntity, (class_243)prevPos, (class_243)currentPos, (class_238)box, e -> {
            class_1676 pe;
            class_1297 patt0$temp;
            return !e.method_7325() && e.method_5863() && ((patt0$temp = this.simulatingEntity) instanceof class_1676 ? e != (pe = (class_1676)patt0$temp).method_24921() : e != this.simulatingEntity);
        }, (float)0.3f);
        if (entityHit != null) {
            return entityHit;
        }
        return null;
    }

    private boolean isTouchingWater(class_243 p) {
        class_2338 bp = class_2338.method_49638((class_2374)p);
        class_3610 fs = ProjectileSimulator.mc.field_1687.method_8316(bp);
        return fs.method_15772() == class_3612.field_15910 || fs.method_15772() == class_3612.field_15909;
    }
}

