/*
 * Decompiled with CFR 0.152.
 */
package JP.MichiJP.client;

import JP.MichiJP.client.ProjectileSimulator;
import JP.MichiJP.config.TrajectorysConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class TrajectorysClient
implements ClientModInitializer {
    private static final ProjectileSimulator simulator = new ProjectileSimulator();
    private static final List<Vector3d> pathPoints = new ArrayList<Vector3d>();
    private class_1297 lastSoundEntity = null;

    public void onInitializeClient() {
        TrajectorysConfig.load();
        WorldRenderEvents.LAST.register(context -> {
            if (!TrajectorysConfig.get().enableMod) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 == null || mc.field_1724 == null) {
                return;
            }
            float tickDelta = context.tickCounter().method_60637(false);
            class_243 cameraPos = context.camera().method_19326();
            class_4587 matrices = context.matrixStack();
            class_239 selfHitResult = null;
            boolean isSimulatingSelf = false;
            for (class_1657 player : mc.field_1687.method_18456()) {
                class_239 hit;
                boolean isSelf;
                boolean bl = isSelf = player == mc.field_1724;
                if (isSelf && !TrajectorysConfig.get().showSelf || !isSelf && !TrajectorysConfig.get().showOthers) continue;
                if (simulator.set((class_1309)player, player.method_6047(), tickDelta)) {
                    hit = this.simulateAndRender(matrices, cameraPos, tickDelta);
                    if (!isSelf) continue;
                    selfHitResult = hit;
                    isSimulatingSelf = true;
                    continue;
                }
                if (!simulator.set((class_1309)player, player.method_6079(), tickDelta)) continue;
                hit = this.simulateAndRender(matrices, cameraPos, tickDelta);
                if (!isSelf) continue;
                selfHitResult = hit;
                isSimulatingSelf = true;
            }
            if (TrajectorysConfig.get().showProjectiles) {
                for (class_1297 entity : mc.field_1687.method_18112()) {
                    if (!(entity instanceof class_1676) || !simulator.set(entity, tickDelta)) continue;
                    this.simulateAndRender(matrices, cameraPos, tickDelta);
                }
            }
            if (isSimulatingSelf && TrajectorysConfig.get().playSound) {
                class_1297 currentHitEntity = null;
                if (selfHitResult instanceof class_3966) {
                    class_3966 entityHit = (class_3966)selfHitResult;
                    currentHitEntity = entityHit.method_17782();
                }
                if (currentHitEntity != null && currentHitEntity != this.lastSoundEntity) {
                    mc.field_1724.method_5783(class_3417.field_14627, 0.5f, 1.5f);
                }
                this.lastSoundEntity = currentHitEntity;
            } else {
                this.lastSoundEntity = null;
            }
        });
    }

    private class_239 simulateAndRender(class_4587 matrices, class_243 cameraPos, float tickDelta) {
        pathPoints.clear();
        class_239 finalHit = null;
        pathPoints.add(new Vector3d((Vector3dc)TrajectorysClient.simulator.pos));
        for (int i = 0; i < 500; ++i) {
            class_239 result = simulator.tick();
            pathPoints.add(new Vector3d((Vector3dc)TrajectorysClient.simulator.pos));
            if (result == null) continue;
            finalHit = result;
            break;
        }
        this.renderPath(matrices, cameraPos, finalHit, tickDelta);
        return finalHit;
    }

    private void renderPath(class_4587 matrices, class_243 cameraPos, class_239 finalHit, float tickDelta) {
        class_289 tessellator = class_289.method_1348();
        TrajectorysConfig config = TrajectorysConfig.get();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.lineWidth((float)((float)config.lineWidth));
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        matrices.method_22903();
        matrices.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        Matrix4f matrix = matrices.method_23760().method_23761();
        if (config.renderLine) {
            int color = config.lineColor;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = color >> 24 & 0xFF;
            Vector3d prev = null;
            for (Vector3d point : pathPoints) {
                if (prev != null) {
                    buffer.method_22918(matrix, (float)prev.x, (float)prev.y, (float)prev.z).method_1336(r, g, b, a);
                    buffer.method_22918(matrix, (float)point.x, (float)point.y, (float)point.z).method_1336(r, g, b, a);
                }
                prev = point;
            }
        }
        if (config.renderHitBox && finalHit != null) {
            if (finalHit.method_17783() == class_239.class_240.field_1331) {
                class_1297 entity = ((class_3966)finalHit).method_17782();
                double x = class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317());
                double y = class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318());
                double z = class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321());
                class_238 box = entity.method_5829().method_989(x - entity.method_23317(), y - entity.method_23318(), z - entity.method_23321());
                int color = config.entityHitColor;
                this.drawBox(buffer, matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, color);
            } else if (finalHit.method_17783() == class_239.class_240.field_1332) {
                class_243 pos = finalHit.method_17784();
                float x = (float)pos.field_1352;
                float y = (float)pos.field_1351;
                float z = (float)pos.field_1350;
                float size = (float)config.boxSize;
                int color = config.blockHitColor;
                this.drawBox(buffer, matrix, x - size, y - size, z - size, x + size, y + size, z + size, color);
            }
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        matrices.method_22909();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBox(class_287 buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        buffer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a);
        buffer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a);
    }
}

