/*
 * Decompiled with CFR 0.152.
 */
package JP.MichiJP.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class TrajectorysConfig {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "trajectorys.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TrajectorysConfig INSTANCE = new TrajectorysConfig();
    public boolean enableMod = true;
    public boolean showSelf = true;
    public boolean showOthers = true;
    public boolean showProjectiles = true;
    public boolean playSound = true;
    public boolean renderLine = true;
    public double lineWidth = 2.0;
    public boolean renderHitBox = true;
    public double boxSize = 0.25;
    public int lineColor = -23296;
    public int entityHitColor = -65536;
    public int blockHitColor = -16776961;

    public static TrajectorysConfig get() {
        return INSTANCE;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (TrajectorysConfig)GSON.fromJson((Reader)reader, TrajectorysConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

