/*
 * Decompiled with CFR 0.152.
 */
package JP.MichiJP.client;

import JP.MichiJP.client.ProjectileSimulator;
import JP.MichiJP.config.TrajectorysConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1823;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4537;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9239;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TrajectorysClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"trajectorys");
    private static final ProjectileSimulator simulator = new ProjectileSimulator();
    private static final List<Path> paths = new ArrayList<Path>();
    private static int logThrottle = 0;
    private static final double MULTISHOT_OFFSET = Math.toRadians(10.0);
    private static class_1297 lastSoundEntity = null;

    public void onInitializeClient() {
        TrajectorysConfig.load();
        LOGGER.info("[Trajectorys] Client Initialized.");
    }

    public static void onRenderWorld(class_4587 matrices, float tickDelta, class_4184 camera, Matrix4f viewMatrix) {
        if (!TrajectorysConfig.get().enableMod) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        paths.clear();
        for (class_1657 player : mc.field_1687.method_18456()) {
            boolean isSelf;
            boolean bl = isSelf = player == mc.field_1724;
            if (isSelf && !TrajectorysConfig.get().showSelf || !isSelf && !TrajectorysConfig.get().showOthers) continue;
            TrajectorysClient.calculatePath(player, tickDelta);
        }
        if (TrajectorysConfig.get().showProjectiles) {
            for (class_1297 entity : mc.field_1687.method_18112()) {
                if (!(entity instanceof class_1676)) continue;
                TrajectorysClient.calculateFiredPath(entity, tickDelta);
            }
        }
        TrajectorysClient.renderPaths(matrices, cameraPos);
        TrajectorysClient.playHitSound(mc);
    }

    private static void calculatePath(class_1657 player, float tickDelta) {
        class_1799 itemStack = player.method_6047();
        if (!TrajectorysClient.isProjectileWeapon(itemStack.method_7909()) && !TrajectorysClient.isProjectileWeapon((itemStack = player.method_6079()).method_7909())) {
            return;
        }
        if (simulator.set((class_1309)player, itemStack, 0.0, true, tickDelta)) {
            Path path = new Path();
            path.calculate();
            paths.add(path);
            if (itemStack.method_7909() instanceof class_1764 && TrajectorysClient.hasMultishot(itemStack, player)) {
                if (simulator.set((class_1309)player, itemStack, MULTISHOT_OFFSET, true, tickDelta)) {
                    Path leftPath = new Path();
                    leftPath.calculate();
                    paths.add(leftPath);
                }
                if (simulator.set((class_1309)player, itemStack, -MULTISHOT_OFFSET, true, tickDelta)) {
                    Path rightPath = new Path();
                    rightPath.calculate();
                    paths.add(rightPath);
                }
            }
        }
    }

    private static boolean hasMultishot(class_1799 stack, class_1657 player) {
        if (player.method_73183() == null) {
            return false;
        }
        Optional registry = player.method_73183().method_30349().method_46759(class_7924.field_41265);
        if (registry.isPresent()) {
            Optional entry = ((class_2378)registry.get()).method_46746(class_1893.field_9108);
            return entry.map(enchantmentReference -> class_1890.method_8225((class_6880)enchantmentReference, (class_1799)stack) > 0).orElse(false);
        }
        return false;
    }

    private static boolean isProjectileWeapon(class_1792 item) {
        return item instanceof class_1811 || item instanceof class_1787 || item instanceof class_1835 || item instanceof class_1823 || item instanceof class_1771 || item instanceof class_1776 || item instanceof class_1779 || item instanceof class_4537 || item instanceof class_9239;
    }

    private static void calculateFiredPath(class_1297 entity, float tickDelta) {
        if (simulator.set(entity, tickDelta)) {
            Path path = new Path();
            path.calculate();
            paths.add(path);
        }
    }

    private static void renderPaths(class_4587 matrices, class_243 cameraPos) {
        if (paths.isEmpty()) {
            return;
        }
        TrajectorysConfig config = TrajectorysConfig.get();
        matrices.method_22903();
        matrices.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_9799 allocator = new class_9799(256);
        class_4597.class_4598 immediate = class_4597.method_22991((class_9799)allocator);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int r = config.lineColor >> 16 & 0xFF;
        int g = config.lineColor >> 8 & 0xFF;
        int b = config.lineColor & 0xFF;
        int a = 255;
        int hitR = config.entityHitColor >> 16 & 0xFF;
        int hitG = config.entityHitColor >> 8 & 0xFF;
        int hitB = config.entityHitColor & 0xFF;
        for (Path path : paths) {
            if (config.renderLine) {
                RenderSystem.lineWidth((float)((float)config.lineWidth));
                class_4588 lineBuffer = immediate.method_73477(class_1921.method_49043((double)(config.lineWidth > 0.0 ? config.lineWidth : 2.0)));
                for (int i = 0; i < path.points.size() - 1; ++i) {
                    Vector3d p1 = path.points.get(i);
                    Vector3d p2 = path.points.get(i + 1);
                    lineBuffer.method_22918(matrix, (float)p1.x, (float)p1.y, (float)p1.z).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f);
                    lineBuffer.method_22918(matrix, (float)p2.x, (float)p2.y, (float)p2.z).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f);
                }
            }
            if (config.renderHitBox && path.hitResult != null) {
                RenderSystem.lineWidth((float)((float)config.hitBoxLineWidth));
                class_4588 boxBuffer = immediate.method_73477(class_1921.method_23594());
                if (path.hitResult.method_17783() == class_239.class_240.field_1331) {
                    class_1297 entity = ((class_3966)path.hitResult).method_17782();
                    class_238 box = entity.method_5829();
                    TrajectorysClient.drawBox(boxBuffer, matrix, box, hitR, hitG, hitB, a);
                } else if (path.hitResult.method_17783() == class_239.class_240.field_1332) {
                    class_3965 blockHit = (class_3965)path.hitResult;
                    class_243 hitPos = blockHit.method_17784();
                    double x = hitPos.field_1352;
                    double y = hitPos.field_1351;
                    double z = hitPos.field_1350;
                    double s = config.boxSize > 0.0 ? config.boxSize : 0.1;
                    TrajectorysClient.drawBox(boxBuffer, matrix, new class_238(x - s, y - s, z - s, x + s, y + s, z + s), config.blockHitColor >> 16 & 0xFF, config.blockHitColor >> 8 & 0xFF, config.blockHitColor & 0xFF, a);
                }
            }
            immediate.method_22993();
        }
        allocator.close();
        GL11.glEnable((int)2929);
        RenderSystem.lineWidth((float)1.0f);
        matrices.method_22909();
    }

    private static void drawBox(class_4588 buffer, Matrix4f matrix, class_238 box, int r, int g, int b, int a) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        TrajectorysClient.drawLine(buffer, matrix, minX, minY, minZ, maxX, minY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, minY, minZ, maxX, minY, maxZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, minY, maxZ, minX, minY, maxZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, minX, minY, maxZ, minX, minY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, minX, maxY, minZ, maxX, maxY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, maxY, minZ, maxX, maxY, maxZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, maxY, maxZ, minX, maxY, maxZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, minX, maxY, maxZ, minX, maxY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, minX, minY, minZ, minX, maxY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, minY, minZ, maxX, maxY, minZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, maxX, minY, maxZ, maxX, maxY, maxZ, r, g, b, a);
        TrajectorysClient.drawLine(buffer, matrix, minX, minY, maxZ, minX, maxY, maxZ, r, g, b, a);
    }

    private static void drawLine(class_4588 buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a) {
        buffer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f);
    }

    private static void playHitSound(class_310 mc) {
        class_239 hit;
        if (!TrajectorysConfig.get().playSound) {
            return;
        }
        if (!paths.isEmpty() && (hit = TrajectorysClient.paths.get((int)0).hitResult) != null && hit.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)hit).method_17782();
            if (entity != null && !entity.equals((Object)lastSoundEntity)) {
                mc.field_1724.method_5783(class_3417.field_14627, 0.5f, 1.5f);
                lastSoundEntity = entity;
                return;
            }
            lastSoundEntity = entity;
            return;
        }
        lastSoundEntity = null;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Path {
        public final List<Vector3d> points = new ArrayList<Vector3d>();
        public class_239 hitResult = null;

        private Path() {
        }

        public void calculate() {
            this.points.add(new Vector3d((Vector3dc)TrajectorysClient.simulator.pos));
            for (int i = 0; i < 500; ++i) {
                class_239 result = simulator.tick();
                if (result != null) {
                    this.hitResult = result;
                    this.points.add(new Vector3d((Vector3dc)TrajectorysClient.simulator.pos));
                    break;
                }
                this.points.add(new Vector3d((Vector3dc)TrajectorysClient.simulator.pos));
            }
        }
    }
}

