/*
 * Decompiled with CFR 0.152.
 */
package JP.MichiJP.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class TrajectorysConfig {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "trajectorys.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TrajectorysConfig instance;
    public boolean enableMod = true;
    public boolean showSelf = true;
    public boolean showOthers = true;
    public boolean showProjectiles = true;
    public boolean playSound = true;
    public boolean renderLine = true;
    public double lineWidth = 2.0;
    public int lineColor = 16750080;
    public boolean renderHitBox = true;
    public double hitBoxLineWidth = 2.0;
    public double boxSize = 0.1;
    public int entityHitColor = 0xFF0000;
    public int blockHitColor = 65280;

    public static TrajectorysConfig get() {
        if (instance == null) {
            TrajectorysConfig.load();
        }
        return instance;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                instance = (TrajectorysConfig)GSON.fromJson((Reader)reader, TrajectorysConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (instance == null) {
            instance = new TrajectorysConfig();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

