/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.headindex;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyTransaction;
import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import us.potatoboy.headindex.api.Head;
import us.potatoboy.headindex.api.HeadDatabaseAPI;
import us.potatoboy.headindex.commands.HeadCommand;
import us.potatoboy.headindex.config.HeadIndexConfig;

public class HeadIndex
implements ModInitializer {
    public static final String MOD_ID = "headindex";
    public static final Logger LOGGER = LogManager.getLogger();
    public static HeadIndexConfig config;
    public static final HeadDatabaseAPI HEAD_DATABASE;
    public static Multimap<Head.Category, Head> heads;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> new HeadCommand((CommandDispatcher<class_2168>)dispatcher));
        CompletableFuture.runAsync(() -> {
            heads = HEAD_DATABASE.getHeads();
        });
        config = HeadIndexConfig.loadConfig(new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/head-index.json"));
    }

    public static void tryPurchase(class_3222 player, int amount, Runnable onPurchase) {
        int trueAmount = amount * HeadIndex.config.costAmount;
        switch (HeadIndex.config.economyType) {
            case FREE: {
                onPurchase.run();
                break;
            }
            case TAG: {
                HashSet<ItemVariant> stack = new HashSet<ItemVariant>();
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    class_1799 slotStack = player.method_31548().method_5438(i);
                    if (!slotStack.method_31573(config.getCostTag())) continue;
                    stack.add(ItemVariant.of((class_1799)slotStack));
                }
                try (Transaction transaction = Transaction.openOuter();){
                    long extracted = 0L;
                    for (ItemVariant item : stack) {
                        if ((extracted += PlayerInventoryStorage.of((class_1657)player).extract((Object)item, (long)trueAmount - extracted, (TransactionContext)transaction)) < (long)trueAmount) continue;
                        break;
                    }
                    if (extracted != (long)trueAmount) break;
                    transaction.commit();
                    onPurchase.run();
                    break;
                }
            }
            case ITEM: {
                try (Transaction transaction = Transaction.openOuter();){
                    long extracted = PlayerInventoryStorage.of((class_1657)player).extract((Object)ItemVariant.of((class_1935)config.getCostItem()), (long)trueAmount, (TransactionContext)transaction);
                    if (extracted != (long)trueAmount) break;
                    transaction.commit();
                    onPurchase.run();
                    break;
                }
            }
            case ECONOMY: {
                EconomyTransaction transaction;
                EconomyAccount account = CommonEconomy.getAccounts((class_3222)player, (EconomyCurrency)config.getCostCurrency(player.method_51469().method_8503())).stream().min(Comparator.comparing(x -> -x.balance())).orElse(null);
                if (account == null || !(transaction = account.decreaseBalance((long)trueAmount)).isSuccessful()) break;
                onPurchase.run();
                break;
            }
            case LEVEL: {
                if (player.field_7520 < trueAmount) break;
                player.method_7316(-trueAmount);
                onPurchase.run();
                break;
            }
            case LEVELPOINTS: {
                if (player.field_7495 < trueAmount) break;
                player.method_7255(-trueAmount);
                onPurchase.run();
            }
        }
    }

    static {
        HEAD_DATABASE = new HeadDatabaseAPI();
        heads = HashMultimap.create();
    }
}

