/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.headindex.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.commons.io.FileUtils;
import us.potatoboy.headindex.HeadIndex;
import us.potatoboy.headindex.api.Head;

public class HeadDatabaseAPI {
    private final String apiUrl = "https://minecraft-heads.com/scripts/api.php?cat=%s&tags=true";
    private final Path cachePath = FabricLoader.getInstance().getConfigDir().resolve("headindex-cache");

    public Multimap<Head.Category, Head> getHeads() {
        this.refreshCacheFromAPI();
        return this.loadCache();
    }

    private void refreshCacheFromAPI() {
        for (Head.Category category : Head.Category.values()) {
            try {
                HeadIndex.LOGGER.info("Saving {} heads to cache", (Object)category.name);
                URLConnection connection = URI.create(String.format("https://minecraft-heads.com/scripts/api.php?cat=%s&tags=true", category.name)).toURL().openConnection();
                BufferedInputStream stream = new BufferedInputStream(connection.getInputStream());
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)this.cachePath.resolve(category.name + ".json").toFile());
            }
            catch (IOException e) {
                HeadIndex.LOGGER.warn("Failed to save new heads to cache");
            }
            if (Files.exists(this.cachePath.resolve(category.name + ".json"), new LinkOption[0])) continue;
            HeadIndex.LOGGER.info("Loading fallback {} heads", (Object)category.name);
            try {
                Files.createDirectories(this.cachePath, new FileAttribute[0]);
                Files.copy((Path)((ModContainer)FabricLoader.getInstance().getModContainer("headindex").get()).findPath("cache/" + category.name + ".json").get(), this.cachePath.resolve(category.name + ".json"), new CopyOption[0]);
            }
            catch (IOException e) {
                HeadIndex.LOGGER.warn("Failed to load fallback heads", (Throwable)e);
            }
        }
    }

    private Multimap<Head.Category, Head> loadCache() {
        HashMultimap heads = HashMultimap.create();
        Gson gson = new Gson();
        for (Head.Category category : Head.Category.values()) {
            try {
                HeadIndex.LOGGER.info("Loading {} heads from cache", (Object)category.name);
                InputStream stream = Files.newInputStream(this.cachePath.resolve(category.name + ".json"), new OpenOption[0]);
                JsonArray headsJson = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonArray();
                for (JsonElement headJson : headsJson) {
                    try {
                        Head head = (Head)gson.fromJson(headJson, Head.class);
                        heads.put((Object)category, (Object)head);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        HeadIndex.LOGGER.warn("Invalid head: " + String.valueOf(headJson));
                    }
                }
            }
            catch (IOException e) {
                HeadIndex.LOGGER.warn("Failed to load heads from cache", (Throwable)e);
            }
        }
        HeadIndex.LOGGER.info("Finished loading {} heads", (Object)heads.size());
        return heads;
    }
}

