/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.headindex.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyCurrency;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class HeadIndexConfig {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).setPrettyPrinting().create();
    public int permissionLevel = 2;
    public EconomyType economyType = EconomyType.FREE;
    public class_2960 costType = class_2960.method_60655((String)"minecraft", (String)"diamond");
    public int costAmount = 1;

    public class_2561 getCost(MinecraftServer server) {
        switch (this.economyType.ordinal()) {
            case 0: {
                return class_2561.method_43471((String)this.getCostTag().getTranslationKey()).method_10852(class_2561.method_30163((String)(" \u00d7 " + this.costAmount)));
            }
            case 1: {
                return class_2561.method_43473().method_10852(this.getCostItem().method_63680()).method_10852(class_2561.method_30163((String)(" \u00d7 " + this.costAmount)));
            }
            case 2: {
                return this.getCostCurrency(server).formatValueText((long)this.costAmount, false);
            }
            case 4: {
                return class_2561.method_43469((String)"text.headindex.xp.levels", (Object[])new Object[]{this.costAmount});
            }
            case 5: {
                return class_2561.method_43469((String)"text.headindex.xp.points", (Object[])new Object[]{this.costAmount});
            }
        }
        return class_2561.method_43473();
    }

    public class_1792 getCostItem() {
        return (class_1792)class_7923.field_41178.method_63535(this.costType);
    }

    public EconomyCurrency getCostCurrency(MinecraftServer server) {
        return CommonEconomy.getCurrency((MinecraftServer)server, (class_2960)this.costType);
    }

    public class_6862<class_1792> getCostTag() {
        return class_6862.method_40092((class_5321)class_7923.field_41178.method_46765(), (class_2960)this.costType);
    }

    public static HeadIndexConfig loadConfig(File file) {
        HeadIndexConfig config;
        block18: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (HeadIndexConfig)GSON.fromJson((Reader)bufferedReader, HeadIndexConfig.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new HeadIndexConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File config) {
        try (FileOutputStream stream = new FileOutputStream(config);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }

    public static enum EconomyType {
        TAG,
        ITEM,
        ECONOMY,
        FREE,
        LEVEL,
        LEVELPOINTS;

    }

    public static class IdentifierSerializer
    implements JsonSerializer<class_2960>,
    JsonDeserializer<class_2960> {
        public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return class_2960.method_12829((String)json.getAsString());
        }
    }
}

