/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.headindex.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import us.potatoboy.headindex.HeadIndex;
import us.potatoboy.headindex.api.Head;
import us.potatoboy.headindex.config.HeadIndexConfig;
import us.potatoboy.headindex.gui.PagedHeadsGui;

public class HeadGui
extends SimpleGui {
    private final class_3222 player;

    public HeadGui(class_3222 player) {
        super(class_3917.field_18665, player, false);
        this.player = player;
        int index = 0;
        for (Head.Category category : Head.Category.values()) {
            this.addCategoryButton(index, category);
            ++index;
        }
        this.setTitle((class_2561)class_2561.method_43471((String)"text.headindex.title"));
        if (Permissions.check((class_1297)player, (String)"headindex.search", (int)HeadIndex.config.permissionLevel)) {
            this.setSlot(this.getSize() - 1, (GuiElementBuilderInterface)new GuiElementBuilder().setItem(class_1802.field_8448).setName((class_2561)class_2561.method_43471((String)"text.headindex.search").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)))).setCallback((index1, type1, action) -> {
                this.close();
                new SearchInputGui().open();
            }));
        }
        if (Permissions.check((class_1297)player, (String)"headindex.playername", (int)HeadIndex.config.permissionLevel)) {
            this.setSlot(this.getSize() - 2, (GuiElementBuilderInterface)new GuiElementBuilder().setItem(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.headindex.playername").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068))).setCallback((index1, type1, action) -> {
                this.close();
                new PlayerInputGui().open();
            }));
        }
    }

    private void addCategoryButton(int index, Head.Category category) {
        this.setSlot(index, category.createStack(), (i, type, action, gui) -> {
            this.close();
            PagedHeadsGui headsGui = new PagedHeadsGui((GuiInterface)this, new ArrayList<Head>(HeadIndex.heads.get((Object)category)));
            headsGui.setTitle((class_2561)category.getDisplayName());
            headsGui.open();
        });
    }

    public void openSearch(String search) {
        this.close();
        List<Head> heads = HeadIndex.heads.values().stream().filter(head -> head.name.toLowerCase().contains(search.toLowerCase()) || head.getTagsOrEmpty().toLowerCase().contains(search.toLowerCase())).collect(Collectors.toList());
        PagedHeadsGui headsGui = new PagedHeadsGui((GuiInterface)this, heads);
        headsGui.setTitle((class_2561)class_2561.method_43469((String)"text.headindex.search.output", (Object[])new Object[]{search}));
        headsGui.open();
    }

    private class PlayerInputGui
    extends AnvilInputGui {
        private final class_1799 inputStack;
        private final class_1799 outputStack;
        private long apiDebounce;

        public PlayerInputGui() {
            super(HeadGui.this.player, false);
            this.inputStack = class_1802.field_8575.method_7854();
            this.outputStack = class_1802.field_8575.method_7854();
            this.apiDebounce = 0L;
            this.inputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"text.headindex.playername").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            this.setSlot(1, this.inputStack);
            this.setSlot(2, this.outputStack);
            this.setDefaultInputValue("");
            this.setTitle((class_2561)class_2561.method_43471((String)"text.headindex.playername"));
        }

        public void onTick() {
            if (this.apiDebounce != 0L && this.apiDebounce <= System.currentTimeMillis()) {
                this.apiDebounce = 0L;
                CompletableFuture.runAsync(() -> {
                    MinecraftServer server = this.player.method_51469().method_8503();
                    Optional possibleProfile = server.method_73550().comp_839().findProfileByName(this.getInput());
                    MinecraftSessionService sessionService = server.method_73550().comp_837();
                    if (possibleProfile.isEmpty()) {
                        this.outputStack.method_57381(class_9334.field_49617);
                        return;
                    }
                    ProfileResult profileResult = sessionService.fetchProfile(((NameAndId)possibleProfile.get()).id(), false);
                    if (profileResult == null) {
                        this.outputStack.method_57381(class_9334.field_49617);
                    } else {
                        GameProfile profile = profileResult.profile();
                        this.outputStack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)profile));
                    }
                    GuiElementBuilder builder = GuiElementBuilder.from((class_1799)this.outputStack);
                    if (HeadIndex.config.economyType != HeadIndexConfig.EconomyType.FREE) {
                        builder.addLoreLine((class_2561)class_2561.method_43473());
                        builder.addLoreLine((class_2561)class_2561.method_43469((String)"text.headindex.price", (Object[])new Object[]{HeadIndex.config.getCost(server)}).method_27694(style -> style.method_10977(class_124.field_1061)));
                    }
                    this.setSlot(2, builder.asStack(), (index, type, action, gui) -> HeadIndex.tryPurchase(this.player, 1, () -> {
                        class_1799 cursorStack = this.getPlayer().field_7512.method_34255();
                        if (this.player.field_7512.method_34255().method_7960()) {
                            this.player.field_7512.method_34254(this.outputStack.method_7972());
                        } else if (class_1799.method_7984((class_1799)this.outputStack, (class_1799)cursorStack) && cursorStack.method_7947() < cursorStack.method_7914()) {
                            cursorStack.method_7933(1);
                        } else {
                            this.player.method_7328(this.outputStack.method_7972(), false);
                        }
                    }));
                });
            }
        }

        public void onInput(String input) {
            super.onInput(input);
            this.apiDebounce = System.currentTimeMillis() + 500L;
        }

        public void onClose() {
            HeadGui.this.open();
        }
    }

    private class SearchInputGui
    extends AnvilInputGui {
        private final class_1799 inputStack;
        private final class_1799 outputStack;

        public SearchInputGui() {
            super(HeadGui.this.player, false);
            this.inputStack = class_1802.field_8448.method_7854();
            this.outputStack = class_1802.field_8777.method_7854();
            this.inputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"text.headindex.search").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            this.outputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"text.headindex.search.output").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            this.setSlot(1, this.inputStack);
            this.setSlot(2, this.outputStack, (index, type, action, gui) -> HeadGui.this.openSearch(this.getInput()));
            this.setDefaultInputValue("");
            this.setTitle((class_2561)class_2561.method_43471((String)"text.headindex.search"));
        }

        public void onInput(String input) {
            super.onInput(input);
            this.outputStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"text.headindex.search.output", (Object[])new Object[]{input}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            this.setSlot(2, this.outputStack, (index, type, action, gui) -> HeadGui.this.openSearch(this.getInput()));
        }

        public void onClose() {
            HeadGui.this.open();
        }
    }
}

