/*
 * Decompiled with CFR 0.152.
 */
package us.potatoboy.headindex.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.api.gui.layered.Layer;
import eu.pb4.sgui.api.gui.layered.LayeredGui;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import us.potatoboy.headindex.HeadIndex;
import us.potatoboy.headindex.api.Head;
import us.potatoboy.headindex.config.HeadIndexConfig;

public class PagedHeadsGui
extends LayeredGui {
    public final List<Head> heads;
    public int page = 0;
    final GuiInterface parent;
    final Layer contentLayer;
    final Layer navigationLayer;
    private static final class_2583 regular = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068);
    private static final class_1799 backwardArrow = new Head(UUID.fromString("8aa062dc-9852-42b1-ae37-b2f8a3121c0e"), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzEwODI5OGZmMmIyNjk1MWQ2ODNlNWFkZTQ2YTQyZTkwYzJmN2M3ZGQ0MWJhYTkwOGJjNTg1MmY4YzMyZTU4MyJ9fX0=").createStack((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_10862(regular));
    private static final class_1799 forwardArrow = new Head(UUID.fromString("8aa062dc-9852-42b1-ae37-b2f8a3121c0e"), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzg2MTg1YjFkNTE5YWRlNTg1ZjE4NGMzNGYzZjNlMjBiYjY0MWRlYjg3OWU4MTM3OGU0ZWFmMjA5Mjg3In19fQ==").createStack((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_10862(regular));

    public PagedHeadsGui(GuiInterface parent, List<Head> heads) {
        super(class_3917.field_17327, parent.getPlayer(), false);
        Layer navigation;
        this.heads = heads;
        this.parent = parent;
        this.contentLayer = new Layer(5, 9);
        this.updateContent();
        this.addLayer(this.contentLayer, 0, 0);
        this.navigationLayer = navigation = new Layer(1, 9);
        navigation.setSlot(0, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8077).setName((class_2561)class_2561.method_43471((String)"text.headindex.back")).setCallback((index, type, action) -> this.close()));
        this.updateNavigation();
        this.addLayer(this.navigationLayer, 0, 5);
    }

    private int getMaxPage() {
        return Math.max(1, (int)Math.ceil((double)this.heads.size() / 45.0));
    }

    private void updateNavigation() {
        this.navigationLayer.setSlot(3, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)(this.page != 0 ? backwardArrow : class_1802.field_8157.method_7854())).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_10862(regular)).setCallback((index, type, action) -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.updatePage();
        }));
        this.navigationLayer.setSlot(5, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)(this.page + 1 < this.getMaxPage() ? forwardArrow : class_1802.field_8157.method_7854())).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_10862(regular)).setCallback((index, type, action) -> {
            ++this.page;
            if (this.page >= this.getMaxPage()) {
                this.page = this.getMaxPage() - 1;
            }
            this.updatePage();
        }));
        this.navigationLayer.setSlot(4, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8407).setName((class_2561)class_2561.method_43470((String)(this.page + 1 + " / " + this.getMaxPage())).method_10862(regular)));
    }

    private void updateContent() {
        for (int i = 0; i < 45; ++i) {
            if (this.heads.size() > i + this.page * 45) {
                Head head = this.heads.get(i + this.page * 45);
                GuiElementBuilder builder = GuiElementBuilder.from((class_1799)head.createStack());
                if (HeadIndex.config.economyType != HeadIndexConfig.EconomyType.FREE) {
                    builder.addLoreLine((class_2561)class_2561.method_43473());
                    builder.addLoreLine((class_2561)class_2561.method_43469((String)"text.headindex.price", (Object[])new Object[]{HeadIndex.config.getCost(this.getPlayer().method_51469().method_8503())}).method_27694(style -> style.method_10977(class_124.field_1061)));
                }
                this.contentLayer.setSlot(i, builder.asStack(), (index, type, action) -> this.processHeadClick(head, type));
                continue;
            }
            this.contentLayer.setSlot(i, class_1802.field_8162.method_7854());
        }
    }

    public void updatePage() {
        this.updateNavigation();
        this.updateContent();
    }

    private void processHeadClick(Head head, ClickType type) {
        class_3222 player = this.getPlayer();
        class_1799 cursorStack = this.getPlayer().field_7512.method_34255();
        class_1799 headStack = head.createStack();
        if (cursorStack.method_7960()) {
            if (type.shift) {
                HeadIndex.tryPurchase(player, 1, () -> player.method_31548().method_7394(headStack));
            } else if (type.isMiddle) {
                HeadIndex.tryPurchase(player, headStack.method_7914(), () -> {
                    headStack.method_7939(headStack.method_7914());
                    player.field_7512.method_34254(headStack);
                });
            } else {
                HeadIndex.tryPurchase(player, 1, () -> player.field_7512.method_34254(headStack));
            }
        } else {
            if (cursorStack.method_7914() <= cursorStack.method_7947()) {
                return;
            }
            if (class_1799.method_7984((class_1799)headStack, (class_1799)cursorStack)) {
                if (type.isLeft) {
                    HeadIndex.tryPurchase(player, 1, () -> cursorStack.method_7933(1));
                } else if (type.isRight) {
                    if (HeadIndex.config.economyType == HeadIndexConfig.EconomyType.FREE) {
                        cursorStack.method_7934(1);
                    }
                } else if (type.isMiddle) {
                    int amount = headStack.method_7914() - cursorStack.method_7947();
                    HeadIndex.tryPurchase(player, amount, () -> {
                        headStack.method_7939(headStack.method_7914());
                        player.field_7512.method_34254(headStack);
                    });
                }
            } else if (HeadIndex.config.economyType == HeadIndexConfig.EconomyType.FREE) {
                player.field_7512.method_34254(class_1799.field_8037);
            }
        }
    }

    public void onClose() {
        this.parent.open();
    }
}

