/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.ready;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.ready.ReadyTimerState;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0019\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001cR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001eR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/common/ready/ReadyService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "readyTimerState", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/ready/ReadyTimerState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "canUseReady", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "isReady", "", "setReady", "(Lme/jfenn/bingo/platform/IPlayerHandle;Z)V", "toggleReady", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "bingo-common"})
public final class ReadyService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ReadyTimerState readyTimerState;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IPermissionsApi permissions;

    public ReadyService(@NotNull BingoState state, @NotNull TeamService teamService, @NotNull BingoConfig config, @NotNull ReadyTimerState readyTimerState, @NotNull IPlayerManager playerManager, @NotNull IPermissionsApi permissions) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)readyTimerState, (String)"readyTimerState");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.state = state;
        this.teamService = teamService;
        this.config = config;
        this.readyTimerState = readyTimerState;
        this.playerManager = playerManager;
        this.permissions = permissions;
    }

    public final boolean canUseReady(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean isLobbyMode = this.state.isLobbyMode();
        boolean isPregameCountdown = this.state.getState() == GameState.PREGAME && this.config.getStartWhenReadySeconds() != null;
        boolean isPostgameCountdown = this.state.getState() == GameState.POSTGAME && this.config.getNextRoundWhenReadySeconds() != null;
        boolean isPermission = this.permissions.hasPermission(player, Permission.INSTANCE.getCOMMAND_READY());
        boolean isTeamChosen = !this.config.getStartWhenReadyWaitsForTeams() || this.playerManager.getPlayers().size() == 1 || this.teamService.isPlaying(player) || this.state.getPlayersSpectatingIds().contains(player.getUuid()) || isPostgameCountdown;
        return isLobbyMode && (isPregameCountdown || isPostgameCountdown) && isPermission && isTeamChosen;
    }

    public final void setReady(@NotNull IPlayerHandle player, boolean isReady) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canUseReady(player)) {
            return;
        }
        this.readyTimerState.setReady(player.getUuid(), isReady);
        this.playerManager.updatePlayerListName(player);
    }

    public final boolean toggleReady(@NotNull IPlayerHandle player) {
        boolean isReady;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean bl = isReady = !this.readyTimerState.isReady(player.getUuid());
        if (isReady && !this.teamService.isTeamChosen(player)) {
            this.teamService.notifyMissingTeam(player);
            return false;
        }
        this.setReady(player, isReady);
        return isReady;
    }
}

