/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.api.event;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import me.jfenn.bingo.api.annotations.BingoInternalApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B\u0013\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\f0\tR\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lme/jfenn/bingo/api/event/EventListener;", "T", "", "", "label", "<init>", "(Ljava/lang/String;)V", "Ljava/util/function/Consumer;", "callback", "Lme/jfenn/bingo/api/event/EventListener$Handle;", "register", "(Ljava/util/function/Consumer;)Lme/jfenn/bingo/api/event/EventListener$Handle;", "event", "", "invoke", "(Ljava/lang/Object;)V", "Ljava/lang/String;", "", "callbacks", "Ljava/util/List;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Handle", "bingo-api"})
public final class EventListener<T> {
    @Nullable
    private final String label;
    @NotNull
    private final List<Consumer<T>> callbacks;
    private final Logger logger;

    public EventListener(@Nullable String label) {
        this.label = label;
        this.callbacks = new ArrayList();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ EventListener(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @NotNull
    public final Handle register(@NotNull Consumer<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return new Handle(callback);
    }

    @BingoInternalApi
    public final void invoke(T event) {
        for (Consumer<T> callback : this.callbacks) {
            try {
                callback.accept(event);
            }
            catch (Throwable e) {
                this.logger.error("Exception in event handler (" + this.label + "):", e);
            }
        }
    }

    public EventListener() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR*\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/api/event/EventListener$Handle;", "Ljava/io/Closeable;", "Ljava/util/function/Consumer;", "callback", "<init>", "(Lme/jfenn/bingo/api/event/EventListener;Ljava/util/function/Consumer;)V", "", "close", "()V", "Ljava/util/function/Consumer;", "getCallback", "()Ljava/util/function/Consumer;", "setCallback", "(Ljava/util/function/Consumer;)V", "bingo-api"})
    public final class Handle
    implements Closeable {
        @Nullable
        private Consumer<T> callback;

        public Handle(Consumer<T> callback) {
            this.callback = callback;
        }

        @Nullable
        public final Consumer<T> getCallback() {
            return this.callback;
        }

        public final void setCallback(@Nullable Consumer<T> consumer) {
            this.callback = consumer;
        }

        @Override
        public void close() {
            Collection collection = EventListener.this.callbacks;
            Consumer consumer = this.callback;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(consumer);
            this.callback = null;
        }
    }
}

