/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.BingoCardEntry;
import me.jfenn.bingo.common.card.CardService;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveManager;
import me.jfenn.bingo.common.card.objective.ObjectiveListService;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.commands.CommonKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.model.CardShuffledEvent;
import me.jfenn.bingo.common.event.model.OptionsChangedEvent;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.options.BingoCardOptions;
import me.jfenn.bingo.common.options.BingoGoal;
import me.jfenn.bingo.common.options.OptionsService;
import me.jfenn.bingo.common.options.OptionsServiceKt;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.commands.CommandArgument;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.text.IText;
import me.jfenn.bingo.platform.text.ITextFactory;
import net.minecraft.class_124;
import net.minecraft.class_2564;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0001@B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u000e\u001a\u00020\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0019\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001d\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0013\u0010\u001e\u001a\u00020\u0018*\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001b\u0010\"\u001a\u00020\u0018*\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J!\u0010&\u001a\u00020\u0018*\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010(\u001a\u00020\u0018*\u00020\u0016H\u0002\u00a2\u0006\u0004\b(\u0010\u001fJ\u001f\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020*0)*\u00020\u0016H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0013\u0010-\u001a\u00020\u0018*\u00020\u0016H\u0002\u00a2\u0006\u0004\b-\u0010\u001fJ#\u00100\u001a\u00020\u0018*\u00020\u00162\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b0\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00102R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00103R\u0018\u00107\u001a\u000204*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0018\u0010;\u001a\u000208*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0018\u0010?\u001a\u00020<*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006A"}, d2={"Lme/jfenn/bingo/common/commands/BingoCardCommand;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "commandManager", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/platform/commands/ICommandManager;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/platform/commands/IExecutionSource;", "", "hasConfigureGame", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Z", "", "tile", "Lkotlin/Pair;", "", "getCardPosition", "(Ljava/lang/String;)Lkotlin/Pair;", "Lme/jfenn/bingo/platform/commands/IExecutionContext;", "objectiveId", "", "setObjective", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Ljava/lang/String;Ljava/lang/String;)V", "setFreeSpace", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Ljava/lang/String;)V", "setRandom", "getCardSeed", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)V", "", "seed", "setCardSeed", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;J)V", "", "itemDistInput", "setItemDist", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Ljava/util/List;)V", "rerollCard", "", "Lme/jfenn/bingo/common/card/BingoCard;", "getCardTags", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)Ljava/util/Map;", "getCardStack", "teamLabel", "cardTag", "assignTeamCard", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/common/state/BingoState;", "getState", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/card/CardService;", "getCardService", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)Lme/jfenn/bingo/common/card/CardService;", "cardService", "Lme/jfenn/bingo/common/map/CardViewService;", "getCardViewService", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nBingoCardCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoCardCommand.kt\nme/jfenn/bingo/common/commands/BingoCardCommand\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,308:1\n138#2,5:309\n138#2,5:314\n138#2,5:319\n138#2,5:324\n138#2,5:329\n138#2,5:334\n138#2,5:358\n774#3:339\n865#3,2:340\n1563#3:342\n1634#3,3:343\n360#3,7:346\n1563#3:354\n1634#3,3:355\n1563#3:363\n1634#3,3:364\n774#3:367\n865#3,2:368\n1869#3,2:370\n1563#3:372\n1634#3,3:373\n1563#3:379\n1634#3,3:380\n1#4:353\n10540#5:376\n10978#5,2:377\n10980#5,3:383\n*S KotlinDebug\n*F\n+ 1 BingoCardCommand.kt\nme/jfenn/bingo/common/commands/BingoCardCommand\n*L\n54#1:309,5\n55#1:314,5\n56#1:319,5\n86#1:324,5\n115#1:329,5\n125#1:334,5\n207#1:358,5\n145#1:339\n145#1:340,2\n146#1:342\n146#1:343,3\n148#1:346,7\n152#1:354\n152#1:355,3\n242#1:363\n242#1:364,3\n266#1:367\n266#1:368,2\n267#1:370,2\n291#1:372\n291#1:373,3\n37#1:379\n37#1:380,3\n37#1:376\n37#1:377,2\n37#1:383,3\n*E\n"})
public final class BingoCardCommand
extends BingoComponent {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private static final List<String> CARD_KEYS;
    @NotNull
    private static final Map<String, Pair<Integer, Integer>> CARD_POSITIONS;

    public BingoCardCommand(@NotNull ICommandManager commandManager, @NotNull BingoConfig config, @NotNull TextProvider text, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.config = config;
        this.text = text;
        this.eventBus = eventBus;
        commandManager.register("bingo", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand._init_$lambda$0(this, arg_0)));
    }

    private final boolean hasConfigureGame(IExecutionSource $this$hasConfigureGame) {
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME, GameState.PLAYING};
        return CommonKt.hasState($this$hasConfigureGame, gameStateArray) && CommonKt.hasPermission($this$hasConfigureGame, Permission.INSTANCE.getCONFIGURE_GAME());
    }

    private final BingoState getState(IExecutionContext $this$state) {
        Scope $this$iv = $this$state.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return (BingoState)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv, parameters$iv);
    }

    private final CardService getCardService(IExecutionContext $this$cardService) {
        Scope $this$iv = $this$cardService.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return (CardService)$this$iv.get(Reflection.getOrCreateKotlinClass(CardService.class), qualifier$iv, parameters$iv);
    }

    private final CardViewService getCardViewService(IExecutionContext $this$cardViewService) {
        Scope $this$iv = $this$cardViewService.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return (CardViewService)$this$iv.get(Reflection.getOrCreateKotlinClass(CardViewService.class), qualifier$iv, parameters$iv);
    }

    private final Pair<Integer, Integer> getCardPosition(String tile) {
        Pair pair;
        if (Intrinsics.areEqual((Object)tile, (Object)"random")) {
            pair = (Pair)CollectionsKt.random(CARD_POSITIONS.values(), (Random)((Random)Random.Default));
        } else {
            pair = CARD_POSITIONS.get(tile);
            if (pair == null) {
                throw new IllegalArgumentException("'" + tile + "' is not a valid bingo tile position: " + CARD_POSITIONS.keySet());
            }
        }
        return pair;
    }

    private final void setObjective(IExecutionContext $this$setObjective, String tile, String objectiveId) {
        Pair<Integer, Integer> pair = this.getCardPosition(tile);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        BingoCard originalCard = this.getCardViewService($this$setObjective).getPlayerCard($this$setObjective.getPlayer());
        this.getCardService($this$setObjective).replaceEntry(originalCard, x, y, objectiveId);
        Object[] objectArray = new Object[]{BingoCardCommand.Companion.tileName(x, y), objectiveId};
        $this$setObjective.sendFeedback(this.text.string(StringKey.CommandCardSetSuccess, objectArray));
    }

    private final void setFreeSpace(IExecutionContext $this$setFreeSpace, String tile) {
        Pair<Integer, Integer> pair = this.getCardPosition(tile);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        BingoCard originalCard = this.getCardViewService($this$setFreeSpace).getPlayerCard($this$setFreeSpace.getPlayer());
        this.getCardService($this$setFreeSpace).replaceEntry(originalCard, x, y, new BingoObjective.FreeSpace());
        Object[] objectArray = new Object[]{BingoCardCommand.Companion.tileName(x, y), StringKey.CardFreeSpace};
        $this$setFreeSpace.sendFeedback(this.text.string(StringKey.CommandCardSetSuccess, objectArray));
    }

    private final void setRandom(IExecutionContext $this$setRandom, String tile) {
        Pair<Integer, Integer> pair = this.getCardPosition(tile);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        BingoCard card = this.getCardViewService($this$setRandom).getPlayerCard($this$setRandom.getPlayer());
        BingoCardEntry entryToReplace = card.entry(x, y);
        Scope $this$iv = $this$setRandom.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoCard newCard = CardService.replaceEntries$default(this.getCardService($this$setRandom), card, 0L, CollectionsKt.listOf((Object)entryToReplace), CollectionsKt.toSet(((BingoObjectiveManager)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoObjectiveManager.class), qualifier$iv, parameters$iv)).listExcludedIds()), 2, null);
        BingoCardEntry newEntry = newCard.entry(x, y);
        Object[] objectArray = new Object[]{BingoCardCommand.Companion.tileName(x, y), newEntry.getObjectiveId()};
        $this$setRandom.sendFeedback(this.text.string(StringKey.CommandCardSetSuccess, objectArray));
    }

    private final void getCardSeed(IExecutionContext $this$getCardSeed) {
        BingoCard card = this.getCardViewService($this$getCardSeed).getPlayerCard($this$getCardSeed.getPlayer());
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)class_2564.method_47523((String)String.valueOf(card.getSeed())), (String)"bracketedCopyable(...)");
        $this$getCardSeed.sendFeedback(this.text.string(StringKey.CommandCardSeedGet, objectArray));
    }

    private final void setCardSeed(IExecutionContext $this$setCardSeed, long seed) {
        BingoCard card = this.getCardViewService($this$setCardSeed).getPlayerCard($this$setCardSeed.getPlayer());
        BingoCard newCard = CardService.generateCard$default(this.getCardService($this$setCardSeed), card, null, seed, 2, null);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)class_2564.method_47523((String)String.valueOf(newCard.getSeed())), (String)"bracketedCopyable(...)");
        $this$setCardSeed.sendFeedback(this.text.string(StringKey.CommandCardSeedSet, objectArray));
    }

    private final void setItemDist(IExecutionContext $this$setItemDist, List<Integer> itemDistInput) {
        Scope $this$iv = $this$setItemDist.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        OptionsService.setCardDifficulty$default((OptionsService)$this$iv.get(Reflection.getOrCreateKotlinClass(OptionsService.class), qualifier$iv, parameters$iv), OptionsServiceKt.getOptionsContext($this$setItemDist), null, itemDistInput, false, 10, null);
        this.eventBus.emit(OptionsChangedEvent.INSTANCE, Unit.INSTANCE);
    }

    private final void rerollCard(IExecutionContext $this$rerollCard) {
        Set set;
        BingoCard card = this.getCardViewService($this$rerollCard).getPlayerCard($this$rerollCard.getPlayer());
        GameState[] gameStateArray = new GameState[]{GameState.PLAYING};
        if (CommonKt.hasState($this$rerollCard, gameStateArray)) {
            Scope $this$iv = $this$rerollCard.getScope();
            Qualifier qualifier$iv = null;
            Function0<? extends ParametersHolder> parameters$iv = null;
            boolean $i$f$get = false;
            set = CollectionsKt.toSet(((BingoObjectiveManager)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoObjectiveManager.class), qualifier$iv, parameters$iv)).listExcludedIds());
        } else {
            set = SetsKt.emptySet();
        }
        Set excludedObjectives = set;
        this.getCardService($this$rerollCard).shuffleCard(card, excludedObjectives);
        $this$rerollCard.sendFeedback(this.text.string(StringKey.OptionsRerollCardSuccess));
        this.eventBus.emit(CardShuffledEvent.Companion, new CardShuffledEvent(card.getId()));
    }

    private final Map<String, BingoCard> getCardTags(IExecutionContext $this$getCardTags) {
        Map map;
        Map $this$getCardTags_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterator iterator = ((Iterable)this.getState($this$getCardTags).getCards()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            BingoCard card = (BingoCard)iterator.next();
            $this$getCardTags_u24lambda_u240.put("#" + (i + 1), card);
        }
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    private final void getCardStack(IExecutionContext $this$getCardStack) {
        Object object = new class_124[]{class_124.field_1080};
        $this$getCardStack.sendMessage(this.text.literal("Bingo Cards:").formatted((class_124[])object));
        object = ((Iterable)this.getState($this$getCardStack).getCards()).iterator();
        int n = 0;
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n2;
            Iterator<BingoCard> $i$f$mapTo22;
            Object $this$indexOfFirst$iv;
            List teams2;
            Collection collection;
            BingoCard card;
            int i;
            block9: {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                BingoTeam it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                i = n++;
                card = (BingoCard)object.next();
                Iterable iterable = this.getState($this$getCardStack).getRegisteredTeams();
                boolean $i$f$filter = false;
                void var9_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (BingoTeam)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCardId(), (Object)card.getId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (BingoTeam)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(BingoTeam.getName$default(it, this.text, false, false, false, null, 10, null));
                }
                teams2 = (List)destination$iv$iv;
                $this$indexOfFirst$iv = this.getState($this$getCardStack).getCards();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                $i$f$mapTo22 = $this$indexOfFirst$iv.iterator();
                while ($i$f$mapTo22.hasNext()) {
                    BingoCard item$iv;
                    BingoCard it2 = item$iv = $i$f$mapTo22.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it2.getId(), (Object)card.getNextCardId())) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            $this$indexOfFirst$iv = n2;
            int it22 = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl = false;
            Object nextCardIndex = it22 != -1 ? $this$indexOfFirst$iv : null;
            Iterable it22 = card.getOptions().formatGameMode();
            boolean $i$f$map = false;
            $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StringKey stringKey = (StringKey)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.text.string((StringKey)it));
            }
            List it = (List)destination$iv$iv;
            boolean bl3 = false;
            IText mode = ITextFactory.joinText$default(this.text, it, null, 2, null);
            IText goal = BingoGoal.format$default(card.getOptions().getGoal(), this.text, false, false, 6, null);
            IText itemDist = card.getOptions().formatItemDist(this.text);
            Object object2 = CollectionsKt.createListBuilder();
            List $this$getCardStack_u24lambda_u246 = object2;
            boolean bl4 = false;
            $this$getCardStack_u24lambda_u246.add(this.text.literal("  #" + (i + 1)));
            $this$getCardStack_u24lambda_u246.add(itemDist);
            $this$getCardStack_u24lambda_u246.add(mode);
            $this$getCardStack_u24lambda_u246.add(goal);
            if (!((Collection)teams2).isEmpty()) {
                $this$getCardStack_u24lambda_u246.add(this.text.joinText(teams2, this.text.literal(" ")));
            }
            if (nextCardIndex != null) {
                int n3 = i + 1;
                if ((Integer)nextCardIndex != n3) {
                    $this$getCardStack_u24lambda_u246.add(this.text.literal(" -> #" + ((Integer)nextCardIndex + 1)));
                }
            }
            Object it3 = CollectionsKt.build((List)object2);
            boolean bl5 = false;
            class_124[] class_124Array = new class_124[]{class_124.field_1080};
            it3 = object2 = this.text.joinText((List<? extends IText>)it3, this.text.literal(" | ").formatted(class_124Array));
            boolean bl6 = false;
            $this$getCardStack.sendMessage((IText)it3);
        }
    }

    private final void assignTeamCard(IExecutionContext $this$assignTeamCard, String teamLabel, String cardTag) {
        Object v0;
        block3: {
            Iterable iterable = this.getState($this$assignTeamCard).getTeams().values();
            for (Object t : iterable) {
                BingoTeam it = (BingoTeam)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getKey-zo6Dpdc(), (Object)teamLabel) || Intrinsics.areEqual((Object)BingoTeamKey.getLabel-impl(it.getKey-zo6Dpdc()), (Object)teamLabel))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        BingoTeam bingoTeam = v0;
        if (bingoTeam == null) {
            throw new IllegalArgumentException("Could not find team '" + teamLabel + "'");
        }
        BingoTeam team = bingoTeam;
        BingoCard bingoCard = this.getCardTags($this$assignTeamCard).get(cardTag);
        if (bingoCard == null) {
            throw new IllegalArgumentException("Could not find card '" + cardTag + "'");
        }
        BingoCard card = bingoCard;
        team.setCardId(card.getId());
        $this$assignTeamCard.sendFeedback(this.text.empty().append("Team ").append(BingoTeam.getName$default(team, this.text, false, false, false, null, 30, null)).append(" assigned to card " + cardTag));
    }

    private static final Unit _init_$lambda$0(BingoCardCommand this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.literal("card", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0(this$0, arg_0)));
        $this$register.literal("difficulty", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$1(this$0, arg_0)));
        $this$register.literal("reroll", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$2(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$0(this$0, arg_0)));
        $this$literal.literal("set", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1(this$0, arg_0)));
        $this$literal.literal("seed", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$2(this$0, arg_0)));
        $this$literal.literal("assign", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$3(this$0, arg_0)));
        $this$literal.literal("stack", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$0(BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.getCardViewService($this$executes).openCard($this$executes.getPlayerOrThrow());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$0(this$0, arg_0)));
        CommandBuilder.string$default($this$literal, "tile", BingoCardCommand::lambda$0$0$1$1, false, (arg_0, arg_1) -> BingoCardCommand.lambda$0$0$1$2(this$0, arg_0, arg_1), 4, null);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$0$1$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Iterable lambda$0$0$1$1(IExecutionContext $this$string, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CARD_KEYS;
    }

    private static final Unit lambda$0$0$1$2(BingoCardCommand this$0, CommandBuilder $this$string, CommandArgument tileArg) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)tileArg, (String)"tileArg");
        $this$string.string("objective", (Function2<? super IExecutionContext, ? super String, ? extends Iterable<String>>)((Function2)BingoCardCommand::lambda$0$0$1$2$0), true, (Function2<? super CommandBuilder, ? super CommandArgument<String>, Unit>)((Function2)(arg_0, arg_1) -> BingoCardCommand.lambda$0$0$1$2$1(tileArg, this$0, arg_0, arg_1)));
        $this$string.literal("random", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$2$2(this$0, tileArg, arg_0)));
        $this$string.literal("free_space", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$2$3(this$0, tileArg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Iterable lambda$0$0$1$2$0(IExecutionContext $this$string, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Scope $this$iv = $this$string.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return ((ObjectiveListService)$this$iv.get(Reflection.getOrCreateKotlinClass(ObjectiveListService.class), qualifier$iv, parameters$iv)).getAllObjectives();
    }

    private static final Unit lambda$0$0$1$2$1(CommandArgument $tileArg, BingoCardCommand this$0, CommandBuilder $this$string, CommandArgument objectiveArg) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)objectiveArg, (String)"objectiveArg");
        $this$string.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$2$1$0($tileArg, objectiveArg, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1$2$1$0(CommandArgument $tileArg, CommandArgument $objectiveArg, BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        String string = ((String)$this$executes.getArgument($tileArg)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String tile = string;
        String objectiveId = (String)$this$executes.getArgument($objectiveArg);
        this$0.setObjective($this$executes, tile, objectiveId);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1$2$2(BingoCardCommand this$0, CommandArgument $tileArg, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$2$2$0(this$0, $tileArg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1$2$2$0(BingoCardCommand this$0, CommandArgument $tileArg, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        String string = ((String)$this$executes.getArgument($tileArg)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this$0.setRandom($this$executes, string);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1$2$3(BingoCardCommand this$0, CommandArgument $tileArg, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$1$2$3$0(this$0, $tileArg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$1$2$3$0(BingoCardCommand this$0, CommandArgument $tileArg, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        String string = ((String)$this$executes.getArgument($tileArg)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this$0.setFreeSpace($this$executes, string);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$2$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$2$1(this$0, arg_0)));
        CommandBuilder.long$default($this$literal, "seed", 0L, 0L, (arg_0, arg_1) -> BingoCardCommand.lambda$0$0$2$2(this$0, arg_0, arg_1), 6, null);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$0$2$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Unit lambda$0$0$2$1(BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.getCardSeed($this$executes);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2$2(BingoCardCommand this$0, CommandBuilder $this$long, CommandArgument seedArg) {
        Intrinsics.checkNotNullParameter((Object)$this$long, (String)"$this$long");
        Intrinsics.checkNotNullParameter((Object)seedArg, (String)"seedArg");
        $this$long.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$2$2$0(this$0, seedArg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$2$2$0(BingoCardCommand this$0, CommandArgument $seedArg, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.setCardSeed($this$executes, ((Number)$this$executes.getArgument($seedArg)).longValue());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$3(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$3$0(this$0, arg_0)));
        CommandBuilder.string$default($this$literal, "team", (arg_0, arg_1) -> BingoCardCommand.lambda$0$0$3$1(this$0, arg_0, arg_1), false, (arg_0, arg_1) -> BingoCardCommand.lambda$0$0$3$2(this$0, arg_0, arg_1), 4, null);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$0$3$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Iterable lambda$0$0$3$1(BingoCardCommand this$0, IExecutionContext $this$string, String it) {
        String it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = this$0.getState($this$string).getTeams().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = ((BingoTeamKey)item$iv$iv).unbox-impl();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2);
        }
        $this$map$iv = this$0.getState($this$string).getTeams().keySet();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = ((BingoTeamKey)item$iv$iv).unbox-impl();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(BingoTeamKey.getLabel-impl(it2));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final Unit lambda$0$0$3$2(BingoCardCommand this$0, CommandBuilder $this$string, CommandArgument teamArg) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)teamArg, (String)"teamArg");
        $this$string.string("card", (Function2<? super IExecutionContext, ? super String, ? extends Iterable<String>>)((Function2)(arg_0, arg_1) -> BingoCardCommand.lambda$0$0$3$2$0(this$0, arg_0, arg_1)), true, (Function2<? super CommandBuilder, ? super CommandArgument<String>, Unit>)((Function2)(arg_0, arg_1) -> BingoCardCommand.lambda$0$0$3$2$1(teamArg, this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    private static final Iterable lambda$0$0$3$2$0(BingoCardCommand this$0, IExecutionContext $this$string, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getCardTags($this$string).keySet();
    }

    private static final Unit lambda$0$0$3$2$1(CommandArgument $teamArg, BingoCardCommand this$0, CommandBuilder $this$string, CommandArgument cardArg) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        Intrinsics.checkNotNullParameter((Object)cardArg, (String)"cardArg");
        $this$string.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$3$2$1$0($teamArg, cardArg, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$3$2$1$0(CommandArgument $teamArg, CommandArgument $cardArg, BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        String teamLabel = (String)$this$executes.getArgument($teamArg);
        String cardTag = (String)$this$executes.getArgument($cardArg);
        this$0.assignTeamCard($this$executes, teamLabel, cardTag);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$4(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$1(this$0, arg_0)));
        $this$literal.literal("push", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$2(this$0, arg_0)));
        $this$literal.literal("pop", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$3(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$0$4$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Unit lambda$0$0$4$1(BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.getCardStack($this$executes);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$4$2(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$2$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$2$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean lambda$0$0$4$2$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        if (!this$0.hasConfigureGame($this$requires)) return false;
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME};
        if (!CommonKt.hasState($this$requires, gameStateArray)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$0$0$4$2$1(BingoCardCommand this$0, IExecutionContext $this$executes) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        BingoCard prevCard = this$0.getState($this$executes).getActiveCard();
        Object object = this$0.getCardService($this$executes).newCard(BingoCardOptions.copy$default(prevCard.getOptions(), null, null, null, false, false, false, false, 127, null));
        BingoCard it = object;
        boolean $i$a$-also-BingoCardCommand$1$1$5$3$2$newCard$22 = false;
        this$0.getState($this$executes).pushCard(it);
        BingoCard newCard = object;
        object = this$0.getState($this$executes).getTeams().values();
        boolean $i$f$filter = false;
        void $i$a$-also-BingoCardCommand$1$1$5$3$2$newCard$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoTeam it2 = (BingoTeam)element$iv$iv;
            boolean bl = false;
            if (!(it2.getCardId() == null || Intrinsics.areEqual((Object)it2.getCardId(), (Object)prevCard.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BingoTeam it3 = (BingoTeam)element$iv;
            boolean bl = false;
            it3.setCardId(newCard.getId());
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$4$3(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$3$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$0$4$3$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean lambda$0$0$4$3$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        if (!this$0.hasConfigureGame($this$requires)) return false;
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME};
        if (!CommonKt.hasState($this$requires, gameStateArray)) return false;
        return true;
    }

    private static final Unit lambda$0$0$4$3$1(BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.getState($this$executes).popCard();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$1$0(this$0, arg_0)));
        Ref.ObjectRef builder = new Ref.ObjectRef();
        builder.element = $this$literal;
        List args = new ArrayList();
        for (TierLabel tier : TierLabel.getEntries()) {
            ((CommandBuilder)builder.element).integer(tier.name(), 0, 25, (Function2<? super CommandBuilder, ? super CommandArgument<Integer>, Unit>)((Function2)(arg_0, arg_1) -> BingoCardCommand.lambda$0$1$1(args, builder, arg_0, arg_1)));
        }
        ((CommandBuilder)builder.element).executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$1$2(this$0, args, arg_0)));
        for (Map.Entry<String, List<Integer>> entry : this$0.config.getDifficultyPresets().entrySet()) {
            String name2 = entry.getKey();
            List<Integer> difficulty = entry.getValue();
            $this$literal.literal(name2, (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$1$3(this$0, difficulty, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$1$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Unit lambda$0$1$1(List $args, Ref.ObjectRef $builder, CommandBuilder $this$integer, CommandArgument it) {
        Intrinsics.checkNotNullParameter((Object)$this$integer, (String)"$this$integer");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $args.add(it);
        $builder.element = $this$integer;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$0$1$2(BingoCardCommand this$0, List $args, IExecutionContext $this$executes) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        Iterable iterable = $args;
        IExecutionContext iExecutionContext = $this$executes;
        BingoCardCommand bingoCardCommand = this$0;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommandArgument commandArgument = (CommandArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)$this$executes.getArgument(it)).intValue());
        }
        collection = (List)destination$iv$iv;
        bingoCardCommand.setItemDist(iExecutionContext, (List<Integer>)collection);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$3(BingoCardCommand this$0, List $difficulty, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$1$3$0(this$0, $difficulty, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$3$0(BingoCardCommand this$0, List $difficulty, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.setItemDist($this$executes, $difficulty);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(BingoCardCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)arg_0 -> BingoCardCommand.lambda$0$2$0(this$0, arg_0)));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> BingoCardCommand.lambda$0$2$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$2$0(BingoCardCommand this$0, IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return this$0.hasConfigureGame($this$requires);
    }

    private static final Unit lambda$0$2$1(BingoCardCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.rerollCard($this$executes);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Map map;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        char[] cArray = "bingo".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] $this$flatMap$iv = cArray;
        boolean $i$f$flatMap = false;
        char[] cArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void col = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)new IntRange(1, 5);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add("" + (char)col + (int)it);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        CARD_KEYS = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"random");
        Map $this$CARD_POSITIONS_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                $this$CARD_POSITIONS_u24lambda_u240.put(BingoCardCommand.Companion.tileName(x, y), new Pair((Object)x, (Object)y));
            }
        }
        CARD_POSITIONS = MapsKt.build((Map)map);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR,\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lme/jfenn/bingo/common/commands/BingoCardCommand$Companion;", "", "<init>", "()V", "", "x", "y", "", "tileName", "(II)Ljava/lang/String;", "", "CARD_KEYS", "Ljava/util/List;", "", "Lkotlin/Pair;", "CARD_POSITIONS", "Ljava/util/Map;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        private final String tileName(int x, int y) {
            char[] cArray = "bingo".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] text = cArray;
            int row = y + 1;
            return "" + text[x] + row;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

