/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.modules.SerializersModule;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.spawn.SpawnKit;
import me.jfenn.bingo.common.spawn.SpawnKitLoader;
import me.jfenn.bingo.platform.IJsonSerializers;
import me.jfenn.bingo.platform.item.IItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001b\u0010\u0017\u001a\u00020\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001cR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnKitService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/IJsonSerializers;", "serializers", "Lme/jfenn/bingo/common/spawn/SpawnKitLoader;", "spawnKitLoader", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/IJsonSerializers;Lme/jfenn/bingo/common/spawn/SpawnKitLoader;Lme/jfenn/bingo/common/data/ScopedData;)V", "Lme/jfenn/bingo/common/spawn/SpawnKit;", "kit", "", "Lme/jfenn/bingo/platform/item/IItemStack;", "getItems", "(Lme/jfenn/bingo/common/spawn/SpawnKit;)Ljava/util/List;", "getPlayerItems", "()Ljava/util/List;", "getTeamItems", "items", "", "writePlayerItems", "(Ljava/util/List;)V", "writeTeamItems", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/IJsonSerializers;", "Lme/jfenn/bingo/common/spawn/SpawnKitLoader;", "Lme/jfenn/bingo/common/data/ScopedData;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nSpawnKitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnKitService.kt\nme/jfenn/bingo/common/spawn/SpawnKitService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1617#2,9:48\n1869#2:57\n1870#2:60\n1626#2:61\n1563#2:62\n1634#2,2:63\n1636#2:66\n1563#2:67\n1634#2,2:68\n1636#2:71\n335#3:58\n324#3:65\n324#3:70\n1#4:59\n*S KotlinDebug\n*F\n+ 1 SpawnKitService.kt\nme/jfenn/bingo/common/spawn/SpawnKitService\n*L\n18#1:48,9\n18#1:57\n18#1:60\n18#1:61\n34#1:62\n34#1:63,2\n34#1:66\n42#1:67\n42#1:68,2\n42#1:71\n20#1:58\n34#1:65\n42#1:70\n18#1:59\n*E\n"})
public final class SpawnKitService {
    @NotNull
    private final Logger log;
    @NotNull
    private final IJsonSerializers serializers;
    @NotNull
    private final SpawnKitLoader spawnKitLoader;
    @NotNull
    private final ScopedData data;

    public SpawnKitService(@NotNull Logger log, @NotNull IJsonSerializers serializers, @NotNull SpawnKitLoader spawnKitLoader, @NotNull ScopedData data) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
        Intrinsics.checkNotNullParameter((Object)spawnKitLoader, (String)"spawnKitLoader");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.log = log;
        this.serializers = serializers;
        this.spawnKitLoader = spawnKitLoader;
        this.data = data;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IItemStack> getItems(SpawnKit kit) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = kit.getItems();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Json it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonElement it = (JsonElement)element$iv$iv;
            boolean bl2 = false;
            try {
                void $this$decodeFromJsonElement$iv;
                object = this.serializers.getJson();
                JsonElement json$iv = it;
                boolean $i$f$decodeFromJsonElement = false;
                object = (IItemStack)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)$this$decodeFromJsonElement$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IItemStack.class)), json$iv);
            }
            catch (Throwable e) {
                this.log.error("[SpawnKitService] Could not parse item stack: " + it, e);
                object = null;
            }
            if (object == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<IItemStack> getPlayerItems() {
        return this.getItems(this.data.getSpawnKits().getPlayerKit());
    }

    @NotNull
    public final List<IItemStack> getTeamItems() {
        return this.getItems(this.data.getSpawnKits().getTeamKit());
    }

    /*
     * WARNING - void declaration
     */
    public final void writePlayerItems(@NotNull List<? extends IItemStack> items) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$encodeToJsonElement$iv;
            void it;
            IItemStack iItemStack = (IItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Json json = this.serializers.getJson();
            void value$iv = it;
            boolean $i$f$encodeToJsonElement = false;
            collection.add($this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)$this$encodeToJsonElement$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IItemStack.class)), (Object)value$iv));
        }
        List list = (List)destination$iv$iv;
        SpawnKit spawnKit = new SpawnKit(list);
        this.data.getSpawnKits().setPlayerKit(spawnKit);
        this.spawnKitLoader.writeSpawnKit("playerkit", spawnKit);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTeamItems(@NotNull List<? extends IItemStack> items) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$encodeToJsonElement$iv;
            void it;
            IItemStack iItemStack = (IItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Json json = this.serializers.getJson();
            void value$iv = it;
            boolean $i$f$encodeToJsonElement = false;
            collection.add($this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)$this$encodeToJsonElement$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IItemStack.class)), (Object)value$iv));
        }
        List list = (List)destination$iv$iv;
        SpawnKit spawnKit = new SpawnKit(list);
        this.data.getSpawnKits().setTeamKit(spawnKit);
        this.spawnKitLoader.writeSpawnKit("teamkit", spawnKit);
    }
}

