/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.spawn.CommonKt;
import me.jfenn.bingo.common.spawn.SpawnKitService;
import me.jfenn.bingo.common.spawn.SpreadPlayers;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.item.IItemStack;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0001=BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b(\u0010'J\u0017\u0010*\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0 2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b.\u0010/J\u001b\u00102\u001a\u00020\u001d2\f\u00101\u001a\b\u0012\u0004\u0012\u00020$00\u00a2\u0006\u0004\b2\u00103R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00104R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00105R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00106R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00107R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00108R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00109R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010:R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010;R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010<\u00a8\u0006>"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Factory;", "spreadPlayersFactory", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/common/spawn/SpawnKitService;", "spawnKitService", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/spawn/SpreadPlayers$Factory;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/common/spawn/SpawnKitService;)V", "Lme/jfenn/bingo/platform/IServerWorld;", "getSpawnDimension", "()Lme/jfenn/bingo/platform/IServerWorld;", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/platform/block/BlockPosition;", "spawnPos", "", "onSpawnpointUpdated", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/platform/block/BlockPosition;)V", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "createSpawnpoints", "()Ljava/util/concurrent/CompletableFuture;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "teleportToLobby", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "teleportPlayer", "Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult;", "getTeamSpawnpointInternal", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult;", "getTeamSpawnpointAsync", "(Lme/jfenn/bingo/common/team/BingoTeam;)Ljava/util/concurrent/CompletableFuture;", "getTeamSpawnpoint", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/block/BlockPosition;", "", "players", "giveSpawnEquipment", "(Ljava/util/List;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/spawn/SpreadPlayers$Factory;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/common/spawn/SpawnKitService;", "GetSpawnpointResult", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nSpawnService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnService.kt\nme/jfenn/bingo/common/spawn/SpawnService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1#2:270\n1#2:281\n1617#3,9:271\n1869#3:280\n1870#3:282\n1626#3:283\n1999#3,14:284\n*S KotlinDebug\n*F\n+ 1 SpawnService.kt\nme/jfenn/bingo/common/spawn/SpawnService\n*L\n160#1:281\n160#1:271,9\n160#1:280\n160#1:282\n160#1:283\n161#1:284,14\n*E\n"})
public final class SpawnService {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final SpreadPlayers.Factory spreadPlayersFactory;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @NotNull
    private final SpawnKitService spawnKitService;

    public SpawnService(@NotNull Logger log, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull BingoConfig config, @NotNull TeamService teamService, @NotNull SpreadPlayers.Factory spreadPlayersFactory, @NotNull IServerWorldFactory serverWorldFactory, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull SpawnKitService spawnKitService) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)spreadPlayersFactory, (String)"spreadPlayersFactory");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)spawnKitService, (String)"spawnKitService");
        this.log = log;
        this.options = options;
        this.state = state;
        this.config = config;
        this.teamService = teamService;
        this.spreadPlayersFactory = spreadPlayersFactory;
        this.serverWorldFactory = serverWorldFactory;
        this.serverTaskExecutor = serverTaskExecutor;
        this.spawnKitService = spawnKitService;
        for (BingoTeam team : this.state.getRegisteredTeams()) {
            BlockPosition spawnPos;
            if (team.getSpawnpoint() == null) continue;
            boolean bl = false;
            this.onSpawnpointUpdated(team, spawnPos);
        }
    }

    @NotNull
    public final IServerWorld getSpawnDimension() {
        IServerWorld iServerWorld;
        Object v0;
        block2: {
            List<IServerWorld> worlds = this.serverWorldFactory.listWorlds();
            Iterable iterable = worlds;
            for (Object t : iterable) {
                IServerWorld it = (IServerWorld)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)this.options.getSpawnDimension())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((iServerWorld = (IServerWorld)v0) == null) {
            SpawnService $this$getSpawnDimension_u24lambda_u241 = this;
            boolean bl = false;
            $this$getSpawnDimension_u24lambda_u241.log.error("[SpawnService] Could not find spawnDimension '" + $this$getSpawnDimension_u24lambda_u241.options.getSpawnDimension() + "'; defaulting to minecraft:overworld");
            iServerWorld = $this$getSpawnDimension_u24lambda_u241.serverWorldFactory.getOverworld();
        }
        return iServerWorld;
    }

    private final void onSpawnpointUpdated(BingoTeam team, BlockPosition spawnPos) {
        if (Intrinsics.areEqual((Object)team.getSpawnpoint(), (Object)spawnPos) && team.getSpawnpointTicket() != null) {
            return;
        }
        team.setSpawnpointFuture(null);
        IServerWorld.IChunkTicketHandle iChunkTicketHandle = team.getSpawnpointTicket();
        if (iChunkTicketHandle != null) {
            iChunkTicketHandle.close();
        }
        IServerWorld worldImpl = this.getSpawnDimension();
        IServerWorld.IChunkTicketHandle newTicket = worldImpl.addTicket(spawnPos.toChunkPos());
        team.setSpawnpointTicket(newTicket);
        team.setSpawnpoint(spawnPos);
    }

    @NotNull
    public final CompletableFuture<Void> createSpawnpoints() {
        CompletionStage completionStage;
        IServerWorld world = this.getSpawnDimension();
        SpreadPlayers spread = this.spreadPlayersFactory.forWorld(world);
        int distance = this.options.getSpawnDistance();
        if (distance <= 0) {
            CompletableFuture<BlockPosition> future = spread.findSpawnPosAsync((Pair<Integer, Integer>)new Pair((Object)0, (Object)0));
            for (BingoTeam team : this.state.getRegisteredTeams()) {
                team.setSpawnpointFuture(future);
                future.whenCompleteAsync((arg_0, arg_1) -> SpawnService.createSpawnpoints$lambda$1((arg_0, arg_1) -> SpawnService.createSpawnpoints$lambda$0(this, team, arg_0, arg_1), arg_0, arg_1), (Executor)this.serverTaskExecutor);
            }
            CompletionStage completionStage2 = future.thenRun(SpawnService::createSpawnpoints$lambda$2);
            Intrinsics.checkNotNull((Object)completionStage2);
            completionStage = completionStage2;
        } else {
            CompletionStage completionStage3 = ((CompletableFuture)spread.spreadAsync(this.state.getRegisteredTeams(), distance).whenCompleteAsync((arg_0, arg_1) -> SpawnService.createSpawnpoints$lambda$4((arg_0, arg_1) -> SpawnService.createSpawnpoints$lambda$3(this, arg_0, arg_1), arg_0, arg_1), (Executor)this.serverTaskExecutor)).thenRun(SpawnService::createSpawnpoints$lambda$5);
            Intrinsics.checkNotNull((Object)completionStage3);
            completionStage = completionStage3;
        }
        return completionStage;
    }

    public final void teleportToLobby(@NotNull IPlayerHandle player) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable iterable = this.serverWorldFactory.listWorlds();
            for (Object t : iterable) {
                IServerWorld it = (IServerWorld)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)ConstantsKt.getLOBBY_WORLD_IDENTIFIER())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IServerWorld lobbyWorld = v0;
        if (lobbyWorld == null) {
            this.log.error("[SpawnService] Attempted teleportToLobby, but the lobby world is null!");
            return;
        }
        BlockPosition spawn = this.state.getLobbySpawnPos();
        player.teleport(lobbyWorld, spawn.toVector3d(), this.state.getLobbySpawnYaw(), 0.0f);
        player.setSpawnPoint(lobbyWorld, spawn, this.state.getLobbySpawnYaw(), true, false);
    }

    public final void teleportPlayer(@NotNull IPlayerHandle player) {
        boolean needsTeleport;
        Object object;
        IServerWorld world;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (!this.state.isLobbyMode()) {
                    this.log.error("[SpawnService] Attempted teleportPlayer, but isLobbyMode=false!");
                    return;
                }
                world = this.getSpawnDimension();
                BingoTeam team = this.teamService.getPlayerTeam(player);
                object = team;
                if (object == null) break block5;
                BingoTeam it = object;
                boolean bl = false;
                BlockPosition blockPosition = this.getTeamSpawnpoint(team);
                object = blockPosition;
                if (blockPosition != null) break block6;
            }
            object = world.getSpawnPos();
        }
        Object spawn = object;
        boolean bl = needsTeleport = !Intrinsics.areEqual((Object)player.getServerWorld(), (Object)world) || !Intrinsics.areEqual((Object)player.getBlockPos(), (Object)spawn);
        if (!needsTeleport) {
            return;
        }
        Vector3d vector3d = ((BlockPosition)spawn).toVector3d().add(Random.Default.nextDouble(), Random.Default.nextDouble(), Random.Default.nextDouble());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        player.teleport(world, vector3d, player.getYaw(), player.getPitch());
        player.setSpawnPoint(world, (BlockPosition)spawn, 0.0f, true, false);
    }

    /*
     * WARNING - void declaration
     */
    private final GetSpawnpointResult getTeamSpawnpointInternal(BingoTeam team) {
        class_2338.class_2339 pos;
        block9: {
            IServerWorld world = this.getSpawnDimension();
            BlockPosition blockPosition = team.getSpawnpoint();
            if (blockPosition == null) {
                Object v1;
                Pair $this$maxByOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                SpawnService $this$getTeamSpawnpointInternal_u24lambda_u240 = this;
                boolean bl = false;
                $this$getTeamSpawnpointInternal_u24lambda_u240.log.warn("[SpawnService] Team " + team.getId() + " does not have a stored spawn point! Finding a new spawn position...");
                Iterable iterable = $this$getTeamSpawnpointInternal_u24lambda_u240.state.getRegisteredTeams();
                boolean $i$f$mapNotNull = false;
                void var10_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    BlockPosition it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    BingoTeam it = (BingoTeam)element$iv$iv;
                    boolean bl3 = false;
                    if (it.getSpawnpoint() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        BlockPosition it = (BlockPosition)maxElem$iv;
                        boolean bl5 = false;
                        int maxValue$iv = Math.abs(it.getX());
                        do {
                            Object e$iv = iterator$iv.next();
                            BlockPosition it2 = (BlockPosition)e$iv;
                            $i$a$-maxByOrNull-SpawnService$getTeamSpawnpointInternal$spawnpoint$1$2 = false;
                            int v$iv = Math.abs(it2.getX());
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                BlockPosition blockPosition2 = v1;
                Pair pair = blockPosition2 != null && ($this$maxByOrNull$iv = blockPosition2.toChunkPos()) != null ? $this$maxByOrNull$iv : new Pair((Object)0, (Object)0);
                int x = ((Number)pair.component1()).intValue();
                int y = ((Number)pair.component2()).intValue();
                Integer n = MathKt.getSign((int)x);
                int it = ((Number)n).intValue();
                boolean bl6 = false;
                Integer n2 = it != 0 ? n : null;
                int xSign = n2 != null ? n2 : 1;
                Pair newSpawnChunk = new Pair((Object)(x + $this$getTeamSpawnpointInternal_u24lambda_u240.options.getSpawnDistance() * xSign), (Object)y);
                return new GetSpawnpointResult.SearchChunk((Pair<Integer, Integer>)newSpawnChunk);
            }
            BlockPosition spawnpoint = blockPosition;
            pos = spawnpoint.toBlockPos().method_25503();
            do {
                class_3218 class_32182 = world.getWorld();
                Intrinsics.checkNotNull((Object)pos);
                class_2338 class_23382 = (class_2338)pos;
                class_2680 class_26802 = world.getWorld().method_8320((class_2338)pos);
                Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
                if (CommonKt.isEmptyBlock(class_32182, class_23382, class_26802)) {
                    class_3218 class_32183 = world.getWorld();
                    class_2338 class_23383 = pos.method_10084();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"up(...)");
                    class_2680 class_26803 = world.getWorld().method_8320(pos.method_10084());
                    Intrinsics.checkNotNullExpressionValue((Object)class_26803, (String)"getBlockState(...)");
                    if (CommonKt.isEmptyBlock(class_32183, class_23383, class_26803)) break block9;
                }
                pos.method_33098(pos.method_10264() + 1);
            } while (pos.method_10264() < world.getWorld().method_32819());
            this.log.warn("[SpawnService] Spawn position for team " + team + " is obstructed up to build height! Finding a new spawn position...");
            return new GetSpawnpointResult.SearchChunk(spawnpoint.toChunkPos());
        }
        BlockPosition spawnPos = BlockPosition.Companion.fromBlockPos((class_2338)pos);
        this.onSpawnpointUpdated(team, spawnPos);
        return new GetSpawnpointResult.Found(spawnPos);
    }

    @NotNull
    public final CompletableFuture<BlockPosition> getTeamSpawnpointAsync(@NotNull BingoTeam team) {
        CompletionStage<BlockPosition> completionStage;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        if (!this.state.isLobbyMode()) {
            this.log.error("[SpawnService] Attempted getTeamSpawnpointAsync, but isLobbyMode=false!");
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<BlockPosition> existingFuture = team.getSpawnpointFuture();
        if (existingFuture != null) {
            CompletionStage completionStage2 = existingFuture.thenApply(Function.identity());
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"thenApply(...)");
            return completionStage2;
        }
        GetSpawnpointResult result = this.getTeamSpawnpointInternal(team);
        if (result instanceof GetSpawnpointResult.SearchChunk) {
            IServerWorld world = this.getSpawnDimension();
            SpreadPlayers spread = this.spreadPlayersFactory.forWorld(world);
            CompletableFuture<BlockPosition> future = spread.findSpawnPosAsync(((GetSpawnpointResult.SearchChunk)result).getStartChunk());
            team.setSpawnpointFuture(future);
            CompletionStage completionStage3 = future.whenComplete((arg_0, arg_1) -> SpawnService.getTeamSpawnpointAsync$lambda$1((arg_0, arg_1) -> SpawnService.getTeamSpawnpointAsync$lambda$0(this, team, arg_0, arg_1), arg_0, arg_1));
            Intrinsics.checkNotNull((Object)completionStage3);
            completionStage = completionStage3;
        } else if (result instanceof GetSpawnpointResult.Found) {
            CompletableFuture<BlockPosition> completableFuture = CompletableFuture.completedFuture(((GetSpawnpointResult.Found)result).getPosition());
            completionStage = completableFuture;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return completionStage;
    }

    @Nullable
    public final BlockPosition getTeamSpawnpoint(@NotNull BingoTeam team) {
        BlockPosition blockPosition;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        if (!this.state.isLobbyMode()) {
            this.log.error("[SpawnService] Attempted getTeamSpawnpoint, but isLobbyMode=false!");
            return null;
        }
        GetSpawnpointResult result = this.getTeamSpawnpointInternal(team);
        if (result instanceof GetSpawnpointResult.SearchChunk) {
            IServerWorld world = this.getSpawnDimension();
            SpreadPlayers spread = this.spreadPlayersFactory.forWorld(world);
            BlockPosition spawnPos = spread.findSpawnPos(((GetSpawnpointResult.SearchChunk)result).getStartChunk());
            this.onSpawnpointUpdated(team, spawnPos);
            blockPosition = spawnPos;
        } else if (result instanceof GetSpawnpointResult.Found) {
            blockPosition = ((GetSpawnpointResult.Found)result).getPosition();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return blockPosition;
    }

    public final void giveSpawnEquipment(@NotNull List<? extends IPlayerHandle> players) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        if (!this.state.isLobbyMode()) {
            this.log.error("[SpawnService] Attempted giveSpawnEquipment, but isLobbyMode=false!");
            return;
        }
        if (!this.options.isPlayerKit()) {
            return;
        }
        List<IItemStack> itemStacks = this.spawnKitService.getPlayerItems();
        if (this.config.getPreventScoringSpawnKitItems()) {
            for (IItemStack itemStack : itemStacks) {
                itemStack.addCustomTag("bingo_ignore");
            }
        }
        for (IItemStack stack : itemStacks) {
            for (IPlayerHandle iPlayerHandle : players) {
                IItemStack playerStack = stack.copy();
                iPlayerHandle.giveOrEquipStack(playerStack);
            }
        }
    }

    private static final Unit createSpawnpoints$lambda$0(SpawnService this$0, BingoTeam $team, BlockPosition spawnPos, Throwable throwable) {
        Intrinsics.checkNotNull((Object)spawnPos);
        this$0.onSpawnpointUpdated($team, spawnPos);
        return Unit.INSTANCE;
    }

    private static final void createSpawnpoints$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void createSpawnpoints$lambda$2() {
    }

    private static final Unit createSpawnpoints$lambda$3(SpawnService this$0, Map map, Throwable throwable) {
        Intrinsics.checkNotNull((Object)map);
        for (Map.Entry entry : map.entrySet()) {
            BingoTeam team;
            String key2 = ((BingoTeamKey)entry.getKey()).unbox-impl();
            BlockPosition spawnPos = (BlockPosition)entry.getValue();
            if (this$0.state.getTeams().get(BingoTeamKey.box-impl(key2)) == null) continue;
            this$0.onSpawnpointUpdated(team, spawnPos);
        }
        return Unit.INSTANCE;
    }

    private static final void createSpawnpoints$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void createSpawnpoints$lambda$5() {
    }

    private static final Unit getTeamSpawnpointAsync$lambda$0(SpawnService this$0, BingoTeam $team, BlockPosition newSpawnPos, Throwable throwable) {
        Intrinsics.checkNotNull((Object)newSpawnPos);
        this$0.onSpawnpointUpdated($team, newSpawnPos);
        return Unit.INSTANCE;
    }

    private static final void getTeamSpawnpointAsync$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult;", "", "<init>", "()V", "Found", "SearchChunk", "Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult$Found;", "Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult$SearchChunk;", "bingo-common"})
    public static abstract class GetSpawnpointResult {
        private GetSpawnpointResult() {
        }

        public /* synthetic */ GetSpawnpointResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult$Found;", "Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult;", "Lme/jfenn/bingo/platform/block/BlockPosition;", "position", "<init>", "(Lme/jfenn/bingo/platform/block/BlockPosition;)V", "Lme/jfenn/bingo/platform/block/BlockPosition;", "getPosition", "()Lme/jfenn/bingo/platform/block/BlockPosition;", "bingo-common"})
        public static final class Found
        extends GetSpawnpointResult {
            @NotNull
            private final BlockPosition position;

            public Found(@NotNull BlockPosition position) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                super(null);
                this.position = position;
            }

            @NotNull
            public final BlockPosition getPosition() {
                return this.position;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R#\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult$SearchChunk;", "Lme/jfenn/bingo/common/spawn/SpawnService$GetSpawnpointResult;", "Lkotlin/Pair;", "", "startChunk", "<init>", "(Lkotlin/Pair;)V", "Lkotlin/Pair;", "getStartChunk", "()Lkotlin/Pair;", "bingo-common"})
        public static final class SearchChunk
        extends GetSpawnpointResult {
            @NotNull
            private final Pair<Integer, Integer> startChunk;

            public SearchChunk(@NotNull Pair<Integer, Integer> startChunk) {
                Intrinsics.checkNotNullParameter(startChunk, (String)"startChunk");
                super(null);
                this.startChunk = startChunk;
            }

            @NotNull
            public final Pair<Integer, Integer> getStartChunk() {
                return this.startChunk;
            }
        }
    }
}

