/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.map.BingoMap;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.BingoTeamPreset;
import me.jfenn.bingo.common.team.TeamScore;
import me.jfenn.bingo.common.team.TeamWinner;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IMapService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.ITeamHandle;
import me.jfenn.bingo.platform.ITeamManager;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u0015\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0018\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0018\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010.\u001a\u00020'2\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020'\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b2\u0010+R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00104R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00105R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00106R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00107R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00108R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00109R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010:R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010;R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020=0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Lme/jfenn/bingo/common/team/TeamService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/platform/ITeamManager;", "teamManager", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IMapService;", "mapService", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/platform/ITeamManager;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IMapService;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/team/BingoTeam;", "getPlayerTeam", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/common/team/BingoTeam;", "", "isPlaying", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "isTeamChosen", "team", "Lme/jfenn/bingo/common/map/BingoMap;", "getTeamMap", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/common/map/BingoMap;", "Lme/jfenn/bingo/platform/ITeamHandle;", "createTeam", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/ITeamHandle;", "teamTemplate", "", "joinTeam", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/team/BingoTeam;)V", "joinSpectators", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "", "numTeams", "shuffleTeams", "(I)V", "clearTeams", "()V", "notifyMissingTeam", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/platform/ITeamManager;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IMapService;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "", "Lnet/minecraft/class_124;", "extraTeamColors", "[Lnet/minecraft/class_124;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nTeamService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamService.kt\nme/jfenn/bingo/common/team/TeamService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1068#2:166\n1563#2:167\n1634#2,3:168\n2746#2,3:171\n1563#2:174\n1634#2,3:175\n774#2:178\n865#2,2:179\n1878#2,3:181\n*S KotlinDebug\n*F\n+ 1 TeamService.kt\nme/jfenn/bingo/common/team/TeamService\n*L\n114#1:166\n115#1:167\n115#1:168,3\n126#1:171,3\n128#1:174\n128#1:175,3\n136#1:178\n136#1:179,2\n141#1:181,3\n*E\n"})
public final class TeamService {
    @NotNull
    private final Logger log;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final ITeamManager teamManager;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IMapService mapService;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final class_124[] extraTeamColors;

    public TeamService(@NotNull Logger log, @NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull ScopedData data, @NotNull ITeamManager teamManager, @NotNull TextProvider text, @NotNull IPlayerManager playerManager, @NotNull IMapService mapService, @NotNull IPermissionsApi permissions) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)teamManager, (String)"teamManager");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)mapService, (String)"mapService");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        this.log = log;
        this.eventBus = eventBus;
        this.state = state;
        this.data = data;
        this.teamManager = teamManager;
        this.text = text;
        this.playerManager = playerManager;
        this.mapService = mapService;
        this.permissions = permissions;
        class_124[] class_124Array = new class_124[]{class_124.field_1062, class_124.field_1058, class_124.field_1079, class_124.field_1077, class_124.field_1064};
        this.extraTeamColors = class_124Array;
    }

    @Nullable
    public final BingoTeam getPlayerTeam(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ITeamHandle iTeamHandle = this.teamManager.getPlayerTeam(player.getPlayer());
        if (iTeamHandle == null) {
            return null;
        }
        ITeamHandle team = iTeamHandle;
        return this.state.getTeams().get(BingoTeamKey.box-impl(BingoTeamKey.constructor-impl(team.getName())));
    }

    public final boolean isPlaying(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getPlayerTeam(player) != null;
    }

    public final boolean isTeamChosen(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.isPlaying(player) || this.state.getPlayersSpectatingIds().contains(player.getUuid());
    }

    @NotNull
    public final BingoMap getTeamMap(@NotNull BingoTeam team) {
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        BingoMap bingoMap = team.getMap();
        if (bingoMap == null) {
            TeamService $this$getTeamMap_u24lambda_u240 = this;
            boolean bl = false;
            BingoMap map = new BingoMap($this$getTeamMap_u24lambda_u240.mapService.getNextMapId());
            $this$getTeamMap_u24lambda_u240.log.info("Creating a map for team " + team.getKey-zo6Dpdc() + " - mapId=" + map.getMapId());
            team.setMap(map);
            bingoMap = map;
        }
        return bingoMap;
    }

    private final ITeamHandle createTeam(BingoTeam team) {
        return this.teamManager.createTeam(team.getId(), team.getSimpleName(), team.getTextColor());
    }

    public final void joinTeam(@NotNull IPlayerHandle player, @NotNull BingoTeam teamTemplate) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)teamTemplate, (String)"teamTemplate");
        BingoTeam bingoTeam = this.getPlayerTeam(player);
        String string = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
        String string2 = teamTemplate.getKey-zo6Dpdc();
        String string3 = string;
        if (string3 == null ? false : BingoTeamKey.equals-impl0(string3, string2)) {
            return;
        }
        BingoTeam team = this.state.registerTeam(teamTemplate);
        PlayerProfile playerProfile = player.getProfile();
        Object object = this.getPlayerTeam(player);
        if (object != null && (object = ((BingoTeam)object).getPlayers()) != null) {
            object.remove(playerProfile);
        }
        this.state.getPlayersSpectatingIds().remove(player.getUuid());
        this.teamManager.setPlayerTeam(player.getPlayer(), this.createTeam(team));
        team.getPlayers().add(playerProfile);
        Object[] objectArray = new Object[]{BingoTeam.getName$default(team, this.text, false, false, false, null, 30, null)};
        IText iText = this.text.string(StringKey.LobbyTeamChanged, objectArray);
        objectArray = new class_124[]{class_124.field_1054};
        player.sendMessage(iText.formatted((class_124[])objectArray));
        this.eventBus.emit(TeamChangedEvent.Companion, new TeamChangedEvent(player, team));
    }

    public final void joinSpectators(@NotNull IPlayerHandle player) {
        boolean addedToSpectators;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BingoTeam team = this.getPlayerTeam(player);
        if (team != null) {
            this.teamManager.setPlayerTeam(player.getPlayer(), null);
            boolean removed = team.getPlayers().remove(player.getProfile());
            if (removed) {
                this.eventBus.emit(TeamChangedEvent.Companion, new TeamChangedEvent(player, null));
            }
        }
        if (addedToSpectators = this.state.getPlayersSpectatingIds().add(player.getUuid())) {
            class_124[] class_124Array = new class_124[]{class_124.field_1054};
            player.sendMessage(this.text.string(StringKey.LobbyTeamSpectators).formatted(class_124Array));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void shuffleTeams(int numTeams) {
        void $this$forEachIndexed$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object[] $this$mapTo$iv$iv;
        this.state.getTeams().clear();
        Iterable $this$sortedByDescending$iv = CollectionsKt.shuffled((Iterable)this.data.getTeamPresets().entrySet());
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
            final /* synthetic */ TeamService this$0;
            {
                this.this$0 = teamService;
            }

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Object object = TeamService.access$getState$p(this.this$0).getTeams().get(it.getKey());
                int n = object != null && (object = ((BingoTeam)object).getPlayers()) != null ? object.size() : 0;
                it = (Map.Entry)a;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                Object object2 = TeamService.access$getState$p(this.this$0).getTeams().get(it.getKey());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(object2 != null && (object2 = ((BingoTeam)object2).getPlayers()) != null ? object2.size() : 0));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        class_124[] destination$iv$iv = (class_124[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)t;
            class_124[] class_124Array = destination$iv$iv;
            boolean bl = false;
            class_124Array.add(BingoTeam.Companion.fromPreset-3J0cPAY(((BingoTeamKey)it.getKey()).unbox-impl(), (BingoTeamPreset)it.getValue()));
        }
        List teams2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int i = teams2.size();
        if (i <= numTeams) {
            while (true) {
                class_124 class_1242;
                Object color2;
                Object $i$f$mapTo22;
                String string;
                IText iText;
                boolean bl;
                String string2;
                block14: {
                    $this$mapTo$iv$iv = new Object[]{String.valueOf(i)};
                    destination$iv$iv = this.extraTeamColors;
                    string2 = null;
                    bl = false;
                    iText = this.text.string(StringKey.TeamName, $this$mapTo$iv$iv);
                    string = "temp_bingo_" + i;
                    $i$f$mapTo22 = destination$iv$iv;
                    int n = ((class_124[])$i$f$mapTo22).length;
                    for (int j = 0; j < n; ++j) {
                        boolean bl2;
                        class_124 it;
                        block13: {
                            color2 = it = $i$f$mapTo22[j];
                            boolean bl3 = false;
                            Iterable $this$none$iv = teams2;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    BingoTeam it2 = (BingoTeam)element$iv;
                                    boolean bl4 = false;
                                    if (!(it2.getTextColor() == color2)) continue;
                                    bl2 = false;
                                    break block13;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) continue;
                        class_1242 = it;
                        break block14;
                    }
                    class_1242 = null;
                }
                class_124 class_1243 = class_1242;
                String string3 = string;
                IText iText2 = iText;
                boolean bl3 = bl;
                String string4 = string2;
                class_124 class_1244 = class_1243;
                if (class_1244 == null) {
                    void $this$mapTo$iv$iv2;
                    void $this$shuffleTeams_u24lambda_u243;
                    $i$f$mapTo22 = this;
                    string2 = string4;
                    bl = bl3;
                    iText = iText2;
                    string = string3;
                    boolean bl6 = false;
                    Iterable iterable2 = $this$shuffleTeams_u24lambda_u243.data.getTeamPresets().values();
                    boolean $i$f$map2 = false;
                    color2 = iterable2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        Object element$iv;
                        element$iv = (BingoTeamPreset)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl7 = false;
                        collection.add(it.getColor());
                    }
                    class_1243 = (class_124)CollectionsKt.random((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Object[])$this$shuffleTeams_u24lambda_u243.extraTeamColors), (Random)((Random)Random.Default));
                    string3 = string;
                    iText2 = iText;
                    bl3 = bl;
                    string4 = string2;
                    class_1244 = class_1243;
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 65472;
                Set set = null;
                BingoMap bingoMap = null;
                List list = null;
                BlockPosition blockPosition = null;
                BlockPosition blockPosition2 = null;
                List list2 = null;
                TeamWinner teamWinner = null;
                TeamScore teamScore = null;
                TeamScore teamScore2 = null;
                UUID uUID = null;
                boolean bl4 = true;
                class_124 class_1245 = class_1244;
                String string5 = string4;
                boolean bl5 = bl3;
                IText iText3 = iText2;
                String string6 = string3;
                BingoTeam temporaryTeam = new BingoTeam(string6, iText3, bl5, string5, class_1245, bl4, uUID, teamScore2, teamScore, teamWinner, list2, blockPosition2, blockPosition, list, bingoMap, set, n, defaultConstructorMarker);
                teams2.add(temporaryTeam);
                if (i == numTeams) break;
                ++i;
            }
        }
        Iterable temporaryTeam = this.playerManager.getPlayers();
        boolean $i$f$filter232 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!(!this.state.getPlayersSpectatingIds().contains(it.getUuid()))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv3;
        int playersPerTeam = (int)Math.ceil((double)players.size() / (double)RangesKt.coerceIn((int)numTeams, (int)1, (int)teams2.size()));
        Iterable $i$f$filter232 = CollectionsKt.chunked((Iterable)CollectionsKt.shuffled((Iterable)players), (int)playersPerTeam);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object t : $this$forEachIndexed$iv) {
            void teamPlayers;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List it = (List)t;
            int i2 = n;
            boolean bl = false;
            BingoTeam teamTemplate = (BingoTeam)teams2.get(i2 % teams2.size());
            for (IPlayerHandle teamPlayer : teamPlayers) {
                this.joinTeam(teamPlayer, teamTemplate);
            }
        }
    }

    public final void clearTeams() {
        Iterator iterator = SetsKt.plus(this.data.getTeamPresets().keySet(), (Iterable)this.state.getTeams().keySet()).iterator();
        while (iterator.hasNext()) {
            String team = ((BingoTeamKey)iterator.next()).unbox-impl();
            this.teamManager.deleteTeam(team);
        }
        this.state.getTeams().clear();
    }

    public final void notifyMissingTeam(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        IText title = this.text.string(StringKey.CommandStartJoinATeam);
        Object[] objectArray = new Object[]{"/join"};
        IText message = this.text.string(StringKey.CommandStartJoinATeamMessage, objectArray);
        if (this.permissions.hasPermission(player, Permission.INSTANCE.getCOMMAND_JOIN())) {
            player.sendTitle(title, message);
        }
    }

    public static final /* synthetic */ BingoState access$getState$p(TeamService $this) {
        return $this.state;
    }
}

