/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.client.platform.INativeImage;
import me.jfenn.bingo.client.platform.INativeImageFactory;
import me.jfenn.bingo.common.map.CardImagePacket;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoCardImageController;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/client/platform/INativeImageFactory;", "nativeImageFactory", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "hudState", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "packetEvents", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/client/platform/INativeImageFactory;Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/client/platform/ClientPacket;", "Lme/jfenn/bingo/common/map/CardImagePacket;", "packet", "", "updateCardImage", "(Lme/jfenn/bingo/client/platform/ClientPacket;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/client/platform/INativeImageFactory;", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoCardImageController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoCardImageController.kt\nme/jfenn/bingo/client/common/hud/BingoCardImageController\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,50:1\n382#2,7:51\n*S KotlinDebug\n*F\n+ 1 BingoCardImageController.kt\nme/jfenn/bingo/client/common/hud/BingoCardImageController\n*L\n36#1:51,7\n*E\n"})
public final class BingoCardImageController {
    @NotNull
    private final Logger log;
    @NotNull
    private final INativeImageFactory nativeImageFactory;
    @NotNull
    private final BingoHudState hudState;

    public BingoCardImageController(@NotNull Logger log, @NotNull INativeImageFactory nativeImageFactory, @NotNull BingoHudState hudState, @NotNull ClientPacketEvents packetEvents, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)nativeImageFactory, (String)"nativeImageFactory");
        Intrinsics.checkNotNullParameter((Object)hudState, (String)"hudState");
        Intrinsics.checkNotNullParameter((Object)packetEvents, (String)"packetEvents");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.nativeImageFactory = nativeImageFactory;
        this.hudState = hudState;
        eventBus.register((IReturnEvent)packetEvents.getCardImageV1(), p0$packet -> {
            this.updateCardImage((ClientPacket<CardImagePacket>)p0$packet);
            return Unit.INSTANCE;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateCardImage(ClientPacket<CardImagePacket> packet) {
        Object object;
        void $this$getOrPut$iv;
        Object it;
        CardImagePacket image2 = packet.component1();
        if (image2.getImage() == null) {
            INativeImage nativeImage;
            this.log.info("[BingoCardImageController] Removing card image " + image2.getId());
            INativeImage iNativeImage = nativeImage = this.hudState.getImages().remove(image2.getId());
            if (iNativeImage != null) {
                iNativeImage.close();
            }
            return;
        }
        this.log.info("[BingoCardImageController] Loading card image " + image2.getId());
        Closeable closeable = new ByteArrayInputStream(image2.getImage());
        Object object2 = null;
        try {
            it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            it = ImageIO.read((InputStream)it);
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Object png = it;
        object2 = this.hudState.getImages();
        String key$iv = image2.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            INativeImage answer$iv = this.nativeImageFactory.create(((BufferedImage)png).getWidth(), ((BufferedImage)png).getHeight());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        INativeImage nativeImage = (INativeImage)object;
        int n = ((BufferedImage)png).getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = ((BufferedImage)png).getHeight();
            for (int y = 0; y < n2; ++y) {
                nativeImage.setPixel(x, y, ((BufferedImage)png).getRGB(x, y));
            }
        }
        nativeImage.upload();
    }
}

